/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-explore.
 * 
 *   Swac-explore is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-explore.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _EXPLORER_STATIC_HH
#define _EXPLORER_STATIC_HH

#include <gtkmm/window.h>
#include <gtkmm/imagemenuitem.h>
#include <gtkmm/menu.h>
#include <gtkmm/menuitem.h>
#include <gtkmm/menubar.h>
#include <gtkmm/entry.h>
#include <gtkmm/toolitem.h>
#include <gtkmm/toolbutton.h>
#include <gtkmm/separatortoolitem.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/combobox.h>
#include <gtkmm/treeview.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/statusbar.h>
#include <gtkmm/image.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treestore.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/treemodel.h>

#include "macros.inc"

class ModelListView : public Gtk::TreeModel::ColumnRecord {
public:
	SOUNDS_LIST_VARS;
};

class ModelListBox : public Gtk::TreeModel::ColumnRecord {
public:
	ModelListBox() { 
		add(caption); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
};

class ModelListExt : public Gtk::TreeModel::ColumnRecord {
public:
	ModelListExt() { 
		add(caption); 
		add(value); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
	Gtk::TreeModelColumn<Glib::ustring> value;
};

class ModelListSoundInfo : public Gtk::TreeModel::ColumnRecord {
public:
	ModelListSoundInfo() { 
		add(caption); 
		add(value); 
		add(weight); 
	};
	Gtk::TreeModelColumn<Glib::ustring> caption;
	Gtk::TreeModelColumn<Glib::ustring> value;
	Gtk::TreeModelColumn<int> weight;
};

class ExplorerStatic : public Gtk::Window {  
public:
        Gtk::Entry entry3;
        Gtk::ToolItem toolitem1;

        Gtk::Image tool_search_icon;
        Gtk::ToolItem tool_search_item;

        Gtk::SeparatorToolItem separatortoolitem1;
        Gtk::SeparatorToolItem separatortoolitem2;
        Gtk::SeparatorToolItem separatortoolitem3;
        Gtk::ToolButton toolbutton1;
        Gtk::ToolButton toolbutton2;
        Gtk::ToolButton toolbutton5;
        Gtk::Toolbar toolbar1;
        Gtk::ComboBox combobox1;
        Gtk::ComboBox combobox2;
        Gtk::ScrolledWindow scrolledwindow2;
        Gtk::VBox vbox2;
        Gtk::ScrolledWindow scrolledwindow3;
        Gtk::ScrolledWindow scrolledwindow4;
        Gtk::TreeView treeview1;
        Gtk::TreeView treeview2;
        Gtk::TreeView treeview3;
        Gtk::VPaned vpaned1;
        Gtk::HPaned hpaned1;
        Gtk::Statusbar statusbar1;
        Gtk::VBox vbox1;

	Glib::RefPtr<Gdk::Pixbuf> icon;

	ModelListView listview;	
	ModelListBox listbox;	
	ModelListExt listext;	
	ModelListSoundInfo listsoundinfo;	

	Glib::RefPtr<Gtk::ListStore> store_sounds;
	Glib::RefPtr<Gtk::ListStore> store_index;
	Glib::RefPtr<Gtk::ListStore> store_lang;
	Glib::RefPtr<Gtk::ListStore> store_fields;
	Glib::RefPtr<Gtk::TreeStore> store_info;

	SOUND_INFO_VARS;

protected:
        ExplorerStatic();
};

#endif
