/* ------------------------------------------------------------------------- */
/*                                                                           */
/* [xml_io.h]             curl Wrapper                                       */
/*                  - fetch files identified by an URL -                     */
/*                                                                           */
/* Copyright (c) 2003 by D\olle, Manns.                                      */
/* ------------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef xml_io_INCL
#define xml_io_INCL


#include "standard.h"
#include "xml_dfn.h"
#include "gstream.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   The module [xml_io] uses the library libcurl to fetch files identified
   by an URL.
*/

/* ---------------------------- Init & Quit --------------------------------- */

c_bool XML_io_init()
/* init URL-based I/O; to be called once during application setup */
;

void XML_io_quit()
/* quit URL-based I/O; to be called once during application cleanup */
;


/* ----------------------------- Creation & Disposal ------------------------- */

UrlHdl_T XML_io_create_handle()
/* create a new handle to access URL-based resources;
   RC: handle or NULL
*/
;

void XML_io_drop_handle(UrlHdl_T hdl); /* drop handle 'hdl'                 */

/* ----------------------------- URL Access ---------------------------------- */

c_bool XML_io_download
       (
         UrlHdl_T hdl, c_string url, c_string auth,
         GStream_T stream, void (*prMsg)(c_string msg)
       )
/* download resource 'url' and put it to 'stream';
   optionally, use 'auth' (format: user:passwd) for authorisation
   and 'prMsg' as error callback
*/
;



#ifdef __cplusplus
}
#endif

#endif
