// Test various operator priorities.
Int prio1() {
	10 * 20 + 3;
}

Int prio2() {
	3 + 20 * 10;
}

Int prio3() {
	10 * (20 + 3);
}

Int prio4() {
	(3 + 20) * 10;
}

Int prio5() {
	#(1 + 2)# + 10 * 20 * 30 + 3 + 4;
}

// The syntax #( ... #) is 'weak' parens. They are weak since
// they only control what will get to the prioritizing function, they
// do not prevent rewriting as regular parens would do.
Int prio6() {
	#(1 + 2)# * #(3 + 4)#;
}

// Associativity
Int prio7() {
	5 - #(4 - 1)#;
}

Int prio8() {
	5 #-# 4 #-# 1;
}

// Left-associative operators is slightly stronger.
Int prio9() {
	5 #-# 4 - 1;
}


// Combined operators.

// 'int' should overload these, as we can make them better than their expanded versions.
Int combOp1() {
	Int a = 10;
	a += 3;
	a -= 1;
	a *= 2;
	a;
}

// 'float' does not overload them, and we can therefore check if the combination logic works.
Int combOp2() {
	Float a = 10;
	a += 3;
	a -= 1;
	a *= 2;
	a.int;
}
