7.3 Parametry Przesuwne

# Parametry Przesuwne

Podczas poznawania parametrów syntezatorów i efektów, być może udało 
Ci się zauważyć, że kilka nazw parametrów ma kończy się na `_slide`. 
Być może nawet próbowałeś korzystać z nich i nie zauważyłeś żadnego 
efektu. Dzieje się tak ponieważ nie są one normalnymi parametrami, 
są to specjalne parametry, które działają tylko gdy kontrolujesz 
syntezatory w sposób jaki pokazaliśmy w poprzedniej sekcji.

Przyjrzyjmy się następującemu przykładowi:

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

W powyższym przykładzie słyszymy jak wysokość tonu (pitch) zmienia się 
przy każdym uruchomieniu polecenia `control`. Może się jednak zdarzyć, 
że będziemy chcieli aby zmiana tonu nastąpiła w sposób płynny (tak jakbyśmy 
użyli do tego suwaka). Tak samo jak kontrolujemy zmianę tonu parametrem 
`note:`, aby dodać płynne przejście, musimy ustawić na syntezatorze parametr 
`note_slide`: 

```
s = play 60, release: 5, note_slide: 1
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Teraz słyszymy, że pomiędzy poszczególnymi wywołaniami poleceń 
`control` nuty są "naciągane". Brzmi to całkiem fajnie, prawda?
Możesz przyśpieszyć płynne przejście pomiędzy nutami używająć 
krótszego czasu, np. `note_slide: 0.2', albo zwolnić je, używająć 
dłuższego czasu przejścia (ślizgania). 

Każdy z parametrów, który może być kontrolowany posiada odpowiadający 
my parametr typu `_slide`, z którego możesz korzystać. 

## Ślizganie jest lepkie

Gdy już raz ustawimy parametr typu `_slide` na uruchomionym 
syntezatorze, to zostanie on zapamiętany i ta wartość będzie wykorzystywana 
za każdym razem gdy będziesz zmieniał płynnie wartość odpowiedającego 
mu parametru. Aby zatrzymać płynne przejścia musisz ustawić wartość 
parametru `_slide` na 0 przed kolejnym wywołaniem polecenia `control`. 

## Płynne Przejścia w Parametrach Efektów

Są również możliwe płynne przejścia dla parametrów efektów: 

```
with_fx :wobble, phase: 1, phase_slide: 5 do |e|
  use_synth :dsaw
  play 50, release: 5
  control e, phase: 0.025
end
```

Spróbuj teraz pobawić się płynnymi przejściami aby spróbować dokonać 
płynnych przejść i płynnej kontroli...
