//  
// Copyright (C) 2006 SIPez LLC. 
// Licensed to SIPfoundry under a Contributor Agreement. 
//
// Copyright (C) 2004-2006 SIPfoundry Inc.
// Licensed by SIPfoundry under the LGPL license.
//
// Copyright (C) 2004-2006 Pingtel Corp.  All rights reserved.
// Licensed to SIPfoundry under a Contributor Agreement.
//
// $$
///////////////////////////////////////////////////////////////////////////////


#ifndef _MpPlayerListener_h_
#define _MpPlayerListener_h_

// SYSTEM INCLUDES
// APPLICATION INCLUDES
#include "mp/MpPlayerEvent.h"

// DEFINES
// MACROS
// EXTERNAL FUNCTIONS
// EXTERNAL VARIABLES
// CONSTANTS
// STRUCTS
// TYPEDEFS
// FORWARD DECLARATIONS
class MpPlayer; 


//:Listener interface for the MpPlayer object. 
class MpPlayerListener
{
/* //////////////////////////// PUBLIC //////////////////////////////////// */
public:
/* ============================ CREATORS ================================== */
///@name Creators
//@{
   virtual ~MpPlayerListener() {};
//@}

/* ============================ MANIPULATORS ============================== */
///@name Manipulators
//@{
   virtual void playerRealized(MpPlayerEvent& event) = 0 ;
     //: The player has been realized

   virtual void playerPrefetched(MpPlayerEvent& event) = 0 ;
     //: The player's data source has been prefetched

   virtual void playerPlaying(MpPlayerEvent& event) = 0 ;
     //: The player has begun playing.

   virtual void playerPaused(MpPlayerEvent& event) = 0 ;
     //: The player has been paused

   virtual void playerStopped(MpPlayerEvent& event) = 0 ;
     //: The player has been stopped

   virtual void playerFailed(MpPlayerEvent& event) = 0 ;
     //: The player has failed

//@}

/* ============================ ACCESSORS ================================= */
///@name Accessors
//@{

//@}

/* ============================ INQUIRY =================================== */
///@name Inquiry
//@{

//@}

/* //////////////////////////// PROTECTED ///////////////////////////////// */
protected:


/* //////////////////////////// PRIVATE /////////////////////////////////// */
private:
};

/* ============================ INLINE METHODS ============================ */

#endif  // _MpPlayerListener_h_
