/*
 *  Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2019-2019 - ESI Group - Cedric Delamarre
 *
 * This file is hereby licensed under the terms of the GNU GPL v2.0,
 * pursuant to article 5.3.4 of the CeCILL v.2.1.
 * This file was originally licensed under the terms of the CeCILL v2.1,
 * and continues to be available under such terms.
 * For more information, see the COPYING file which you should have received
 * along with this program.
 *
 */

#ifndef __PARSECOMMAND_HXX__
#define __PARSECOMMAND_HXX__
#include <string>

#include "exp.hxx"

#include "dynlib_core.h"

/*** Parse a command
 * command: input, string to parse
 * tree: output, the tree generated by the scilab parser if no error else nullptr
 *
 * return the error message or nullptr
 * the message MUST be delete by the caller
 *
 ***/
CORE_IMPEXP char* parseCommand(const char* command,  void** tree);
CORE_IMPEXP char* checkCommand(const char* command);

/*** Parse a file
 * file: input, file name
 * program: input, program name (ie: exec)
 * tree: output, the tree generated by the scilab parser if no error else nullptr
 *
 * return the error message or nullptr
 * the message MUST be delete by the caller
 *
 ***/
CORE_IMPEXP char* parseFile(const char* file, const char* program, void** tree);
CORE_IMPEXP char* checkFile(const char* file, const char* program);



#endif /* !__PARSECOMMAND_HXX__ */
