from __future__ import print_function
from _mock import _Mock




compilers = _Mock()

os = _Mock()



class GnuFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'gnu'
  description = 'GNU Fortran 77 compiler'
  exe_extension = ''
  g2c = 'g2c'
  library_switch = '-o '
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'
  suggested_f90_compiler = 'gnu95'

class VastFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'vast'
  description = 'Pacific-Sierra Research Fortran 90 Compiler'
  exe_extension = ''
  g2c = 'g2c'
  library_switch = '-o '
  obj_extension = '.o'
  object_switch = ' && function _mvfile { mv -v `basename $1` $1 ; } && _mvfile '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'
  suggested_f90_compiler = 'gnu95'
  version_pattern = '\\s*Pacific-Sierra Research vf90 (Personal|Professional)\\s+(?P<version>[^\\s]*)'

