/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef INPUTRICHTEXTWGT_H
#define INPUTRICHTEXTWGT_H

#include <QWidget>
#include <QTextDocument>
#include <QAction>
#include <QColor>
#include <QToolBar>
#include <QGridLayout>

#include "inputtextwgt.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class InputRichTextWgt : public QWidget
{
  Q_OBJECT
  private:
    InputTextWgt* m_inputText;

  public:
    InputRichTextWgt(QWidget *parent = 0);
    ~InputRichTextWgt();

    QString toPlainText    () const {return m_inputText->toPlainText();}
    QTextDocument* document() const {return m_inputText->document();}
    void clear();

    void mergeFormat(const QTextCharFormat&);

  public slots:
    void changeTextCharMap(){m_inputText->changeTextCharMap();}
    void sendMsg          (){m_inputText->sendMsg();}
    void append(const QString & str){ m_inputText->append(str);}
    void setFocus         () {m_inputText->setFocus();}

    void setBold      (bool);
    void setItalic    (bool);
    void setUnderline (bool);
    void setColor     (const QColor&);
    void setFontFamily(const QString&);
    void setFontSize  (const QString&);
    void setTextStyle (int);
    void createTable  (uint, uint);

  signals:
    void wantSend();
    void currentCharFormatChanged(const QTextCharFormat &);
};

#endif
