/***************************************************************************
 *
 * $Header: $
 *
 * MODULE DESCRIPTION: 
 * This module specializes the RTEMS Network configuration for the omniORB 
 * examples. This is a very specialized file to match the environment being
 * used, so update it to match your target.
 *
 * This file was based on "networkconfig.h" that comes with the netdemos
 * examples that ships with the RTEMS distribution.
 *
 * IMPORTANT NOTE: This file must be modified to match your environment.
 *
 * by: Rosimildo da Silva:
 *     rdasilva@connecttel.com
 *     http://www.connecttel.com
 *
 * MODIFICATION/HISTORY:
 *
 * $Log: $
 ****************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


/*
#define RTEMS_USE_BOOTP
*/

#include <stdio.h>
#include <rtems/rtems_bsdnet.h>

//
//  **** BEGIN VERY TARGET SPECIFIC SECTION, PLEASE UPDATE VALUES
//       TO MATCH THE ENVIRONMENT THAT YOU ARE USING 
//

/*
 * Define RTEMS_SET_ETHERNET_ADDRESS if you want to specify the
 * Ethernet address here.  If RTEMS_SET_ETHERNET_ADDRESS is not
 * defined the driver will choose an address.
 */
#define RTEMS_SET_ETHERNET_ADDRESS
#if (defined (RTEMS_SET_ETHERNET_ADDRESS))
static char ethernet_address[6] = { 0x20, 0x00, 0x27, 0xAF, 0x03, 0x51 };
#endif

//
// network driver used id for 3COM 3C5X9 adapter, so please change this
// to conform with the network card of your target...
//
#undef  RTEMS_BSP_NETWORK_DRIVER_NAME
#define RTEMS_BSP_NETWORK_DRIVER_NAME  "ep0"
extern int rtems_3c509_driver_attach( struct rtems_bsdnet_ifconfig *config );
#undef  RTEMS_BSP_NETWORK_DRIVER_ATTACH
#define RTEMS_BSP_NETWORK_DRIVER_ATTACH rtems_3c509_driver_attach


//
// IMPORTANT NOTE: *** CHANGE THIS TO MATCH YOUR ENVIRONMENT ****
// I have defined these macros start with RTEMS_TARGET_* to let you
// know that they must be changed to conform with the network
// environment that you use to test your target...
//
#define  RTEMS_TARGET_IP           "192.168.0.11"
#define  RTEMS_TARGET_NET_MASK     "255.255.255.0"
#define  RTEMS_TARGET_HOSTNAME     "rtems_pc"
#define  RTEMS_TARGET_DOMAIN       "foo.com"
#define  RTEMS_TARGET_GATEWAY      "192.168.0.1"
#define  RTEMS_TARGET_LOG_HOST     "192.168.0.1"
// my road-runner DNS list, please change this...
#define  RTEMS_TARGET_DNS_LIST     {"24.93.35.32", "24.93.35.32", "24.128.1.80"}

//
// These parameters are passed to the ORB, and they
// should match with the values used on the host
// where "omniNames is running".
//
#define  HOST_OMNINAMES_HOST_NAME     "omniNames_host"
#define  HOST_OMNINAMES_PORT_NUMBER   "6000"

/*
 * Table to initialize /etc/hosts config file.
 * It holds the list of hosts that would be known locally 
 * on the target.
 *
 * IMPORTANT NOTE: This is very specific of my environment, and
 *                 everyone should have its on list of hosts.
 */
// IMPORTANT: ** CHANGE THIS FOR YOUR TARGET **
static const char *etc_hosts[] =
{
  "/etc/hosts",
  "127.0.0.1     localhost\n",

  /* IMPORTANT NOTE: *** CHANGE THIS TO MATCH YOUR ENVIRONMENT ****  */
  /*
   * replace this with the IP and HOSTANE of target used above.
   */
  "192.168.0.11  rtems_pc\n",

  /* name of the host where the omniNames runs */
  "192.168.0.2   omniNames_host\n",
  0
};


//
//  **** END OF VERY TARGET SPECIFIC SECTION
//



/*
 * Loopback interface
 */
extern int rtems_bsdnet_loopattach();
static struct rtems_bsdnet_ifconfig loopback_config = {
	"lo0",				/* name */
	rtems_bsdnet_loopattach,	/* attach function */

	NULL,                /* link to next interface */

	"127.0.0.1",			/* IP address */
	"255.0.0.0",			/* IP net mask */
};

/*
 * Default network interface
 */
static struct rtems_bsdnet_ifconfig netdriver_config = 
{
   RTEMS_BSP_NETWORK_DRIVER_NAME,      /* name */
	RTEMS_BSP_NETWORK_DRIVER_ATTACH,    /* attach function */

   &loopback_config,  /* link to next interface */

#if (defined (RTEMS_USE_BOOTP))
	NULL,				/* BOOTP supplies IP address */
	NULL,				/* BOOTP supplies IP net mask */
#else
	RTEMS_TARGET_IP,		      /* IP address */
	RTEMS_TARGET_NET_MASK,		/* IP net mask */
#endif /* !RTEMS_USE_BOOTP */

#if (defined (RTEMS_SET_ETHERNET_ADDRESS))
	ethernet_address,     /* Ethernet hardware address */
#else
	NULL,       /* Driver supplies hardware address */
#endif
	0				/* Use default driver parameters */
};

/*
 * Network configuration
 */
struct rtems_bsdnet_config rtems_bsdnet_config = {
	&netdriver_config,

#if (defined (RTEMS_USE_BOOTP))
	rtems_bsdnet_do_bootp,
#else
	NULL,
#endif

	0,			/* Default network task priority */
	0,			/* Default mbuf capacity */
	0,			/* Default mbuf cluster capacity */

#if (!defined (RTEMS_USE_BOOTP))
   RTEMS_TARGET_HOSTNAME 	,  /* Host name */
   RTEMS_TARGET_DOMAIN   	,	/* Domain name */
   RTEMS_TARGET_GATEWAY  	,	/* Gateway */
   RTEMS_TARGET_LOG_HOST 	,	/* Log host */
   RTEMS_TARGET_DNS_LIST  ,	/* Name server(s) */
#endif /* !RTEMS_USE_BOOTP */

};

#ifdef __cplusplus
}
#endif
 
/* end of include file */
