(*
 * Copyright (c) 2019 Nathan Rebours <nathan.p.rebours@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *)

type t = [ `All | `One of Ocaml_env.t ] * string

let pp ppf = function
  | `All, filename -> Fmt.pf ppf "(`All, %S)" filename
  | `One ocaml_env, filename ->
      Fmt.pf ppf "(`One %a, %S)" Ocaml_env.pp ocaml_env filename

let env_and_payload f =
  match Astring.String.cut ~sep:":" f with
  | None -> (`All, f)
  | Some (e, f) ->
      if Astring.String.exists (( = ) ' ') e then (`One Ocaml_env.Default, f)
      else (`One (Ocaml_env.User_defined e), f)
