/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.JSONRPCBridge;
import com.metaparadigm.jsonrpc.JSONRPCResult;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class JSONRPCServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(JSONRPCServlet.class.getName());
    private static final int buf_size = 4096;
    private static boolean auto_session_bridge = true;
    private static boolean keepalive = true;

    public void init(ServletConfig config) {
        if ("0".equals(config.getInitParameter("auto-session-bridge"))) {
            auto_session_bridge = false;
        }
        if ("0".equals(config.getInitParameter("keepalive"))) {
            keepalive = false;
        }
        log.info("auto_session_bridge=" + auto_session_bridge + ", keepalive=" + keepalive);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassCastException {
        int ret;
        HttpSession session = request.getSession();
        JSONRPCBridge json_bridge = null;
        json_bridge = (JSONRPCBridge)session.getAttribute("JSONRPCBridge");
        if (json_bridge == null) {
            if (!auto_session_bridge) {
                json_bridge = JSONRPCBridge.getGlobalBridge();
                if (json_bridge.isDebug()) {
                    log.info("Using global bridge.");
                }
            } else {
                json_bridge = new JSONRPCBridge();
                session.setAttribute("JSONRPCBridge", (Object)json_bridge);
                if (json_bridge.isDebug()) {
                    log.info("Created a bridge for this session.");
                }
            }
        }
        response.setContentType("text/plain;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        CharArrayWriter data = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((ret = in.read(buf, 0, 4096)) != -1) {
            data.write(buf, 0, ret);
        }
        if (json_bridge.isDebug()) {
            log.fine("recieve: " + data.toString());
        }
        JSONObject json_req = null;
        JSONRPCResult json_res = null;
        try {
            json_req = new JSONObject(data.toString());
            json_res = json_bridge.call(new Object[]{request}, json_req);
        }
        catch (ParseException e) {
            log.severe("can't parse call: " + data);
            json_res = new JSONRPCResult(590, null, "couldn't parse request arguments");
        }
        if (json_bridge.isDebug()) {
            log.fine("send: " + json_res.toString());
        }
        byte[] bout = json_res.toString().getBytes("UTF-8");
        if (keepalive) {
            response.setIntHeader("Content-Length", bout.length);
        }
        out.write(bout);
        out.flush();
        out.close();
    }
}

