/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSYSLOG_SOURCE_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_SOURCE_INCLUDE_RECURSION_GUARD

typedef struct dsyslog_source_ dsyslog_source_t;

typedef void (*dsyslog_source_constructor_t)(dsyslog_source_t *src);
typedef void (*dsyslog_source_destructor_t)(dsyslog_source_t *src);

/* A syslog source. */
struct dsyslog_source_ {
	gchar *type;
	gchar *path;
	gchar *host;
	gint port;
	gpointer opaque;
	dsyslog_source_destructor_t destructor;
};

extern void dsyslog_source_register(gchar *type, dsyslog_source_constructor_t func);
extern void dsyslog_source_unregister(gchar *type);
extern void dsyslog_source_setup(dsyslog_source_t *src);
extern void dsyslog_source_remove(dsyslog_source_t *src);
extern void dsyslog_source_clear(void);

#endif
