DACS_ACS(8)                DACS Web Services Manual                DACS_ACS(8)



[1mNAME[0m
       dacs_acs - [1mDACS [22maccess control service

[1mSYNOPSIS[0m
       [1mdacs_acs [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-proxy-static[22m] [[1m-proxy-exec[22m]
                        [1mdacs_acs-test[0m

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mDACS [22maccess control service, [1mdacs_acs [22m(or simply [1mACS[22m) is
       responsible for making access control decisions on web service
       requests. It is run by a web server. In the current implementation,
       [1mdacs_acs [22mis executed by the web server as an external program.  [1mACS[0m
       provides role-based access control using the [1mDACS [22mrule-processing
       engine, which consults access control rules (also referred to as ACLs)
       provided with [1mDACS [22mor written by a [1mDACS [22madministrator. Because access
       control is performed on URIs, [1mACS [22mcan control access to arbitrary
       resources, such as web pages, files, or programs.

       A generic interface to [1mDACS's [22mrule processing engine is given by
       [34m[1mdacscheck(1)[0m[1m[22m[2].

       A web server runs [1mdacs_acs [22mto determine whether a particular service
       request is authorized. Although in theory any web server that provides
       appropriate hooks could call [1mdacs_acs[22m, at present only [1mApache [22m2.x and
       2.2.x web servers are supported. A [1mDACS[22m-aware [1mApache [22mmodule called
       [34m[1mmod_auth_dacs[0m[1m[22m[3] is configured using custom [1mApache [22mdirectives and runs
       [1mdacs_acs[22m. A web server having [34m[1mmod_auth_dacs[0m[1m[22m[3] functionality is said to
       be [1mDACS[22m-enhanced and web services that are under the control of
       [34m[1mmod_auth_dacs[0m[1m[22m[3] are said to be [1mDACS[22m-wrapped.

       When [1mApache [22mreceives a [1mDACS[22m-wrapped service request, the [1mmod_auth_dacs[0m
       module is run, which in turn runs [1mdacs_acs [22mto determine whether the
       request should be granted. The module provides [1mdacs_acs [22mwith the name
       of the requested service ("What is being accessed?"), parameters that
       were passed in the request ("How is it being accessed?"), the identity
       of the client ("Who is making the request?"), and other context
       associated with the request. With this information at hand, [1mdacs_acs[0m
       consults a set of access control rules (the ruleset) (see
       [34m[1mdacs.acls(5)[0m[1m[22m[4]). Additional contextual information, such as [1mDACS[0m
       configuration directives and build-time options, and the run-time
       environment, is also available. The information returned by [1mdacs_acs [22mto
       the module either causes [1mApache [22mto grant permission, possibly with a
       constraint that specifies additional, service-specific information, or
       denies permission, possibly with a reason for denial.  [1mdacs_acs [22mmay
       also instruct the web server to redirect the client.

       All [1mDACS [22mservices must be under the control of [1mdacs_acs[22m, even those
       that do not require the client to be authenticated. Also, a web server
       must be configured such that only [1mDACS[22m-controlled services and no other
       services can be invoked through URLs associated with its [1mDACS[0m
       jurisdiction.

       It is not a requirement that all of a web server's resources be under
       the control of [1mDACS[22m. That is, it is not necessary to [1mDACS[22m-wrap
       everything, but it is certainly possible.

       Please refer to the documentation for [34m[1mmod_auth_dacs[0m[1m[22m[3] for information
       on configuring the [1mDACS Apache [22mmodule.

           [1mSecurity[0m
           A [1mdacs_acs [22mprocess, which is created by [1mhttpd[22m, should ordinarily
           run as the same user id as [1mhttpd[22m. File and directory ownership and
           modes must be set so that it can read its configuration files,
           access control rules, and so on. The [1mDACS [22mexpression language
           includes functions that can execute an arbitrary program and
           perform file system operations, so care must be taken to ensure
           that files used by [1mDACS [22mcannot be edited or replaced by
           non-privileged users. In some circumstances, it may be necessary
           for [1mdacs_acs [22mto run as root, in which case a [1mDACS [22madministrator
           must be extra careful in this regard.

           [1mTip[0m
           One way to understand what [1mdacs_acs [22mis doing, or to debug it, is to
           enable the most detailed level of [34m[1mlogging[0m[1m[22m[5]. This will emit a
           copious quantity of output to the [1mDACS [22mlog file, so be sure to
           reduce the logging level and delete the log file when you are
           finished.

           Setting the [34m[1mLOG_LEVEL[0m[1m[22m[6] directive to "debug" or "trace" will
           produce detailed output (although it can be moderated using the
           [34m[1mLOG_FILTER[0m[1m[22m[7] directive).  LOG_LEVEL has the disadvantage that it
           cannot take effect until after configuration processing.

           To enable logging output at the earliest possible time, you can add
           the desired [34m[4mdacsoptions[0m[4m[24m[1] flags to Apache's [34m[1mAddDACSAuth[0m[1m[22m[8]
           directive; for example, by using a directive like the following in
           httpd.conf:

               AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"

           Note that [1mhttpd [22mmust be restarted before changes to this directive
           take effect.

           An alternative method of enabling detailed logging, equivalent to
           using the [1m-t [22mand [1m-v [22mflags if neither has been specified, is to
           create a file in the [34m[1mDACS_HOME[0m[1m[22m[9] directory with the name
           debug_[4mprogname[24m. For example, to enable detailed logging for
           [1mdacs_acs[22m, the following command might be used:

               % touch /usr/local/dacs/debug_dacs_acs

           This method takes effect immediately and applies to any [1mDACS [22mweb
           service or command that accepts [34m[4mdacsoptions[0m[4m[24m[1] at the time they
           begin execution. It overrides the current value of LOG_LEVEL, is
           more selective because it applies only to [4mprogname[24m (unlike
           LOG_LEVEL), is easily turned on by creating the file and turned off
           by removing the file, and neither requires changes to httpd.conf
           nor an [1mhttpd [22mrestart.

   [1mModule-to-ACS Protocol[0m
       [1mDACS[22m's [34m[1mmod_auth_dacs[0m[1m[22m[3] module for [1mApache [22minvokes the [1mdacs_acs [22mprogram
       to do the hard part of deciding whether a request should be granted or
       denied. The module is responsible for configuring itself using new
       [1mApache [22mdirectives, gathering information required to make the access
       control decision, passing that information to [1mdacs_acs[22m, and receiving
       the access control decision from [1mdacs_acs[22m, together with either
       environment information (if access is granted to an executable request)
       or error handling directives (if access is denied).

       To prevent potentially sensitive information from becoming visible,
       [34m[1mmod_auth_dacs[0m[1m[22m[3] passes information to [1mdacs_acs [22mover an interprocess
       communication channel ([34m[1mpipe(2)[0m[1m[22m[10]).  [1mdacs_acs [22mreads its standard
       input, makes the access control decision, and writes either environment
       information or an optional error handling directive to its standard
       output. The exit status of [1mdacs_acs [22mcommunicates its decision: zero
       means the request should be granted, anything else means the request
       should be denied.

       The information passed [4mto[24m [1mdacs_acs [4m[22mfrom[24m [1mApache [22mis in the format:

           [4mvariable-name[24m="[4mvariable-value[24m"

       each of which is terminated by a newline character. These variables are
       listed below. For details about how to reference these values, see
       [34m[1mVariables Available To Rules[0m[1m[22m[11].

       [4mSERVICE_ARGS[0m
           The query arguments (if any and whether GET or POST method is being
           used) followed by POST arguments (if any and to the maximum length
           configured), base-64 encoded.

       [4mSERVICE_ARGS_TRUNCATED[0m
           For POST method requests, if the POST data stream (i.e., the
           request's entity-body) was not completely captured, such as if the
           maximum length was reached, this variable will be present and
           assigned the value 1.

       [4mSERVICE_AUTHORIZATION[0m
           The value of the Authorization HTTP header field, if present.

       [4mSERVICE_CONTENT_ENCODING[0m
           The value of the Content-Encoding HTTP header field, if present.

       [4mSERVICE_CONTENT_LENGTH[0m
           The value of the Content-Length HTTP header field, if present.

       [4mSERVICE_CONTENT_TYPE[0m
           The value of the Content-Type HTTP header field, if present.

       [4mSERVICE_COOKIE[0m
           The value of the Cookie HTTP header field, if present.

       [4mSERVICE_FILENAME[0m
           The name of the file, as determined by [1mApache[22m, corresponding to
           this response.

       [4mSERVICE_HOSTNAME[0m
           The name of the host as set by the full URI or Host HTTP header
           field, as determined by [1mApache[22m.

       [4mSERVICE_HTTPS[0m
           If the request came over SSL (HTTPS), this variable will be present
           and set to "on".

       [4mSERVICE_METHOD[0m
           The request method, as set by [1mApache [22m(e.g., "GET").

       [4mSERVICE_PATH_INFO[0m
           The [1mPATH_INFO [22mpart of the URI, as set by [1mApache[22m.

       [4mSERVICE_POSTDATA[0m
           When available, the POST data stream (the HTTP message body) (or
           part of it: see the description of the SetDACSAuthPostBuffer
           directive to [34m[1mmod_auth_dacs[0m[1m[22m[12]). It is MIME base-64 encoded.

       [4mSERVICE_PROXY_AUTH[0m
           The value of the DACS-Proxy-Authorization HTTP header field, if
           present. (Not currently used).

       [4mSERVICE_PROXYREQ[0m
           If the current request involves proxy processing on this server,
           this identifies the type of processing as "proxy" (for "forward
           proxying"), "proxy_reverse" (for "reverse proxying"), or
           "proxy_response".

       [4mSERVICE_QUERY[0m
           The value of the query string component of the URI.

       [4mSERVICE_REMOTE_ADDR[0m
           The client's IP address.

       [4mSERVICE_REMOTE_HOST[0m
           The client's DNS name, if known by [1mApache[22m.

       [4mSERVICE_SERVER_PORT[0m
           The TCP/IP port on which the request was received by [1mApache[22m.

       [4mSERVICE_URI[0m
           The path portion of the URI, as determined by [1mApache[22m.

       [4mSERVICE_USER_AGENT[0m
           The value of the User-Agent HTTP header field, if present.

       If access is granted, [1mdacs_acs [22mmay provide a set of control directives
       for [34m[1mmod_auth_dacs[0m[1m[22m[3] to interpret, followed by a set of environment
       variables for [34m[1mmod_auth_dacs[0m[1m[22m[3] to introduce into the environment of an
       executable request. Each control directive starts with a "=" character
       and is terminated by a newline. Environment variables are specified in
       the format:

           [4mvariable-name[24m=[4mvariable-value[0m

       each of which is terminated by a newline character.

       If access is denied, [1mdacs_acs [22mmay instead provide an error handling
       directive, newline terminated, in the form expected as the third
       argument to [1mApache[22m's [1map_custom_response() [22mfunction.

   [1mCredentials[0m
       [1mDACS [22mcredentials can be passed to [1mdacs_acs [22min several ways, but they
       have the following representation:

           DACS:[4mfederation-name[24m::[[4mjurisdiction-name[24m]:[[4musername[24m]=[4mvalue[24m[; ...]

       If the [4mjurisdiction-name[24m is omitted, the [4musername[24m must also be omitted.
       The string is URL encoded. If there are multiple credentials, they are
       separated by any combination of spaces and ";" characters.

       Credentials are passed from [34m[1mmod_auth_dacs[0m[1m[22m[3] to [1mdacs_acs [22musing the
       [4mSERVICE_COOKIE[24m variable (transmitted over a [34m[1mpipe(2)[0m[1m[22m[10])

       Because a process's environment is public on some systems, [1mDACS [22mtakes
       care not to pass credentials using environment variables. Passing
       credentials through the [1mHTTP_COOKIE [22menvironment variable is forbidden
       unless enabled by the [34m[1mALLOW_HTTP_COOKIE[0m[1m[22m[13] directive. When
       specifically enabled by a rule's attribute, they can be passed using
       the [1mDACS_COOKIE [22menvironment variable (see the pass_credentials
       attribute described in [34m[1mdacs.acls(5)[0m[1m[22m[4]).

       If an HTTP Authorization header is used with the "DACS" authentication
       scheme, the "basic-credentials" component of the header may contain
       [1mDACS [22mcredentials. Please refer to [34m[1mRFC 2617[0m[1m[22m[14]. These credentials have
       the format given above but are also base-64 encoded.

           [1mSecurity[0m
           It is forbidden to submit multiple credentials for the same
           identity to [1mDACS [22mand such a request will trigger an error.

           it is also forbidden to submit multiple [1mDACS [22mauthentication cookies
           with the same cookie name.

       Please refer to [34m[1mdacs_authenticate(8)[0m[1m[22m[15] for additional information.

   [1mRlinks[0m
       An Rlink (rule link) is an alternate mechanism for providing [1mDACS[0m
       authentication and authorization. Instead of matching the name of a
       requested resource against rules, as is normally done by [1mDACS[22m, the
       request indirectly specifies authorization constraints that must be
       applied to the request. Optionally, a [1mDACS [22midentity and other
       information can accompany the request. An Rname, which is essentially
       the name of an access control rule, is used to point at the
       authorization constraints.

       An Rlink is a URL that includes an Rname. During authorization
       processing, the Rname is resolved to an access control rule that is
       processed the same as any other access control rule and the requested
       resource must be [1mDACS[22m-wrapped. In other words, a request that is
       recognized as an Rlink essentially says "use the rule identified by
       this request's Rname to decide whether or not to grant access and do
       not consider any other rule". Subsequent access control processing is
       identical to the normal case.

       In typical usage, an Rlink is created (probably, but not necessarily by
       [34m[1mdacsrlink(1)[0m[1m[22m[16]) and the resulting URL is distributed (e.g., by email)
       to those parties intended to be able to access the resource. Similar
       mechanisms are widely used by web-based applications.

       When an Rlink is used as a kind of "secret URL" that grants access to
       anyone who uses it, an Rname is a randomly generated identifier that is
       unique, with very high probability, relative to its namespace at a
       jurisdiction. By default, an Rname consists of eight symbols from the
       set of upper- and lower-case alphabetics and digits, yielding a
       namespace in excess of 10^14 identifiers. This makes guessing a valid
       Rname highly unlikely. The characteristics of new Rnames can be changed
       at will; the alphabet from which they are generated should be
       considered carefully, however, to avoid problems that might arise when
       they are embedded within a URL or used as a filename.  [34m[1mRLINK[0m[1m[22m[17]
       directives can map Rnames to the same or different namespaces,
       depending on the filestore selected by a directive.

           [1mNote[0m
           An Rlink does not have to be used as a secret URL though, and its
           creator can choose any Rname that will work with the mechanism
           described here.

           If a rule contains the optional name attribute, the attribute value
           must exactly match the Rname.

           The base name of a file containing an Rlink will be its Rname. This
           naming scheme is different from [34m[1mthe one used for normal rules[0m[1m[22m[18].

       This feature allows multiple versions of an Rlink to be created, each
       bound to a different identity. By attaching an identity to an Rlink,
       its creator can confer different rights to different users, or simply
       track who has used the Rlink. These identities may or may not
       correspond to "real" identities that are associated with [1mDACS[0m
       authentication (i.e., there may or may not be an account associated
       with them); [1mDACS [22madministrators should keep this mind to avoid any
       confusion.

       An Rname may be followed by a suffix that directly or indirectly
       associates a [1mDACS [22midentity with the Rlink. For want of a better name,
       this composite identifier is called an RnameIdent and has the following
       syntax:

             [4mRnameIdent[24m  -> [4mRname[24m ':' [4mident[24m | [4mRname[24m ';' [4miptr[0m

       In the [4mdirect[24m mode of identity attachment, the Rname is followed by a
       separator (a colon, which cannot appear in an Rname) and [4mident[24m, a
       cryptographically protected and base-64 encoded [34m[1mconcise user[0m
       [1m[34midentity[0m[1m[22m[19] that is created by [34m[1mdacsrlink(1)[0m[1m[22m[16]. These encrypted
       identities are [4mnot[24m the same as encrypted credentials. Note that
       different encrypted identifiers may represent exactly the same
       identity. If [1mDACS [22mrecognizes the Rname, when it performs authorization
       checking it will do so assuming the specified identity, [4mignoring[24m [4many[0m
       [4mother[24m [4mcredentials[24m [4mthat[24m [4mmight[24m [4mhave[24m [4maccompanied[24m [4mthe[24m [4mrequest[24m.

       In the [4mindirect[24m mode, the Rname is followed by a different separator (a
       semi-colon, which cannot appear in an Rname) and an arbitrary string,
       called an [4miptr[24m (identity pointer) that is safe to embed in a URI. The
       same character set from which an Rname can be generated is safe for an
       [4miptr[24m: any number of alphanumerics, hyphens, and underscores. The rule
       that is specified by the Rname is expected to map the string to an
       identity, probably by using the [34m[1midentity element[0m[1m[22m[20], and the identity
       is used in the same way as in the direct mode. Like an Rname, in
       typical usage an [4miptr[24m must be difficult to guess and be kept secret,
       otherwise a valid Rlink might easily be constructed that is associated
       with a chosen identity. The indirect mode has the advantages of keeping
       the URL relatively short, is immune to changes of the encryption key,
       and allows identities to be modified after an Rlink is shared.

       An identity obtained using either attachment mode is tested for
       revocation.

       The Rname, specified identity, and identity pointer are accessible in
       the [34m[4mDACS[24m namespace[0m[11], when they are available, as [4m${DACS::RNAME}[24m,
       [4m${DACS::RIDENT}[24m, and [4m${DACS::RIPTR}[24m, respectively.

       Rlinks can easily be created manually or by a custom program, but the
       [34m[1mdacsrlink(1)[0m[1m[22m[16] utility provides a simple interface to create and
       administer them. Rules created by [1mdacsrlink [22mcan be manually edited and
       deleted just like any other rule. Their is no [4ma[24m [4mpriori[24m limit on the
       lifetime of an Rlink; it continues to exist as far as [1mDACS [22mis concerned
       if the Rname is recognized by an RLINK directive and the named rule
       exists and is valid. Deleting the rule corresponding to an Rname
       effectively invalidates that Rlink.

       An Rname can be presented as an ordinary web service argument, as a
       component of the request URI, or via the special [34m[1mDACS_ACS argument[0m[1m[22m[21]:

           https://example.com/~alice/photos/myphoto.gif?RNAME=jigrFUwF
           https://example.com/cgi-bin/manage.cgi/jigrFUwF
           https://example.com/private/data?DACS_ACS=-rname+jigrFUwF

       Each of these approaches has advantages and disadvantages; the best
       choice depends on web site and application details. For example,
       embedding an Rname as a component of a URI is particularly well suited
       to CGI programs and web services (e.g.,
       https://example.com/cgi-bin/manage/jigrFUwF, where manage is the name
       of the program). Using the [4mDACS_ACS[24m argument allows the Rname to be
       used during access control testing but completely hidden from the
       requested resource.

       [34m[1mRLINK[0m[1m[22m[17] directives are used to examine an incoming request, decide
       whether an Rname is present, extract the Rname, and specify where the
       rule can be found. If an Rname is present, normal access control
       processing is disabled and no search of the usual [1mDACS [22mrulesets for an
       applicable rule occurs. If no RLINK directive finds an Rname, normal
       access control processing occurs.

       The main advantage of Rlinks is that they make controlled file sharing
       and web service access simple. An Rlink is created and disseminated,
       and all recipients can access the named resource (subject to the
       Rlink's rule) using any web browser. Any number of different rules can
       be created for the same resource, with each one having a different
       Rname. An Rlink's rule can be changed or deleted by its owner at any
       time, even after it has been distributed.

       Rlinks also offer an alternative way to make exceptions to the rule
       normally applicable. Rather than revising the "normal" rule for a
       resource or set of resources to take account for the exceptions, one or
       more Rlinks can be created to handle the special cases and the normal
       rules need not be touched.

       Another application of Rlinks is as a short representation of an
       arbitrary URL. Someone accessing an Rlink that has been configured in
       this way is redirected to a specified URL; see the [34m[1mredirect()[0m[1m[22m[22]
       function. The URL can be changed at will simply by editing the Rlink's
       rule. The Rlink need not be kept secret when it is used for this
       purpose.

       The main disadvantage of Rlinks is that security may rely on keeping
       Rnames secret, and because an Rlink may be visible in a URL, this can
       be difficult to keep up. Anyone who can capture an Rname and use it
       properly with a resource to which it applies can potentially gain
       access to that resource. An Rname might be found in a log file, or in a
       browser's history or bookmark list. Although this method is convenient
       for users, the requirement for secrecy means that it might not be
       appropriate in some situations. At the expense of some convenience,
       however, a password can be bound to an Rlink when it is created; for
       the Rlink to be valid when it is invoked, the same password must be
       presented as an argument. Furthermore, because the access control rule
       associated with an Rname is the same as any other rule, it may express
       any conditions it likes, so it can still require authentication to have
       been performed, restrict the user's IP address, and so on. Also, an
       Rlink cannot be used to gain access to a resource that is not described
       by its rule's services element.

   [1mHTTP Authentication[0m
       [1mdacs_acs [22mcan be configured to trigger HTTP authentication (see [34m[1mRFC[0m
       [1m[34m2617[0m[1m[22m[14]) by returning a WWW-Authenticate response header in certain
       circumstances. This will usually cause a browser or other web user
       agent to use its built-in mechanism for prompting the user for a
       username and password that corresponds to a particular access realm (a
       label that identifies a URL path prefix belonging to the server).

       If [1mdacs_acs [22mdenies access because the user is not authenticated (code
       [1m902[22m, ACS_DENIAL_REASON_NO_AUTH), it checks to see if HTTP
       authentication has been enabled for the request. If not, processing of
       the denied request proceeds normally, otherwise [1mDACS [22mwill try to use
       the [34m[1mRFC 2617[0m[1m[22m[14] protocol to have [1mdacs_authenticate [22mauthenticate the
       user.

           [1mTip[0m
           This feature is configured through the [34m[1mHTTP_AUTH_ENABLE[0m[1m[22m[23] and
           [34m[1mHTTP_AUTH[0m[1m[22m[24] directives, some configuration variables, and [34m[1mAuth[0m
           [1m[34mclause directives[0m[1m[22m[25]. Please refer to them for details.

           When HTTP authentication is triggered in this way, [4mno[24m [4mextra[24m [1mApache[0m
           [4mconfiguration[24m [4mneeds[24m [4mto[24m [4mbe[24m [4mdone[24m [4mor[24m [4mshould[24m [4mbe[24m [4mdone[24m. All that is
           required of [1mApache [22mis that the resource that should trigger
           authentication be [1mDACS[22m-wrapped.

           [4mAny[24m password style authentication module, or the CAS authentication
           module, can be configured in conjunction with [1mDACS's [22mHTTP Basic
           authentication. That is, [1mDACS [22mcan be configured to cause a browser
           to pop-up a username/password prompt and then use the values
           supplied by the user as if they were the [4mUSERNAME[24m and [4mPASSWORD[0m
           arguments to [1mdacs_authenticate[22m. The authentication module on the
           backend of the authentication procedure can use any type of [1mApache[0m
           password file or [1mDACS [22mpassword file, NTLM, CAS, etc.

           Besides authenticating against an [1mApache [22mpassword file created by
           [1mhtpasswd[22m, [1mhtdigest[22m, or [1mhtdbm[22m, this means that an ordinary browser
           can be used to capture a username and password for any [1mDACS[0m
           authentication module that requires it. Please refer to the
           description of the [34m[1mlocal_apache_authenticate[0m[1m[22m[26] module for
           details.

       If the feature is enabled and applies to a request:

        1. any [34m[1mACS_ERROR_HANDLER[0m[1m[22m[27], [34m[1mAUTH_SUCCESS_HANDLER[0m[1m[22m[28], and
           [34m[1mAUTH_ERROR_HANDLER[0m[1m[22m[29] directives that would ordinarily apply are
           overridden.

        2. the [34m[1mHTTP_AUTH[0m[1m[22m[24] directive that applies to the request specifies
           the authentication scheme, realm, and any additional authentication
           parameters.

        3. a WWW-Authenticate response header is returned to the browser. For
           example, for Basic authentication this header might look like:

               WWW-Authenticate: Basic realm="My Realm"


        4. an HTTP status value of [1m401 [22m([34m[1mRFC 2616[0m[1m[22m[30]) is returned. If the
           variable [4m${Conf::http_auth_message}[24m is defined, its value is used
           as the message body; if it is "", then no message body will be
           sent; if not provided, the string "902 Authentication by DACS is
           required" is used.

        5. if the variable [4m${Conf::http_auth_jurisdiction}[24m is configured, it
           is expected to be the name of the jurisdiction (within the current
           federation) at which [1mdacs_authenticate [22mis to be invoked to
           authenticate the user; if the variable is undefined, the name of
           the current jurisdiction is used.


       The values of some of these variables are neither examined by [1mDACS [22mnor
       meaningful to it. For example, all that [1mDACS [22mrequires of the realm
       string is that it be syntactically valid.

       When enabled, the following flow of control occurs:

        1. The user hits a [1mDACS[22m-wrapped URL when not authenticated; if
           [1mdacs_acs [22mis configured to perform HTTP authentication for the
           request, it returns a [1m401 [22m("Unauthorized") status code and a
           WWW-Authenticate header;

        2. The browser prompts for a username and password; the user enters
           the information and the browser re-submits the request, which this
           time includes an Authorization header;

        3. [1mdacs_acs [22magain denies the request because the user is not
           authenticated, but sees an Authorization header and redirects the
           user to [1mdacs_authenticate [22m(at [4m${Conf::http_auth_jurisdiction}[24m or
           the current jurisdiction) with arguments necessary for the selected
           authentication scheme; [1mdacs_authenticate [22mmaps the given username
           (and password, if available) to the [4mUSERNAME[24m argument (and possibly
           the [4mPASSWORD[24m argument) and invokes authentication modules as
           necessary;

        4. If authentication succeeds, credentials are issued and the user is
           redirected to the original request (via the GET method);

        5. If authentication fails, the procedure is repeated from the
           beginning.


           [1mNote[0m
           If a user authenticates using Basic authentication, signs out of
           [1mDACS[22m, and in the same browser session hits the link to trigger
           authentication, credentials may be automatically re-issued without
           prompting. This is because the browser will continue to send the
           Authorization request header, which [1mdacs_authenticate [22mmay continue
           to honour.

           With Digest authentication, various aspects of the authentication
           protocol are subject to time limits as a security measure. The
           configuration variable [4m${Conf::http_auth_timeout_secs}[24m can be set
           to the number of seconds for which a nonce is valid, thereby
           overriding the default; only advanced administrators familiar with
           [34m[1mRFC 2617[0m[1m[22m[14] should change the default.

       The following is an example of configuration that might appear in the
       appropriate section (or sections) in [1mDACS [22mconfiguration files:

           HTTP_AUTH_ENABLE "yes"
           HTTP_AUTH "Basic \"Doggies\" /basic/*"

           EVAL ${Conf::http_auth_message} = \
             "902 https://example.com/cgi-bin/dacs/dacs_authenticate"

       Given this example configuration, whenever access is denied for a
       resource having a URL path that begins with "/basic/" because the user
       is not authenticated, the following response-headers will be returned:

           WWW-Authenticate: Basic realm="Doggies"
           Status: 401

       and the message body will contain the single line:

           902 https://example.com/cgi-bin/dacs/dacs_authenticate

       Instead of enabling the feature for [4mall[24m requests, the following example
       enables it only for those user agents that supply a User-Agent
       request-header that matches the regular expression "DACS-http/.*"
       (which happens to match the default User-Agent string sent by the [1mDACS[0m
       [34m[1mdacshttp(1)[0m[1m[22m[31] utility).

           HTTP_AUTH_ENABLE = regmatch("${DACS::USER_AGENT}", "DACS-http/.*") ? "yes" : "no"

       A similar expression would enable the feature only for [1mInternet[0m
       [1mExplorer[22m, [1mMozilla[22m, [1mcurl[22m, [34m[1mdacshttp(1)[0m[1m[22m[31], etc., or some combination of
       browsers. Simply obtain the User-Agent string(s) sent by the browser(s)
       and write the appropriate regular expression to match it/them.

       Although [34m[1mRFC 2617[0m[1m[22m[14] allows multiple WWW-Authenticate response-headers
       to be returned, this mechanism can only send one.

       When provided by a user agent, [1mdacs_acs [22mmakes the value of the
       Authorization request-header available to access control rules through
       the [4m${DACS::AUTHORIZATION}[24m variable.  [1mDACS [22mcredentials can also be
       [34m[1mpassed using this request-header[0m[1m[22m[32].

   [1mAuthorization Caching[0m
       After a rule grants access, [1mdacs_acs [22mcan be configured to save some
       context about its access control decision so that if the user makes a
       subsequent request for a resource managed by the same rule in a similar
       context, authorization can be granted quickly and without having to
       search for the applicable rule or re-evaluate it. Basically, the
       administrator tells [1mDACS [22mthat if the rule grants access to a particular
       user, then it is safe for [1mDACS [22mto assume that future requests for the
       same resource by the same user should be granted without doing a
       complete authorization check.

       This mechanism offers improved performance in cases where:

       +o   users tend to make many requests for the same resource, or for a
           set of resources that are managed by the same rule (such as CSS
           files or images);

       +o   rule evaluation is relatively slow or expensive;

       +o   there are a large number of rules and/or rule retrieval is
           relatively slow;

       +o   re-evaluation of the rule is unnecessary (e.g., the rule does not
           update any state information)

       +o   it is acceptable for changes to the ruleset to not immediately
           affect cachable decisions


           [1mSecurity[0m
           Pending further testing, this feature should be considered
           experimental. Use it in production situations only after you have
           satisfied yourself that it is working properly with your access
           control rules.

       Authorization caching is implemented using a special HTTP cookie,
       called an access token (not related to the tokens used in
       authentication), and a simple database maintained by [1mdacs_acs[22m. A cookie
       is returned to the user when caching is possible and the user does not
       already possess a valid cookie. An access token points to server-side
       data that describes the cached authorization, including the context in
       which it is valid. Immediately after revocation testing, [1mdacs_acs[0m
       checks if authorization caching applies to the current request; if it
       does, no access control rules are examined and access is immediately
       granted. If caching does not apply, process continues as usual. If any
       invalid access tokens were sent with the request, [1mdacs_acs [22mwill ask for
       them to be deleted (i.e., it unsets the cookies). These cookies have
       the following format:

           DACS:[4mfederation-name[24m::[4mjurisdiction-name[24m::TOKEN-[4munique[0m

       Here, [4munique[24m is the "dacs64" encoding (see [34m[1mdacs.exprs(5)[0m[1m[22m[33]) of a
       cryptographically strong pseudo-random 16 byte value. Since access
       control is purely a jurisdictional responsibility in [1mDACS[22m, a cookie is
       meaningful only to the jurisdiction that issues it.

       These cookies are non-persistent (they are supposed to disappear when a
       browser session ends). The value of [34m[1mCOOKIE_PATH[0m[1m[22m[34], or "/", determines
       the cookie's path attribute. The [34m[1mCOOKIE_NO_DOMAIN[0m[1m[22m[35] and
       [34m[1mCOOKIE_HTTP_ONLY[0m[1m[22m[36] directives are also honoured.

       Here is a simple example of how [1mDACS [22mmight be configured to enable
       authorization caching for a particular resource. The jurisdiction's
       dacs.conf would include directives similar to the following:

           ACS_ACCESS_TOKEN_ENABLE        "yes"
           ACS_ACCESS_TOKEN_LIFETIME_SECS "43200"
           VFS                            "[tokens]dacs-kwv-fs:/usr/local/dacs/conf/tokens"

       A rule for the resource might look like this:

           <acl_rule status="enabled">
              <services>
                <service url_pattern="/cgi-bin/database.cgi"/>
                <service url_pattern="/cgi-bin/someprog.cgi"/>
              </services>

              <rule order="allow,deny">
                <allow permit_caching="yes">
                  user("auth")
                </allow>
              </rule>
           </acl_rule>

       Given this configuration, the first time an authenticated user
       requests, say, https://example.com/cgi-bin/database.cgi, he will be
       issued an access token. This token will be valid for up to 12 hours,
       and its associated data will be stored as an entry in the file
       /usr/local/dacs/conf/tokens.

           [1mNote[0m
           In the current implementation, each access token is contained
           within its own cookie, rather than a jurisdiction collecting all of
           the user's tokens within a single cookie. A user might therefore
           simultaneously hold many access tokens from each jurisdiction. This
           should not be significant for middleware agents, but web browsers
           typically impose various kinds of limits on cookie "real estate".
           Administrators should take this into account when using this
           feature.

       Before it can be used, [1mDACS [22mmust be built with the feature enabled (see
       [1m--enable-access-tokens [22min [34m[1mdacs.install(7)[0m[1m[22m[37]). The virtual filestore
       item type "tokens" must be configured to identify an indexed virtual
       storage method and location for storing cache entries. Also, the
       authorization caching mechanism must be configured (see
       [34m[1mACS_ACCESS_TOKEN_ENABLE[0m[1m[22m[38], [34m[1mACS_ACCESS_TOKEN_LIFETIME_LIMIT[0m[1m[22m[39], and
       [34m[1mACS_ACCESS_TOKEN_LIFETIME_SECS[0m[1m[22m[40]).

       Enabling the feature in a particular context also requires setting a
       rule's permit_caching attribute to "yes" (see [34m[1mdacs.acls(5)[0m[1m[22m[41]).
       Whenever access is granted because of the rule, authorization caching
       of the rule is possible.

           [1mNote[0m
           Only the url_pattern of the rule's matching Service element (or the
           path derived from a url_expr attribute) is associated with the
           access token. This implies that when a rule has more than one
           service element, as in the example rule above, a single access
           token would be associated with only one of the two resources.
           Requests for different services could result in multiple access
           tokens being returned to a user, one for each service. A wildcard
           pattern is required if an access token is intended to grant access
           to more than one resource (this restriction may be lifted in future
           releases).

           Note that although a service request's arguments may be significant
           when initially granting access, they are not significant with
           respect to authorization caching applied to subsequent requests
           that use the access token. Once an access token is issued, the
           resource or resources named by it may therefore be invoked with
           different arguments without negating authorization caching.

           If any constraint, permit_chaining pass_credentials, or
           pass_http_cookie attributes are associated with the cachable rule,
           their values are also remembered and set if the access token
           subsequently causes access to be granted.

       Authorization caching is possible irrespective of whether a user has
       been authenticated. Caching is not allowed, however, in cases where the
       granting rule uses [34m[1mtail matching[0m[1m[22m[42] [4mand[24m a rule exists for a
       subordinate URL (i.e., where there is a "more specific" rule for some
       other resource that should not be overridden by caching the "more
       general" rule). These cases are simply ignored; they are not considered
       to be errors. It is therefore not possible to cache the outcome of a
       rule with a url_pattern of "/*", for example, unless it is the only
       rule in the ruleset.

           [1mNote[0m
           A positive result will be cached regardless of whether the
           requested resource actually exists or is subsequently processed
           without error by the web server. It is therefore possible for an
           access token to be issued for a resource that does not exist at the
           time of issue but which is created at some later time.

       The store of tokens may be deleted or modified at any time. Any access
       token that points to an invalid or missing entry in the store becomes
       invalid.

       Over time, the server-side access token database tends to accumulate
       entries for access tokens that no longer exist or have expired. These
       should be garbage collected. (This is currently not automated, so the
       database needs to be truncated. There should also be way to list the
       entries and manually delete entries.) The [34m[1mdacsacl(1)[0m[1m[22m[43] command and
       [34m[1mdacs_admin(8)[0m[1m[22m[44] service can perform administrative functions on the
       entry database.

           [1mSecurity[0m
           Access tokens are created and used in such a way that it is
           practically impossible for an attacker to manufacture a valid
           access token or to convert an access token valid for one resource
           into one valid for a different resource.

           If a user is authenticated at the time an access token is
           generated, the token is "tied" to those credentials (all of them)
           and becomes invalid if any of the credentials become invalid or are
           not sent with the access token. If a user signs out or
           reauthenticates after being issued an access token, therefore, the
           access token will become invalid. Additional credentials, beyond
           what were present at the time an access token was generated, have
           no effect in this regard.

           As with cookies bearing [1mDACS [22mcredentials, cookies containing access
           tokens must be kept private. For an authenticated user, an attacker
           would need to acquire an access token [4mand[24m [4mall[24m [4mcredentials[24m to make
           use of the token. For an unauthenticated user, only the access
           token is needed; presumably (but not necessarily) in this case a
           lower level of security is being applied to the resource in any
           case.

           It is the administrator's responsibility to ensure that
           authorization caching does not break the intended semantics of a
           rule - [1mDACS [22mdoes not do any consistency or sanity checks. For
           instance, if a rule is written to grant access only between 12:00
           and 12:59 but an access token produced by the rule could continue
           to be valid beyond that time interval, authorization caching could
           violate the intent of the rule. Also, a rule that ordinarily
           produces side effects would not do so for any requests granted
           through authorization caching.

           As long as an authorization decision remains valid, changes to the
           ruleset will not cause a cached decision to be reversed. That is, a
           change to the ruleset that would ordinarily cause a request to be
           denied will have no effect on a cached decision. The [34m[1mrevocation[0m
           [1m[34mlist[0m[1m[22m[45] is, however, processed as usual, so it is possible for a
           cached decision to be denied due to revocation. An error
           encountered during processing would also cause access to be denied,
           regardless of authorization caching.

   [1mXML Output[0m
       When XML output has been enabled, [1mdacs_acs [22mwill emit a document
       (conforming to [34m[1mdacs_acs.dtd[0m[1m[22m[46]) when access is denied, a processing
       error occurs, or when an access testing mode has been requested using
       the [4mDACS_ACS[24m argument.

       [1mdacs_acs [22massociates an error code with each event or reason for which
       access might be denied (see the description of the ACS_ERROR_HANDLER
       directive in [34m[1mdacs.conf(5)[0m[1m[22m[47]). The error code is itself sufficient for
       a client to know why access was denied. When access is denied, an
       appropriately named XML element is emitted. The element will include an
       explanatory text message, and optionally, the URI of a handler that the
       client might call to continue the workflow. This URI is obtained from
       the applicable ACS_ERROR_HANDLER directive, if any.

       The event905 element corresponds to the ACK_NEEDED (equivalent to error
       code [1m905[22m) [1mDACS [22merror event. It is emitted if the client must
       acknowledge one or more notices before the request will be granted. Its
       handler attributes, which are optional, are obtained from the
       ACS_ERROR_HANDLER directive that applies to this error and the
       NOTICES_ACK_HANDLER directive. If the ack_handler attribute is absent,
       then the presentation_handler is expected to perform both presentation
       and acknowledgement handling functions. The notice_uris attribute is a
       comma-separated list of URIs of notices that must be acknowledged by
       the user. The resource_uris attribute is a comma-separated list of URIs
       of resources associated with this request; this will usually be only a
       single URI. The time and hmac attributes are used to enforce a secure
       workflow mode. Please refer to [34m[1mdacs_notices(8)[0m[1m[22m[48] and [34m[1mdacs.conf(5)[0m[1m[22m[47]
       for additional detail.

       A common_status element indicates that [1mdacs_acs [22mcould not process the
       request. This might happen, for example, if [1mdacs_acs [22mwere not properly
       configured.

   [1mVariables Available To Rules[0m
       [1mdacs_acs [22mpredefines several variables that may be accessed by rules.
       Additionally, variables obtained from the request's credentials are
       exported into the environment of an invoked CGI program. In this way,
       services can know who is making the request, to retrieve user
       preferences, for example.

       In addition, parameters passed to a CGI program, whether through a
       query string or a message body (e.g., POST method data), may be
       accessed as variables. For example, for the service request:

            .../cgi-bin/foo?A=hello&B=world

       the variables [4m${Args::A}[24m with the value hello and [4m${Args::B}[24m with the
       value world will be defined at the time ACL rulesets are evaluated.
       Also, variables obtained from the authenticated credentials may be
       referenced (e.g., [4m${DACS::JURISDICTION}[24m).

           [1mNote[0m
           Because at present a variable cannot be multi-valued, if a variable
           is set more than once its value at the time of evaluation is not
           predictable. For example, given this query string you cannot depend
           on which value is assigned to [4m${Args::ARG}[24m:

                .../cgi-bin/foo?ARG=hello&ARG=world

           This also creates problems if you need to examine arguments
           produced by an HTML SELECT element within a form when the MULTIPLE
           attribute is used because each OPTION selected by the user will be
           associated with the same argument name. Syntactical and functional
           improvements are planned in this regard.

           Any "null" arguments in the query string (e.g., "&&") are ignored.
           A query string with a component that has a value but not a name
           (e.g., "&=foo") is considered to be invalid.

       From these sources, the execution environment, and from the [1mDACS[0m
       configuration, [1mdacs_acs [22mautomatically creates four "classes" of
       variables: CGI parameter variables, configuration variables,
       environment variables, and request-specific variables created by [1mDACS[22m.
       These classes are called namespaces; please refer to [34m[1mdacs.exprs(5)[0m[1m[22m[49]
       for details. For example, the value of a CGI parameter is accessed by
       [4m${Args::varname}[24m, the value of a [1mDACS [22mcontext variable is accessed by
       [4m${DACS::varname}[24m (e.g., [4m${DACS::JURISDICTION}[24m), and the value of
       configuration variable is obtained using [4m${Conf::varname}[24m (e.g.,
       [4m${Conf::FEDERATION_DOMAIN}[24m).

       For [1mdacs_acs[22m, the [4mEnv[24m namespace is comprised of all CGI variables
       exported by [1mApache[22m, which includes HTTP request variables such as
       [4m${Env::HTTP_USER_AGENT}[24m. The values of recognized headers that might
       compromise security are edited or deleted. Note that [1mApache [22mwill export
       unrecognized HTTP request headers by prefixing the header name with
       HTTP_ and mapping the header name to upper case; this example results
       in [4m${Env::AUGGIE}[24m having the value "Doggie":

           % http -header Auggie Doggie https://example.com/cgi-bin/dacs/someprog

       For other programs, the [4mEnv[24m namespace is populated from the program's
       normal environment.

       These namespaces are reserved from other uses and their contents are,
       for the most part, read-only.

       The only MIME content types currently supported with respect to
       capturing CGI parameters are application/x-www-form-urlencoded, which
       is the default used by browsers when submitting a form, and
       multipart/form-data. At present, only 7bit data encoding is supported.
       The methods by which values from forms can be returned to a server are
       described in [34m[1mRFC 1867[0m[1m[22m[50], [34m[1mRFC 2388[0m[1m[22m[51], and [34m[1mHTML 4[0m[1m[22m[52].

       The following variables are exported to the "[4mDACS[24m" namespace (e.g.,
       [4m${DACS::QUERY}[24m). Upper and lower case are distinct in variable names.
       These values are either obtained from [1mApache [22mor are elements of the
       client's credentials.

       [4mACS[0m
           If [1mdacs_acs [22mis requested to test access, this variable will be
           defined and have the value of the [4mDACS_ACS[24m argument.

       [4mARGS[0m
           A string representing all of the parameters to a CGI program,
           excluding multipart/form-data, encoded as a query string. If the
           number or total size of the parameters exceeded the
           implementation-dependent limit, the variable [4mARGS_TRUNCATED[24m will be
           defined and have a non-zero value.

       [4mARGS_TRUNCATED[0m
           If this variable is defined and its value is non-zero, the argument
           list has been truncated. This means that not all arguments to the
           CGI program are accessible to [1mdacs_acs [22mand the value of one
           argument may have been truncated. See [34m[1mACS_POST_EXCEPTION_MODE[0m[1m[22m[53].

       [4mARG_COUNT[0m
           The number of arguments available in the [4mArgs[24m namespace. If there
           are four arguments in a request's query string and two arguments
           within its application/x-www-form-urlencoded message body, for
           instance, then the value of [4m${DACS::ARG_COUNT}[24m will be six. These
           arguments will be available collectively as the value of
           [4m${DACS::ARGS}[24m and individually in the [4mArgs[24m namespace.

       [4mAUTHORIZATION[0m
           The value of the Authorization HTTP header field, if available.

       [4mCONTENT_ENCODING[0m
           The value of the Content-Encoding HTTP header field, if available.

       [4mCONTENT_LENGTH[0m
           The value of the Content-Length HTTP header field, if available.

       [4mCONTENT_TYPE[0m
           The value of the Content-Type HTTP header field, if available.

       [4mCURRENT_URI[0m
           The full URI for the requested resource, including any query
           component.

       [4mCURRENT_URI_NO_QUERY[0m
           The full URI for the requested resource, excluding any query
           component.

       [4mFEDERATION[0m
           The official name of the federation to which [4mJURISDICTION[24m belongs.
           If the user was not authenticated, this variable will be undefined.

       [4mFILENAME[0m
           The full path of the file corresponding to the URL being invoked,
           equivalent to [1mApache[22m's [1mSCRIPT_FILENAME [22menvironment variable or its
           [4mREQUEST_FILENAME[24m variable.

       [4mIDENTITY[0m
           The [1mDACS [22midentity (the username component plus federation and
           jurisdiction components) if the user was authenticated, otherwise
           undefined.

       [4mINTERACTIVE[0m
           If the standard input is a valid terminal type device, this
           variable is set to 1, otherwise it is undefined.

       [4mIP[0m
           The IP address, in standard numeric dot notation, associated with
           [4mUSERNAME[24m. If the user was not authenticated, this variable will be
           undefined.

       [4mJURISDICTION[0m
           The official, abbreviated name of the jurisdiction that
           authenticated [4mUSERNAME[24m. If the user was not authenticated, this
           variable will be undefined.

       [4mMETHOD[0m
           The method used to invoke the URL, equivalent to [1mApache[22m's
           [1mREQUEST_METHOD [22menvironment variable.

       [4mPATH_INFO[0m
           The [1mPATH_INFO [22mpart of the URI, as set by [1mApache[22m.

       [4mPOSTDATA[0m
           A MIME base-64 encoded string representing the data stream (message
           body) sent to a CGI program. If the number or total size of the
           parameters exceeded the configured limit, the variable
           [4mARGS_TRUNCATED[24m will be defined and have a non-zero value. See the
           description of the SetDACSAuthPostBuffer directive to
           [34m[1mmod_auth_dacs[0m[1m[22m[12]).

       [4mPROXYREQ[0m
           If set, the type of proxy processing performed for this request by
           Apache (from [4mSERVICE_PROXYREQ[24m).

       [4mQUERY[0m
           The query string, if any, that was appended to the URL.

       [4mREMOTE_ADDR[0m
           The [1mREMOTE_ADDR[22m, as set by [1mApache[22m.

       [4mREMOTE_HOST[0m
           The [1mREMOTE_HOST[22m, as set by [1mApache[22m.

       [4mRIDENT[0m
           The Rlink identity, if any, associated with the rule currently
           being evaluated. See [34m[1mRlinks[0m[1m[22m[54].

       [4mRIPTR[0m
           The Rlink identity pointer, if any, associated with the rule
           currently being evaluated. See [34m[1mRlinks[0m[1m[22m[54].

       [4mRNAME[0m
           The Rname, if any, associated with the rule currently being
           evaluated. This is also available as [4m${Args::RNAME}[24m. See
           [34m[1mRlinks[0m[1m[22m[54].

       [4mROLES[0m
           The role string associated with [4mUSERNAME[24m. If the user was not
           authenticated, this variable will be undefined.

       [4mURI[24m and [4mURL[0m
           The URL being invoked.

       [4mUSERNAME[0m
           The username (without any federation or jurisdiction component). If
           the user was not authenticated, this variable will be undefined.

       [4mUSER_AGENT[0m
           When provided by the user agent, this is equivalent to the HTTP
           User-Agent request-header field and [1mHTTP_USER_AGENT [22menvironment
           variable provided by [1mApache[22m. When an actual value is unavailable,
           this variable is set to "unknown".

   [1mExported Environment Variables[0m
       The normal execution environment of a CGI program or internally
       processed script (e.g., [1mmod_php[22m) invoked through [1mDACS [22mis augmented with
       environment variables instantiated from validated credentials, access
       control rules, configuration information, and so on. Through these
       variables, services have access to the identity of the user making the
       request to retrieve user preferences, for example, or make run-time
       decisions.

           [1mNote[0m
           Environment variables with the prefix "DACS_" are reserved for use
           by [1mDACS [22mand should not be used for other purposes by an
           application. Upper and lower case are distinct in variable names.

           [1mTip[0m
           If [34m[1mPHP[0m[1m[22m[55] is installed, a nice way to see the [1mDACS [22menvironment
           variables that are passed to a CGI program is to run a [1mDACS[22m-wrapped
           script like this:

               <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
               <html><head>
               <meta http-equiv="Content-type" content="text/html;charset=ISO-8859-1">
               <title></title></head>
               <body>
               <p>
               <?php
               phpinfo();
               ?>
               </p>
               </body></html>

           Alternatively, you can use [34m[1mdacs_prenv(8)[0m[1m[22m[56].

       Currently defined environment variables are listed here. More detailed
       descriptions of these variables appear in other [1mDACS [22mdocuments.

       [1mDACS_ACS_JURISDICTION[0m
           This is the official [1mDACS [22minternal, abbreviated name for the
           jurisdiction that has granted access.

       [1mDACS_APPROVAL[0m
           A digitally signed message that confirms that [1mDACS [22mauthorized the
           request. See [34m[1mdacs_acs(8)[0m[1m[22m[57].

       [1mDACS_CONCISE_IDENTITY[0m
           This is the full [1mDACS [22midentity to which access was granted
           expressed in the concise syntax used by [34m[1mdacscheck(1)[0m[1m[22m[2]. When
           available, the user's roles and IP address are included.

       [1mDACS_CONF[0m
           This is the full pathname of the [1mDACS [22mconfiguration file.

       [1mDACS_CONSTRAINT[0m
           A constraint string associated with a sub-component of the matching
           access control rule permitting the service request.

       [1mDACS_DEFAULT_CONSTRAINT[0m
           A constraint string associated with the matching access control
           rule.

       [1mDACS_FEDERATION[0m
           This is the federation name component of [1mDACS_IDENTITY[22m.

       [1mDACS_IDENTITY[0m
           This is the full [1mDACS [22midentity to which access was granted.
           [1mApache[22m's [1mREMOTE_USER [22menvironment variable is also set to this
           value, so it is available for logging purposes and export to CGI
           programs.

       [1mDACS_JURISDICTION[0m
           This is the jurisdiction component of [1mDACS_IDENTITY[22m.

       [1mDACS_MOD_AUTH_DACS[0m
           This is a version identification string for [34m[1mmod_auth_dacs[0m[1m[22m[3].

       [1mDACS_ROLES[0m
           This is the role string associated with [1mDACS_USERNAME [22mwithin
           [1mDACS_JURISDICTION[22m.

       [1mDACS_SITE_CONF[0m
           This is the full pathname of the [1mDACS [22msite configuration file.

       [1mDACS_USERNAME[0m
           This is the username component of the identity to which access was
           granted.

       [1mDACS_VERSION[0m
           The major version number of [1mDACS[22m.

       [1mAbout Servlets[0m
               [1mNote[0m
               The details of how environment variables are passed from [1mApache[0m
               to servlets are beyond the scope of [1mDACS[22m. But for what it's
               worth, the following illustrates how to export and access them
               from servlets that are under the control of [1mDACS [22min conjunction
               with [34m[1mmod_jk[0m[1m[22m[58] and [34m[1mTomcat[0m[1m[22m[59]. This used to work at one time
               but may no longer be correct.

           The following directives (which appear in, or are included in, the
           [1mApache [22mconfiguration file) are used (this list may be expanded):

               <IfModule mod_jk.c>
                 JkEnvVar DACS_FEDERATION         NONE
                 JkEnvVar DACS_JURISDICTION       NONE
                 JkEnvVar DACS_ACS_JURISDICTION   NONE
                 JkEnvVar DACS_ROLES              NONE
                 JkEnvVar DACS_USERNAME           NONE
                 JkEnvVar DACS_CONSTRAINT         NONE
                 JkEnvVar DACS_DEFAULT_CONSTRAINT NONE
                 JkEnvVar DACS_COOKIE             NONE
                 JkEnvVar DACS_MOD_AUTH_DACS      NONE
               </IfModule mod_jk.c>

           From a servlet, the values of these variables can be obtained
           through the [1mgetAttribute() [22mmethod, invoked on an [4mHttpServletRequest[0m
           object. For example:

               Object username = req.getAttribute("DACS_USERNAME");
               out.println("roles = " + req.getAttribute("DACS_ROLES"));


[1mOPTIONS[0m
       In addition to the standard [34m[4mdacsoptions[0m[4m[24m[1], [1mdacs_acs [22mrecognizes the
       following arguments:

       [1m-proxy-static[0m
           Reserved for future use.

       [1m-proxy-exec[0m
           Reserved for future use.

       [1m-test[0m
           Perform some self-tests, then exit. A non-zero exit status means an
           error occurred. If [1m-test [22mis the only argument (recommended), no
           configuration is necessary; otherwise, normal configuration
           processing will be performed before the self-tests.

   [1mThe DACS_ACS Argument[0m
       Various aspects of the behaviour of [1mdacs_acs [22mcan be controlled by an
       optional argument named [4mDACS_ACS[24m. This argument, which may be passed to
       [4many[24m web service, is interpreted by [1mdacs_acs [22mrather than the web service
       that is being invoked. The value of this argument is parsed as a list
       of space-separated command line flags.

           [1mTip[0m
           The space character(s) must be properly escaped; e.g., as %20 or +.

       One use of this feature is when an application or middleware would like
       to know whether [1mDACS [22mwill grant or deny a service request without
       having to actually execute the service request. When building a menu,
       for instance, an application might want to exclude items involving
       service requests that would be denied to the user.  [1mdacs_acs [22mprovides
       this capability.

       To check whether access would be granted or denied, the application
       invokes the [1mDACS[22m-wrapped service or resource exactly as it would
       normally except that it provides the [4mDACS_ACS[24m argument. In some
       situations, if access would be denied [1mdacs_acs [22mwill return an
       indication of what must be done; e.g., the user must authenticate or a
       notice must be acknowledged. Note that there can be multiple reasons
       for denying access, in which case an application may have to repeatedly
       request a check and address the reason for denial before access may be
       granted.

       The [4mDACS_ACS[24m argument can be a query argument or can appear in a
       message body with the content type application/x-www-form-urlencoded
       (as in the case of an HTML form submitted using the POST method, for
       example). The [4mDACS_ACS[24m argument may not be specified more than once. It
       is not always possible to escape this argument (see [34m[1m-invisible[0m[1m[22m[60]).

       The following flags are recognized:

       [1m-check_only[0m
           The presence of this flag tells [1mdacs_acs [22mnot to actually execute
           the web service or return the resource, but to merely return the
           access control decision. This flag and the [1m-check_fail [22mflag are
           mutually exclusive.

           If the access check was performed, HTTP status code [1m200 [22m(OK) will
           be returned; any other result indicates that the check could not be
           executed (e.g., due to an [1mApache [22mconfiguration problem or a [1mDACS[0m
           error). If the check is performed, a DACS-Status-Line HTTP
           extension header is included in the response by default (see
           below).

           The default response consists of a single line of text that gives
           the result. This line consists of a three digit result code,
           followed by a space, an explanatory message, and a newline
           character; for example,

               797 Access denied
               798 Access granted
               799 Access error

           Inspecting the result code is sufficient to obtain the outcome of
           the check. Any [1mApache [22mErrorDocument directive for "error-code" 200
           is overridden. The [1m-format [22mflag (see below) can be used to select a
           different output format.

               [1mNote[0m
               The service or resource in question does not have to exist for
               [1mdacs_acs [22mto grant access; for instance, this can happen if a
               wildcard rule pattern is used. Also, keep in mind that access
               control rules can be written to be highly context specific;
               there is no guarantee that the same decision made at one point
               in time will also be made an instant later (access control
               rules can depend on the current date or time, for instance).

               Rules can be written such that their evaluation results in
               persistent changes; for example, a database might be updated.
               These kinds of changes will occur both in normal operation and
               when only checking access.  [1mdacs_acs [22mdefines the variable
               [4m${DACS::ACS}[24m only during the testing mode of operation so that,
               if necessary, rules can be written to differentiate between
               testing mode and normal operation.

       [1m-check_fail[0m
           This flag is like the [1m-check_only [22mflag, except if access is granted
           the request is allowed to proceed. If access is not granted and
           HTTP status code [1m200 [22mis returned, a DACS-Status-Line HTTP extension
           header is included in the response by default (see below). The
           [1m-check_fail [22mflag is useful in situations where a [1m-check_only [22mtest
           that indicates that access would be granted is always immediately
           followed by the actual request. This flag and the [1m-check_only [22mflag
           are mutually exclusive.

       [1m-format [4m[22mfmt[0m
           By default, the [1m-check_only [22mflag (and in the case where access is
           denied, also the [1m-check_fail [22mflag) results in a single line of text
           being output (equivalent to "[1m-format text[22m"). If more detail is
           required, an XML description can be produced by specifying any of
           the XML output formats. Refer to [34m[1mXML Output[0m[1m[22m[61], the [34m[4mFORMAT[24m CGI[0m
           [34margument[0m[62], and the [34m[1m-format[0m[1m[22m[63] command line argument.

       [1m-rname [4m[22mrname[0m
           The string [4mrname[24m, which is assumed to be the name of an Rlink, is
           made available available as [4m${Args::RNAME}[24m during evaluation of
           [34m[1mACS_PRE_AUTH[0m[1m[22m[64] directive expressions.

       [1m-status_line[0m
       [1m-no-status_line[0m
           The [1m-status_line [22mflag enables the [34m[1mDACS-Status-Line[0m[1m[22m[65] header,
           overriding the setting of the [34m[1mSTATUS_LINE[0m[1m[22m[66] configuration
           directive. The [1m-no_status_line [22mflag [4malways[24m suppresses this header,
           regardless of the [34m[1mSTATUS_LINE[0m[1m[22m[66] directive and the [1m-check_only [22mand
           [1m-check_fail [22mflags.

       [1m-visible[0m
       [1m-invisible[0m
           If the [4mDACS_ACS[24m argument is passed as a query argument, the default
           behaviour is to delete it so that it cannot be seen after access
           control processing grants access. This deletion is explicitly
           enabled by the [1m-invisible [22mflag and disabled by the [1m-visible [22mflag.
           If [4mDACS_ACS[24m is not deleted, it will be passed to an invoked program
           and might affect subsequent processing.

               [1mImportant[0m
               Deletion of the [4mDACS_ACS[24m argument is currently possible only if
               it is passed as a query argument.
           For example, consider the hypothetical URL:

               https://example.com/cgi-bin/myprog?DACS_ACS=-check_fail+-visible&foo=baz

           If the CGI program [1mmyprog [22mis executed, it will not only see the
           [4mfoo=baz[24m argument, but also the [4mDACS_ACS=-check_fail+-visible[0m
           argument, and this could trigger an error or incorrect behaviour
           when [1mmyprog [22mprocesses it.

           All [1mDACS [22mweb services ignore a [4mDACS_ACS[24m argument, however, so its
           presence will not affect them.

       The flag list is processed from left to right. Any flag may be
       repeated, with the value of a later occurrence overriding an earlier
       one. If some part of the [4mDACS_ACS[24m argument is invalid, the initial,
       valid part will still be effective; e.g., if the initial part is
       [1m-format [22mXML, the output format will be XML.

       [1mdacs_acs [22mremoves the [4mDACS_ACS[24m argument from the rule-processing
       environment so as not to disturb access control processing.  [1mDACS[0m
       credentials may accompany the service request just as they would a real
       request and are incorporated into the check.

       Assuming the target resource is [1mDACS[22m-wrapped, instead of returning the
       resource, accessing the following URL would return an indication of
       whether an actual request to access the resource would be granted or
       denied:

           % http -v -v \
            'https://dacs.dss.ca/infocard-demo/cgi-bin/dacs/dacs_version?DACS_ACS=-check_only%20-format+xml'

       [1mThe DACS-Status-Line header[0m
           When the [1mDACS_ACS=-check_only [22margument is present, the response
           from [1mDACS [22mincludes an extension header named DACS-Status-Line. The
           format of this extension header follows that of the HTTP
           Status-Line ([34m[1mRFC 2616[0m[1m[22m[30], section 6.1):

               DACS-Status-Line = "DACS-Status-Line" ":" [4mDACS-Version[24m SP [4mACS-Status-Code[0m
                 SP [4mReason-Phrase[24m CRLF

           Where:

               [4mDACS-Version[24m = "DACS-" [4mVersion[0m

           and [4mVersion[24m is the [1mDACS_VERSION_RELEASE [22mstring (e.g., 1.4.8b), and
           where:

               [4mACS-Status-Code[24m = "797" | "798" | "799"

           The status code [1m797 [22mmeans that [1mDACS [22mdenies access, [1m798 [22mmeans that
           it grants access, and [1m799 [22mmeans that an error occurred during
           processing.

           Here are some examples:

               DACS-Status-Line: DACS-1.4.8b 797 Access denied
               DACS-Status-Line: DACS-1.4.8b 798 Access granted
               DACS-Status-Line: DACS-1.4.8b 799 Access error

           The reason phrases in the examples are only recommendations; they
           may be replaced by local equivalents without affecting the
           protocol.

               [1mNote[0m
               The reason phrase may include additional information, such as
               an audit identifier, that can be used to track the request in
               the [1mDACS [22mlogs:

                   DACS-Status-Line: DACS-1.4.10 798 Access granted, unauth user (j10OXL2Z)

           This header is also returned when [1m-check_fail [22mis requested, but
           only if access is not granted.

       [1mThe DACS_APPROVAL environment variable[0m
           If enabled by the [34m[1mACS_EMIT_APPROVAL[0m[1m[22m[67] directive, the
           [1mDACS_APPROVAL [22menvironment variable will be passed to a [1mDACS[22m-wrapped
           program. If the program cares to verify that its execution has been
           authorized, it may validate the approval's signature (to ensure
           that the approval has not been forged) and validate the stamp (to
           ensure that the approval is not being replayed). Note that if a
           man-in-the-middle attack is of concern, end-to-end encryption
           should be used.

           With proper configuration, this feature can be used by a web-based
           program that is not [1mDACS[22m-wrapped but for which authorization has
           been obtained indirectly. For example, when [34m[1mdacs_uproxy(8)[0m[1m[22m[68],
           invokes a program, [1mdacs_uproxy [22mwill forward the value of
           [1mDACS_APPROVAL [22m(when available) to the invoked program, which can
           obtain the value in its [1mHTTP_DACS_UPROXY_APPROVAL [22menvironment
           variable. If it is able to validate the value (or can trust it),
           the invoked program knows that its execution was authorized by
           [1mDACS[22m, even though [1mDACS [22mmay not be configured or even installed on
           the host where the invoked program runs.

           A jurisdiction's cryptographic keys, identified by the virtual
           filestore item type jurisdiction_keys, must be configured so that
           the approval can be digitally signed.

           The value of [1mDACS_APPROVAL [22mhas the following format:

               a="[4mdacs64-approval-message[24m", s="[4mdacs64-signature[24m"

           The [4mdacs64-approval-message[24m is a [34m[1mdacs64[0m[1m[22m[33] encoded string,
           described below. The [4mdacs64-signature[24m is the dacs64 encoded RSA
           signature of the approval message, which is the unencoded
           [4mdacs64-approval-message[24m.

           An approval message has the following format:

               j="[4mjurisdiction-name[24m"<newline>
               h="[4mdigest-name[24m"<newline>
               s="[4mstamp[24m"<newline>
               u="[4muri[24m"<newline>
               m="[4mmethod[24m"<newline>
               i="[4mident[24m"

           Here, [4mjurisdiction-name[24m is the name of the jurisdiction (including
           its federation name) that generated the approval. The name of the
           message digest (secure hash) algorithm used to sign the approval is
           [4mdigest-name[24m. The unique stamp is [4mstamp[24m (as generated by
           [34m[1mustamp()[0m[1m[22m[69]) and the URI, including any query component, is [4muri[24m.
           The HTTP method is [4mmethod[24m. The [1mDACS [22midentity of the user for which
           access was granted is [4mident[24m (or "unauth", if none). The [4mstamp[24m and
           [4mmethod[24m are mapped to lowercase. Here is an example of an approval
           message:

               j="DSS::DSS-dacs"
               h="SHA1"
               s="1185565675:130",
               u="http://example.com/cgi-bin/dacs/dacs_current_credentials?FORMAT=HTML"
               m="get"
               i="unauth"

           The RSA signature is computed using the jurisdiction's private key
           and SHA-1 (by default) over the approval message. A different
           message digest algorithm can be used by setting the configuration
           variable [4m${Conf::dacs_approval_digest_name}[24m (see [34m[1mdigest()[0m[1m[22m[70] for
           information about message digest algorithms):

               EVAL ${Conf::dacs_approval_digest_name} = "SHA256"


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacsacl(1)[0m[1m[22m[43], [34m[1mdacscheck(1)[0m[1m[22m[2], [34m[1mdacs.acls(5)[0m[1m[22m[4], [34m[1mdacs.conf(5)[0m[1m[22m[47],
       [34m[1mdacs_admin(8)[0m[1m[22m[44]

[1mBUGS[0m
       While the [4mDACS_ACS[24m mechanism can be useful, it is still a kludge,

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[71])

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[72] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        3. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

        4. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        5. logging
           http://dacs.dss.ca/man/dacs.1.html#logging

        6. LOG_LEVEL
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_LEVEL

        7. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

        8. AddDACSAuth
           http://dacs.dss.ca/man/mod_auth_dacs.html#AddDACSAuth

        9. DACS_HOME
           http://dacs.dss.ca/man/dacs.conf.5.html#var_dacs_home

       10. pipe(2)
           http://www.freebsd.org/cgi/man.cgi?query=pipe&apropos=0&sektion=2&manpath=FreeBSD+9.1-RELEASE&format=html

       11. Variables Available To Rules
           http://dacs.dss.ca/man/#vars_in_rules

       12. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html#SetDACSAuthPostBuffer

       13. ALLOW_HTTP_COOKIE
           http://dacs.dss.ca/man/dacs.conf.5.html#ALLOW_HTTP_COOKIE

       14. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       15. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#credentials

       16. dacsrlink(1)
           http://dacs.dss.ca/man/dacsrlink.1.html

       17. RLINK
           http://dacs.dss.ca/man/dacs.conf.5.html#RLINK

       18. the one used for normal rules
           http://dacs.dss.ca/man/dacs.acls.5.html#acl_files

       19. concise user identity
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       20. identity element
           http://dacs.dss.ca/man/dacs.acls.5.html#elements

       21. DACS_ACS argument
           http://dacs.dss.ca/man/#dacs_acs_argument

       22. redirect()
           http://dacs.dss.ca/man/dacs.exprs.5.html#redirect

       23. HTTP_AUTH_ENABLE
           http://dacs.dss.ca/man/dacs.conf.5.html#HTTP_AUTH_ENABLE

       24. HTTP_AUTH
           http://dacs.dss.ca/man/dacs.conf.5.html#HTTP_AUTH

       25. Auth clause directives
           http://dacs.dss.ca/man/dacs_authenticate.8.html#auth_clause

       26. local_apache_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_apache_authenticate

       27. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

       28. AUTH_SUCCESS_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS_HANDLER

       29. AUTH_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_ERROR_HANDLER

       30. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

       31. dacshttp(1)
           http://dacs.dss.ca/man/dacshttp.1.html

       32. passed using this request-header
           http://dacs.dss.ca/man/#http_authentication

       33. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

       34. COOKIE_PATH
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_PATH

       35. COOKIE_NO_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_NO_DOMAIN

       36. COOKIE_HTTP_ONLY
           http://dacs.dss.ca/man/dacs.conf.5.html#COOKIE_HTTP_ONLY

       37. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html#configure_options

       38. ACS_ACCESS_TOKEN_ENABLE
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ACCESS_TOKEN_ENABLE

       39. ACS_ACCESS_TOKEN_LIFETIME_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ACCESS_TOKEN_LIFETIME_LIMIT

       40. ACS_ACCESS_TOKEN_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ACCESS_TOKEN_LIFETIME_SECS

       41. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html#acl_syntax

       42. tail matching
           http://dacs.dss.ca/man/dacs.acls.5.html#tail_matching

       43. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       44. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       45. revocation list
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       46. dacs_acs.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_acs.dtd

       47. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       48. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       49. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#variables

       50. RFC 1867
           http://www.rfc-editor.org/rfc/rfc1867.txt

       51. RFC 2388
           http://www.rfc-editor.org/rfc/rfc2388.txt

       52. HTML 4
           http://www.w3.org/TR/html4

       53. ACS_POST_EXCEPTION_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_POST_EXCEPTION_MODE

       54. Rlinks
           http://dacs.dss.ca/man/#rlinks

       55. PHP
           http://www.php.net

       56. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       57. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

       58. mod_jk
           http://tomcat.apache.org/connectors-doc/generic_howto/quick.html

       59. Tomcat
           http://jakarta.apache.org

       60. [1m-invisible[0m
           http://dacs.dss.ca/man/#invisible_flag

       61. XML Output
           http://dacs.dss.ca/man/#XML-output

       62. [4mFORMAT[24m CGI argument
           http://dacs.dss.ca/man/dacs.1.html#FORMAT

       63. [1m-format[0m
           http://dacs.dss.ca/man/dacs.1.html#format-arg

       64. ACS_PRE_AUTH
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_PRE_AUTH

       65. DACS-Status-Line
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_status_line

       66. STATUS_LINE
           http://dacs.dss.ca/man/dacs.conf.5.html#STATUS_LINE

       67. ACS_EMIT_APPROVAL
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_EMIT_APPROVAL

       68. dacs_uproxy(8)
           http://dacs.dss.ca/man/dacs_uproxy.8.html

       69. ustamp()
           http://dacs.dss.ca/man/dacs.exprs.5.html#ustamp

       70. digest()
           http://dacs.dss.ca/man/dacs.exprs.5.html#digest

       71. www.dss.ca
           http://www.dss.ca

       72. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACS_ACS(8)
