//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobListModel.h
//! @brief     Defines class JobListModel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBLISTMODEL_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBLISTMODEL_H

#include <QAbstractListModel>

class JobItem;
class JobModel;

class JobListModel : public QAbstractListModel {
    Q_OBJECT

public:
    JobListModel(JobModel* jobs, QObject* parent = nullptr);
    ~JobListModel() override;

    int rowCount(const QModelIndex& parent = QModelIndex()) const override;

    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;

    JobItem* jobItemForIndex(const QModelIndex& index) const;
    QModelIndex indexForJob(JobItem* job);

    void runJob(const QModelIndex& index);
    void removeJob(const QModelIndex& index);
    void cancelJob(const QModelIndex& index);

private slots:
    void emitJobListModelChanged(JobItem* job);
    void onJobAdded();

private:
    void enableJobNotification(JobItem* job);
    void disableJobNotification(JobItem* job);

private:
    JobModel* m_jobs;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBLISTMODEL_H
