//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Data/JobStatus.h
//! @brief     Defines enum JobStatus
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_DATA_JOBSTATUS_H
#define BORNAGAIN_GUI_SUPPORT_DATA_JOBSTATUS_H

#include <QString>

//! The JobStatus enum lists the possible states of a job

enum class JobStatus {
    Idle,      //!< the job has not been started yet
    Running,   //!< the job is busy calculating
    Fitting,   //!< the job is busy fitting
    Completed, //!< the job was successfully completed
    Canceled,  //!< the job was stopped by the user
    Failed     //!< the job aborted because it hit an error
};

//! Returns a string representation of the status
QString jobStatusToString(JobStatus status);

//! Returns status value for given string representation
JobStatus jobStatusFromString(const QString& name);

#endif // BORNAGAIN_GUI_SUPPORT_DATA_JOBSTATUS_H
