//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Data/ProjectionItems.cpp
//! @brief     Implements items related to projections over color map.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Data/ProjectionItems.h"
ProjectionContainerItem::ProjectionContainerItem()
    : MaskContainerItem()
{
}

QVector<MaskItem*>
ProjectionContainerItem::projectionsOfType(GUI::ID::ProjectionType projectionType)
{
    if (projectionType == GUI::ID::ProjectionType::Horizontal)
        return projections<HorizontalLineItem>();
    else if (projectionType == GUI::ID::ProjectionType::Vertical)
        return projections<VerticalLineItem>();
    else
        ASSERT(false);
    return {};
}
