/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class AJInstaller
extends MatchingTask {
    static final String INCLUDE_CLASSES = "$installer$/org/aspectj/*.class";
    static final String MAIN_CLASS = "$installer$.org.aspectj.Main";
    static final String CONTENTS_FILE = "$installer$/org/aspectj/resources/contents.txt";
    private String htmlSrc;
    private String resourcesSrc;
    private String mainclass;
    private File installerClassJar;
    protected List contentsNames = new ArrayList();
    protected long contentsBytes = 0L;
    static final char NEWLINE = '\n';
    private File zipFile;
    private File baseDir;
    private boolean doCompress = true;
    protected String archiveType = "zip";

    public void setHtmlSrc(String v) {
        this.htmlSrc = v;
    }

    public void setResourcesSrc(String v) {
        this.resourcesSrc = v;
    }

    public void setMainclass(String v) {
        this.mainclass = v;
    }

    public void setInstallerclassjar(String v) {
        this.installerClassJar = this.project.resolveFile(v);
    }

    protected void addToContents(File file, String vPath) {
        this.contentsNames.add(vPath);
        this.contentsBytes += file.length();
    }

    String[] getFiles(File baseDir) {
        DirectoryScanner ds = new DirectoryScanner();
        this.setBasedir(baseDir.getAbsolutePath());
        ds.setBasedir(baseDir);
        ds.scan();
        return ds.getIncludedFiles();
    }

    protected Copy getCopyTask() {
        Copy cd = (Copy)this.project.createTask("copy");
        if (null == cd) {
            this.log("project.createTask(\"copy\") failed - direct", 3);
            cd = new Copy();
            cd.setProject(this.getProject());
        }
        return cd;
    }

    protected void finishZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        this.writeContents(zOut);
        this.writeManifest(zOut);
        File tempDir = this.setupTempDir();
        String tmp = tempDir.getAbsolutePath();
        Expand expand = new Expand();
        expand.setProject(this.getProject());
        expand.setSrc(this.installerClassJar);
        expand.setDest(new File(tmp));
        PatternSet patterns = new PatternSet();
        patterns.setIncludes(INCLUDE_CLASSES);
        expand.addPatternset(patterns);
        expand.execute();
        Copy cd = this.getCopyTask();
        this.fileset = new FileSet();
        this.fileset.setDir(new File(this.resourcesSrc));
        this.fileset.setIncludes("*");
        this.fileset.setExcludes("contents.txt,properties.txt");
        cd.addFileset(this.fileset);
        cd.setTodir(new File(tmp + "/$installer$/org/aspectj/resources"));
        cd.execute();
        this.project.getGlobalFilterSet().addFilter("installer.main.class", this.mainclass);
        Copy cf = this.getCopyTask();
        this.fileset = new FileSet();
        this.fileset.setDir(new File(this.resourcesSrc));
        this.fileset.setIncludes("properties.txt");
        cf.setFiltering(true);
        cf.addFileset(this.fileset);
        cf.setTodir(new File(tmp + "/$installer$/org/aspectj/resources"));
        cf.execute();
        cd = this.getCopyTask();
        this.fileset = new FileSet();
        this.fileset.setDir(new File(this.htmlSrc));
        this.fileset.setIncludes("*");
        cd.addFileset(this.fileset);
        cd.setTodir(new File(tmp + "/$installer$/org/aspectj/resources"));
        cd.execute();
        this.setBasedir(tmp);
        this.writeFiles(zOut, this.getFiles(tempDir));
        Delete dt = (Delete)this.project.createTask("delete");
        if (null == dt) {
            dt = new Delete();
            dt.setProject(this.getProject());
        }
        dt.setDir(tempDir);
        dt.execute();
        tempDir = null;
    }

    protected void writeContents(ZipOutputStream zOut) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.contentsBytes);
        buf.append('\n');
        for (String name : this.contentsNames) {
            buf.append(name);
            buf.append('\n');
        }
        this.zipFile(new StringBufferInputStream(buf.toString()), zOut, CONTENTS_FILE, System.currentTimeMillis());
    }

    protected void writeManifest(ZipOutputStream zOut) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("Manifest-Version: 1.0");
        buf.append('\n');
        buf.append("Main-Class: $installer$.org.aspectj.Main");
        buf.append('\n');
        this.zipFile(new StringBufferInputStream(buf.toString()), zOut, "META-INF/MANIFEST.MF", System.currentTimeMillis());
    }

    public void setZipfile(String zipFilename) {
        this.zipFile = this.project.resolveFile(zipFilename);
    }

    public void setBasedir(String baseDirname) {
        this.baseDir = this.project.resolveFile(baseDirname);
    }

    public void setCompress(String compress) {
        this.doCompress = Project.toBoolean((String)compress);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified) throws IOException {
        ZipEntry ze = new ZipEntry(vPath);
        ze.setTime(lastModified);
        if (!this.doCompress) {
            long size = 0L;
            CRC32 cal = new CRC32();
            if (!in.markSupported()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                    bos.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in = new ByteArrayInputStream(bos.toByteArray());
            } else {
                in.mark(Integer.MAX_VALUE);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.reset();
            }
            ze.setSize(size);
            ze.setCrc(cal.getValue());
        }
        zOut.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.startsWith("$installer$")) {
            this.addToContents(file, vPath);
        }
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified());
        }
        finally {
            fIn.close();
        }
    }

    private File setupTempDir() throws BuildException {
        File tmpDirF = null;
        File tmpDir = null;
        try {
            tmpDirF = File.createTempFile("tgz", ".di");
            tmpDir = new File(tmpDirF.getParentFile(), "AJInstaller");
            tmpDirF.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(null != tmpDir && tmpDir.mkdirs() || (tmpDir = new File("AJInstaller.finishZipOutputStream.tmp")).mkdirs())) {
            throw new BuildException("unable to make temp dir");
        }
        return tmpDir;
    }

    public void execute() throws BuildException {
        if (this.installerClassJar == null) {
            throw new BuildException("installerClassJar attribute must be set!");
        }
        if (!this.installerClassJar.canRead() || !this.installerClassJar.getPath().endsWith(".jar")) {
            throw new BuildException("not readable jar:" + this.installerClassJar);
        }
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!");
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!");
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.baseDir);
        String[] files = ds.getIncludedFiles();
        String[] dirs = ds.getIncludedDirectories();
        this.log("Building installer: " + this.zipFile.getAbsolutePath());
        ZipOutputStream zOut = null;
        try {
            zOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
            if (this.doCompress) {
                zOut.setMethod(8);
            } else {
                zOut.setMethod(0);
            }
            this.initZipOutputStream(zOut);
            this.writeDirs(zOut, dirs);
            this.writeFiles(zOut, files);
            this.finishZipOutputStream(zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.archiveType + " " + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe, this.location);
        }
        finally {
            if (zOut != null) {
                try {
                    zOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void writeDirs(ZipOutputStream zOut, String[] dirs) throws IOException {
        for (int i = 0; i < dirs.length; ++i) {
            File f = new File(this.baseDir, dirs[i]);
            String name = dirs[i].replace(File.separatorChar, '/') + "/";
            this.zipDir(f, zOut, name);
        }
    }

    protected void writeFiles(ZipOutputStream zOut, String[] files) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            File f = new File(this.baseDir, files[i]);
            String name = files[i].replace(File.separatorChar, '/');
            this.zipFile(f, zOut, name);
        }
    }
}

