/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:54:26 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.SystemColor;
import java.util.Vector;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.GenericDocument;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.emboss.jemboss.JembossParams;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import org.w3c.dom.DOMImplementation;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.GCGraph;
import uk.ac.sanger.artemis.circular.GCSkewGraph;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Graph_ESTest extends Graph_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setMinValue(2);
      assertEquals(2.0F, gCGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      int int0 = gCGraph0.getWindowSize();
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(10000, int0);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.getBases();
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      String[] stringArray0 = new String[4];
      // Undeclared exception!
      try { 
        gCSkewGraph0.setOptionsStr(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType(" minus_colour=", " does not cut upstream of the recognition site", " minus_colour=");
      DOMImplementation dOMImplementation0 = GenericDOMImplementation.getDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, dOMImplementation0);
      SVGGeneratorContext sVGGeneratorContext0 = SVGGeneratorContext.createDefault(genericDocument0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(sVGGeneratorContext0, false);
      // Undeclared exception!
      try { 
        gCGraph0.drawLinear(sVGGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Graph", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("RETRIEVE SOURCE FEATURE FROM: ", "RETRIEVE SOURCE FEATURE FROM: ", "");
      GenericDOMImplementation genericDOMImplementation0 = new GenericDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, genericDOMImplementation0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(genericDocument0);
      // Undeclared exception!
      try { 
        gCSkewGraph0.draw(sVGGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Graph", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      // Undeclared exception!
      try { 
        gCGraph0.calculateValue(4, 4);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.GCGraph", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      // Undeclared exception!
      try { 
        gCSkewGraph0.calcGraphValues();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Graph", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      Color color0 = gCGraph0.getPlusColour();
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals((-5000422), color0.getRGB());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.getCurrentDna();
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      int int0 = gCSkewGraph0.getBaseStepSize();
      assertEquals(200, int0);
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPublicServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      Color color0 = gCGraph0.getMinusColour();
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals((-6750055), color0.getRGB());
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      float float0 = gCSkewGraph0.getGraphHeight();
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      assertEquals(0.2F, float0, 0.01F);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      double double0 = gCSkewGraph0.getTrack();
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, double0, 0.01);
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      String[] stringArray0 = new String[5];
      stringArray0[0] = "";
      stringArray0[1] = "";
      stringArray0[2] = "base_step_size";
      // Undeclared exception!
      try { 
        gCSkewGraph0.setOptionsStr(stringArray0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // null
         //
         verifyException("java.lang.Integer", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      String[] stringArray0 = new String[5];
      stringArray0[0] = "aaLK\"HhS#";
      stringArray0[1] = "Malformed integer";
      stringArray0[2] = "zPRPLZa'";
      stringArray0[3] = "Y6/47zV NvX[";
      stringArray0[4] = "GBSeq_database-reference";
      gCSkewGraph0.setOptionsStr(stringArray0);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setStrokeSize(350);
      assertEquals(350, gCGraph0.getStrokeSize());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      Color color0 = Color.lightGray;
      gCSkewGraph0.setMinusColour(color0);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      float float0 = gCSkewGraph0.getMaxValue();
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      assertEquals(1.4E-45F, float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPrivateServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      int int0 = gCGraph0.getStrokeSize();
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(1, int0);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      gCSkewGraph0.setBaseStepSize((-662));
      assertEquals((-662), gCSkewGraph0.getBaseStepSize());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      // Undeclared exception!
      try { 
        gCGraph0.showOptions();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DropTarget", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setMaxValue((-1313.541F));
      assertEquals((-1313.541F), gCGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      gCSkewGraph0.setGraphHeight(2.456F);
      assertEquals(2.456F, gCSkewGraph0.getGraphHeight(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      
      gCSkewGraph0.setTrack(1.0);
      assertEquals(1.0, gCSkewGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      SystemColor systemColor0 = SystemColor.window;
      gCGraph0.setPlusColour(systemColor0);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      float float0 = gCGraph0.getMinValue();
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, float0, 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("uk.ac.sanger.artemis.circular.Graph", "Complement position", "uk.ac.sanger.artemis.circular.Graph");
      GenericDOMImplementation genericDOMImplementation0 = new GenericDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, genericDOMImplementation0);
      SVGGeneratorContext sVGGeneratorContext0 = SVGGeneratorContext.createDefault(genericDocument0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(sVGGeneratorContext0, false);
      // Undeclared exception!
      try { 
        gCGraph0.paintComponent(sVGGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Graph", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setWindowSize((-5077));
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      JembossParams jembossParams0 = new JembossParams();
      Vector vector0 = jembossParams0.getPrivateServers();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      String string0 = gCSkewGraph0.getOptionsStr();
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals("height=0.2 window_size=10000 base_step_size=200 track=0.4 minus_colour=153:0:153 plus_colour=179:179:26", string0);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
  }
}
