/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineBuilder.class);
    private static final String LINESEP = System.getProperty("line.separator");
    private File commandLineFile = File.createTempFile("cobertura.", ".cmdline");
    private FileWriter commandLineWriter = null;

    public CommandLineBuilder() throws IOException {
        this.commandLineFile.deleteOnExit();
        this.commandLineWriter = new FileWriter(this.commandLineFile);
    }

    public void addArg(String arg) throws IOException {
        if (arg == null) {
            throw new NullPointerException();
        }
        this.commandLineWriter.write(arg + LINESEP);
    }

    public void addArg(String arg1, String arg2) throws IOException {
        this.addArg(arg1);
        this.addArg(arg2);
    }

    public void saveArgs() throws IOException {
        this.commandLineWriter.flush();
        this.commandLineWriter.close();
    }

    public String getCommandLineFile() {
        return this.commandLineFile.getAbsolutePath();
    }

    public void dispose() {
        this.commandLineFile.delete();
    }

    public static String[] preprocessCommandLineArguments(String[] args) throws IOException {
        boolean hasCommandsFile = false;
        String commandsFileName = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--commandsfile")) continue;
            if (i == args.length - 1) {
                throw new IllegalArgumentException("'--commandsfile' specified as last option.");
            }
            hasCommandsFile = true;
            commandsFileName = args[++i];
        }
        if (hasCommandsFile) {
            ArrayList<String> arglist = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new FileReader(commandsFileName));
                while ((line = bufferedReader.readLine()) != null) {
                    arglist.add(line);
                }
            }
            catch (IOException e) {
                logger.info("I/O error when reading temporary commands file", (Throwable)e);
                throw new IOException("Unable to read temporary commands file " + commandsFileName + ".");
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {}
                }
            }
            args = arglist.toArray(new String[arglist.size()]);
        }
        return args;
    }
}

