//
// anyRemote
// a bluetooth remote for your PC.
//
// Copyright (C) 2006-2013 Mikhail Fedotov <anyremote@mail.ru>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _DISPATCHER_H_
#define _DISPATCHER_H_

#include "str.h"

enum DispMsgType {
    DM_SET = 0,
    DM_SETFILE,
    DM_SENDB,
    DM_SENDS,
    DM_CKPD,
    DM_CMER,
    DM_EVENT_INIT,
    DM_EVENT_DISCONNECT,
    DM_EVENT_EXIT,
    DM_TYPE_MAX
};


typedef struct {
    int   type;
    int   size;
    void* value;
    char* file;
} dMessage;

pointer_t dispatcherRoutine (pointer_t thread);
void  	  sendToDispatcher  (dMessage *buf);
void  	  freeDMessage      (void* ptr);
void      parseCommand      (char* cmd);
void      closePort         (int final);
char*     readFromFile      (char *cmdTag, char* file, int* size);
dMessage* getDFinalizer     (void);

#endif
