/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NDMP4_H_RPCGEN
#define _NDMP4_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#ifndef NDMOS_OPTION_NO_NDMP4
#define NDMP4VER 4
#define NDMP4PORT 10000
#define ndmp4_u_quad unsigned long long
extern bool_t xdr_ndmp4_u_quad();

struct _ndmp4_u_quad {
	u_long high;
	u_long low;
};
typedef struct _ndmp4_u_quad _ndmp4_u_quad;

enum ndmp4_header_message_type {
	NDMP4_MESSAGE_REQUEST = 0,
	NDMP4_MESSAGE_REPLY = 1,
};
typedef enum ndmp4_header_message_type ndmp4_header_message_type;
#define NDMP4_MESSAGE_POST NDMP4_MESSAGE_REQUEST

enum ndmp4_error {
	NDMP4_NO_ERR = 0,
	NDMP4_NOT_SUPPORTED_ERR = 1,
	NDMP4_DEVICE_BUSY_ERR = 2,
	NDMP4_DEVICE_OPENED_ERR = 3,
	NDMP4_NOT_AUTHORIZED_ERR = 4,
	NDMP4_PERMISSION_ERR = 5,
	NDMP4_DEV_NOT_OPEN_ERR = 6,
	NDMP4_IO_ERR = 7,
	NDMP4_TIMEOUT_ERR = 8,
	NDMP4_ILLEGAL_ARGS_ERR = 9,
	NDMP4_NO_TAPE_LOADED_ERR = 10,
	NDMP4_WRITE_PROTECT_ERR = 11,
	NDMP4_EOF_ERR = 12,
	NDMP4_EOM_ERR = 13,
	NDMP4_FILE_NOT_FOUND_ERR = 14,
	NDMP4_BAD_FILE_ERR = 15,
	NDMP4_NO_DEVICE_ERR = 16,
	NDMP4_NO_BUS_ERR = 17,
	NDMP4_XDR_DECODE_ERR = 18,
	NDMP4_ILLEGAL_STATE_ERR = 19,
	NDMP4_UNDEFINED_ERR = 20,
	NDMP4_XDR_ENCODE_ERR = 21,
	NDMP4_NO_MEM_ERR = 22,
	NDMP4_CONNECT_ERR = 23,
	NDMP4_SEQUENCE_NUM_ERR = 24,
	NDMP4_READ_IN_PROGRESS_ERR = 25,
	NDMP4_PRECONDITION_ERR = 26,
	NDMP4_CLASS_NOT_SUPPORTED = 27,
	NDMP4_VERSION_NOT_SUPPORTED = 28,
	NDMP4_EXT_DUPL_CLASSES = 29,
	NDMP4_EXT_DN_ILLEGAL = 30,
};
typedef enum ndmp4_error ndmp4_error;

enum ndmp4_message {
	NDMP4_CONNECT_OPEN = 0x900,
	NDMP4_CONNECT_CLIENT_AUTH = 0x901,
	NDMP4_CONNECT_CLOSE = 0x902,
	NDMP4_CONNECT_SERVER_AUTH = 0x903,
	NDMP4_CONFIG_GET_HOST_INFO = 0x100,
	NDMP4_CONFIG_GET_CONNECTION_TYPE = 0x102,
	NDMP4_CONFIG_GET_AUTH_ATTR = 0x103,
	NDMP4_CONFIG_GET_BUTYPE_INFO = 0x104,
	NDMP4_CONFIG_GET_FS_INFO = 0x105,
	NDMP4_CONFIG_GET_TAPE_INFO = 0x106,
	NDMP4_CONFIG_GET_SCSI_INFO = 0x107,
	NDMP4_CONFIG_GET_SERVER_INFO = 0x108,
	NDMP4_CONFIG_SET_EXT_LIST = 0x109,
	NDMP4_CONFIG_GET_EXT_LIST = 0x10A,
	NDMP4_SCSI_OPEN = 0x200,
	NDMP4_SCSI_CLOSE = 0x201,
	NDMP4_SCSI_GET_STATE = 0x202,
	NDMP4_SCSI_RESET_DEVICE = 0x204,
	NDMP4_SCSI_EXECUTE_CDB = 0x206,
	NDMP4_TAPE_OPEN = 0x300,
	NDMP4_TAPE_CLOSE = 0x301,
	NDMP4_TAPE_GET_STATE = 0x302,
	NDMP4_TAPE_MTIO = 0x303,
	NDMP4_TAPE_WRITE = 0x304,
	NDMP4_TAPE_READ = 0x305,
	NDMP4_TAPE_EXECUTE_CDB = 0x307,
	NDMP4_DATA_GET_STATE = 0x400,
	NDMP4_DATA_START_BACKUP = 0x401,
	NDMP4_DATA_START_RECOVER = 0x402,
	NDMP4_DATA_ABORT = 0x403,
	NDMP4_DATA_GET_ENV = 0x404,
	NDMP4_DATA_STOP = 0x407,
	NDMP4_DATA_LISTEN = 0x409,
	NDMP4_DATA_CONNECT = 0x40A,
	NDMP4_DATA_START_RECOVER_FILEHIST = 0x40B,
	NDMP4_NOTIFY_DATA_HALTED = 0x501,
	NDMP4_NOTIFY_CONNECTION_STATUS = 0x502,
	NDMP4_NOTIFY_MOVER_HALTED = 0x503,
	NDMP4_NOTIFY_MOVER_PAUSED = 0x504,
	NDMP4_NOTIFY_DATA_READ = 0x505,
	NDMP4_LOG_FILE = 0x602,
	NDMP4_LOG_MESSAGE = 0x603,
	NDMP4_FH_ADD_FILE = 0x703,
	NDMP4_FH_ADD_DIR = 0x704,
	NDMP4_FH_ADD_NODE = 0x705,
	NDMP4_MOVER_GET_STATE = 0xA00,
	NDMP4_MOVER_LISTEN = 0xA01,
	NDMP4_MOVER_CONTINUE = 0xA02,
	NDMP4_MOVER_ABORT = 0xA03,
	NDMP4_MOVER_STOP = 0xA04,
	NDMP4_MOVER_SET_WINDOW = 0xA05,
	NDMP4_MOVER_READ = 0xA06,
	NDMP4_MOVER_CLOSE = 0xA07,
	NDMP4_MOVER_SET_RECORD_SIZE = 0xA08,
	NDMP4_MOVER_CONNECT = 0xA09,
	NDMP4_EXT_STANDARD_BASE = 0x10000,
	NDMP4_EXT_PROPRIETARY_BASE = 0x20000000,
};
typedef enum ndmp4_message ndmp4_message;

struct ndmp4_header {
	u_long sequence;
	u_long time_stamp;
	ndmp4_header_message_type message_type;
	ndmp4_message message_code;
	u_long reply_sequence;
	ndmp4_error error_code;
};
typedef struct ndmp4_header ndmp4_header;

struct ndmp4_pval {
	char *name;
	char *value;
};
typedef struct ndmp4_pval ndmp4_pval;

struct ndmp4_connect_open_request {
	u_short protocol_version;
};
typedef struct ndmp4_connect_open_request ndmp4_connect_open_request;

struct ndmp4_connect_open_reply {
	ndmp4_error error;
};
typedef struct ndmp4_connect_open_reply ndmp4_connect_open_reply;

enum ndmp4_auth_type {
	NDMP4_AUTH_NONE = 0,
	NDMP4_AUTH_TEXT = 1,
	NDMP4_AUTH_MD5 = 2,
};
typedef enum ndmp4_auth_type ndmp4_auth_type;

struct ndmp4_auth_text {
	char *auth_id;
	char *auth_password;
};
typedef struct ndmp4_auth_text ndmp4_auth_text;

struct ndmp4_auth_md5 {
	char *auth_id;
	char auth_digest[16];
};
typedef struct ndmp4_auth_md5 ndmp4_auth_md5;

struct ndmp4_auth_data {
	ndmp4_auth_type auth_type;
	union {
		struct ndmp4_auth_text auth_text;
		struct ndmp4_auth_md5 auth_md5;
	} ndmp4_auth_data_u;
};
typedef struct ndmp4_auth_data ndmp4_auth_data;

struct ndmp4_auth_attr {
	ndmp4_auth_type auth_type;
	union {
		char challenge[64];
	} ndmp4_auth_attr_u;
};
typedef struct ndmp4_auth_attr ndmp4_auth_attr;

struct ndmp4_connect_client_auth_request {
	ndmp4_auth_data auth_data;
};
typedef struct ndmp4_connect_client_auth_request ndmp4_connect_client_auth_request;

struct ndmp4_connect_client_auth_reply {
	ndmp4_error error;
};
typedef struct ndmp4_connect_client_auth_reply ndmp4_connect_client_auth_reply;

struct ndmp4_connect_server_auth_request {
	ndmp4_auth_attr client_attr;
};
typedef struct ndmp4_connect_server_auth_request ndmp4_connect_server_auth_request;

struct ndmp4_connect_server_auth_reply {
	ndmp4_error error;
	ndmp4_auth_data server_result;
};
typedef struct ndmp4_connect_server_auth_reply ndmp4_connect_server_auth_reply;

struct ndmp4_config_get_host_info_reply {
	ndmp4_error error;
	char *hostname;
	char *os_type;
	char *os_vers;
	char *hostid;
};
typedef struct ndmp4_config_get_host_info_reply ndmp4_config_get_host_info_reply;

struct ndmp4_config_get_server_info_reply {
	ndmp4_error error;
	char *vendor_name;
	char *product_name;
	char *revision_number;
	struct {
		u_int auth_type_len;
		ndmp4_auth_type *auth_type_val;
	} auth_type;
};
typedef struct ndmp4_config_get_server_info_reply ndmp4_config_get_server_info_reply;

enum ndmp4_addr_type {
	NDMP4_ADDR_LOCAL = 0,
	NDMP4_ADDR_TCP = 1,
	NDMP4_ADDR_RESERVED = 2,
	NDMP4_ADDR_IPC = 3,
};
typedef enum ndmp4_addr_type ndmp4_addr_type;

struct ndmp4_config_get_connection_type_reply {
	ndmp4_error error;
	struct {
		u_int addr_types_len;
		ndmp4_addr_type *addr_types_val;
	} addr_types;
};
typedef struct ndmp4_config_get_connection_type_reply ndmp4_config_get_connection_type_reply;

struct ndmp4_config_get_auth_attr_request {
	ndmp4_auth_type auth_type;
};
typedef struct ndmp4_config_get_auth_attr_request ndmp4_config_get_auth_attr_request;

struct ndmp4_config_get_auth_attr_reply {
	ndmp4_error error;
	ndmp4_auth_attr server_attr;
};
typedef struct ndmp4_config_get_auth_attr_reply ndmp4_config_get_auth_attr_reply;
#define NDMP4_BUTYPE_BACKUP_FILELIST 0x0002
#define NDMP4_BUTYPE_RECOVER_FILELIST 0x0004
#define NDMP4_BUTYPE_BACKUP_DIRECT 0x0008
#define NDMP4_BUTYPE_RECOVER_DIRECT 0x0010
#define NDMP4_BUTYPE_BACKUP_INCREMENTAL 0x0020
#define NDMP4_BUTYPE_RECOVER_INCREMENTAL 0x0040
#define NDMP4_BUTYPE_BACKUP_UTF8 0x0080
#define NDMP4_BUTYPE_RECOVER_UTF8 0x0100
#define NDMP4_BUTYPE_BACKUP_FH_FILE 0x0200
#define NDMP4_BUTYPE_BACKUP_FH_DIR 0x0400
#define NDMP4_BUTYPE_RECOVER_FILEHIST 0x0800
#define NDMP4_BUTYPE_RECOVER_FH_FILE 0x1000
#define NDMP4_BUTYPE_RECOVER_FH_DIR 0x2000

struct ndmp4_butype_info {
	char *butype_name;
	struct {
		u_int default_env_len;
		ndmp4_pval *default_env_val;
	} default_env;
	u_long attrs;
};
typedef struct ndmp4_butype_info ndmp4_butype_info;

struct ndmp4_config_get_butype_info_reply {
	ndmp4_error error;
	struct {
		u_int butype_info_len;
		ndmp4_butype_info *butype_info_val;
	} butype_info;
};
typedef struct ndmp4_config_get_butype_info_reply ndmp4_config_get_butype_info_reply;
#define NDMP4_FS_INFO_TOTAL_SIZE_UNS 0x00000001
#define NDMP4_FS_INFO_USED_SIZE_UNS 0x00000002
#define NDMP4_FS_INFO_AVAIL_SIZE_UNS 0x00000004
#define NDMP4_FS_INFO_TOTAL_INODES_UNS 0x00000008
#define NDMP4_FS_INFO_USED_INODES_UNS 0x00000010

struct ndmp4_fs_info {
	u_long unsupported;
	char *fs_type;
	char *fs_logical_device;
	char *fs_physical_device;
	ndmp4_u_quad total_size;
	ndmp4_u_quad used_size;
	ndmp4_u_quad avail_size;
	ndmp4_u_quad total_inodes;
	ndmp4_u_quad used_inodes;
	struct {
		u_int fs_env_len;
		ndmp4_pval *fs_env_val;
	} fs_env;
	char *fs_status;
};
typedef struct ndmp4_fs_info ndmp4_fs_info;

struct ndmp4_config_get_fs_info_reply {
	ndmp4_error error;
	struct {
		u_int fs_info_len;
		ndmp4_fs_info *fs_info_val;
	} fs_info;
};
typedef struct ndmp4_config_get_fs_info_reply ndmp4_config_get_fs_info_reply;
#define NDMP4_TAPE_ATTR_REWIND 0x00000001
#define NDMP4_TAPE_ATTR_UNLOAD 0x00000002
#define NDMP4_TAPE_ATTR_RAW 0x00000004

struct ndmp4_device_capability {
	char *device;
	u_long attr;
	struct {
		u_int capability_len;
		ndmp4_pval *capability_val;
	} capability;
};
typedef struct ndmp4_device_capability ndmp4_device_capability;

struct ndmp4_device_info {
	char *model;
	struct {
		u_int caplist_len;
		ndmp4_device_capability *caplist_val;
	} caplist;
};
typedef struct ndmp4_device_info ndmp4_device_info;

struct ndmp4_config_get_tape_info_reply {
	ndmp4_error error;
	struct {
		u_int tape_info_len;
		ndmp4_device_info *tape_info_val;
	} tape_info;
};
typedef struct ndmp4_config_get_tape_info_reply ndmp4_config_get_tape_info_reply;

struct ndmp4_config_get_scsi_info_reply {
	ndmp4_error error;
	struct {
		u_int scsi_info_len;
		ndmp4_device_info *scsi_info_val;
	} scsi_info;
};
typedef struct ndmp4_config_get_scsi_info_reply ndmp4_config_get_scsi_info_reply;

struct ndmp4_class_list {
	u_short class_id;
	struct {
		u_int class_version_len;
		u_short *class_version_val;
	} class_version;
};
typedef struct ndmp4_class_list ndmp4_class_list;

struct ndmp4_class_version {
	u_short class_id;
	u_short class_version;
};
typedef struct ndmp4_class_version ndmp4_class_version;

struct ndmp4_config_get_ext_list_reply {
	ndmp4_error error;
	struct {
		u_int class_list_len;
		ndmp4_class_list *class_list_val;
	} class_list;
};
typedef struct ndmp4_config_get_ext_list_reply ndmp4_config_get_ext_list_reply;

struct ndmp4_config_set_ext_list_request {
	ndmp4_error error;
	struct {
		u_int ndmp4_accepted_ext_len;
		ndmp4_class_list *ndmp4_accepted_ext_val;
	} ndmp4_accepted_ext;
};
typedef struct ndmp4_config_set_ext_list_request ndmp4_config_set_ext_list_request;

struct ndmp4_config_set_ext_list_reply {
	ndmp4_error error;
};
typedef struct ndmp4_config_set_ext_list_reply ndmp4_config_set_ext_list_reply;

struct ndmp4_scsi_open_request {
	char *device;
};
typedef struct ndmp4_scsi_open_request ndmp4_scsi_open_request;

struct ndmp4_scsi_open_reply {
	ndmp4_error error;
};
typedef struct ndmp4_scsi_open_reply ndmp4_scsi_open_reply;

struct ndmp4_scsi_close_reply {
	ndmp4_error error;
};
typedef struct ndmp4_scsi_close_reply ndmp4_scsi_close_reply;

struct ndmp4_scsi_get_state_reply {
	ndmp4_error error;
	short target_controller;
	short target_id;
	short target_lun;
};
typedef struct ndmp4_scsi_get_state_reply ndmp4_scsi_get_state_reply;

struct ndmp4_scsi_reset_device_reply {
	ndmp4_error error;
};
typedef struct ndmp4_scsi_reset_device_reply ndmp4_scsi_reset_device_reply;
#define NDMP4_SCSI_DATA_IN 0x00000001
#define NDMP4_SCSI_DATA_OUT 0x00000002

struct ndmp4_execute_cdb_request {
	u_long flags;
	u_long timeout;
	u_long datain_len;
	struct {
		u_int cdb_len;
		char *cdb_val;
	} cdb;
	struct {
		u_int dataout_len;
		char *dataout_val;
	} dataout;
};
typedef struct ndmp4_execute_cdb_request ndmp4_execute_cdb_request;

struct ndmp4_execute_cdb_reply {
	ndmp4_error error;
	u_char status;
	u_long dataout_len;
	struct {
		u_int datain_len;
		char *datain_val;
	} datain;
	struct {
		u_int ext_sense_len;
		char *ext_sense_val;
	} ext_sense;
};
typedef struct ndmp4_execute_cdb_reply ndmp4_execute_cdb_reply;

typedef ndmp4_execute_cdb_request ndmp4_scsi_execute_cdb_request;

typedef ndmp4_execute_cdb_reply ndmp4_scsi_execute_cdb_reply;

enum ndmp4_tape_open_mode {
	NDMP4_TAPE_READ_MODE = 0,
	NDMP4_TAPE_RDWR_MODE = 1,
	NDMP4_TAPE_RAW_MODE = 2,
};
typedef enum ndmp4_tape_open_mode ndmp4_tape_open_mode;

struct ndmp4_tape_open_request {
	char *device;
	ndmp4_tape_open_mode mode;
};
typedef struct ndmp4_tape_open_request ndmp4_tape_open_request;

struct ndmp4_tape_open_reply {
	ndmp4_error error;
};
typedef struct ndmp4_tape_open_reply ndmp4_tape_open_reply;

struct ndmp4_tape_close_reply {
	ndmp4_error error;
};
typedef struct ndmp4_tape_close_reply ndmp4_tape_close_reply;
#define NDMP4_TAPE_STATE_NOREWIND 0x0008
#define NDMP4_TAPE_STATE_WR_PROT 0x0010
#define NDMP4_TAPE_STATE_ERROR 0x0020
#define NDMP4_TAPE_STATE_UNLOAD 0x0040
#define NDMP4_TAPE_STATE_FILE_NUM_UNS 0x00000001
#define NDMP4_TAPE_STATE_SOFT_ERRORS_UNS 0x00000002
#define NDMP4_TAPE_STATE_BLOCK_SIZE_UNS 0x00000004
#define NDMP4_TAPE_STATE_BLOCKNO_UNS 0x00000008
#define NDMP4_TAPE_STATE_TOTAL_SPACE_UNS 0x00000010
#define NDMP4_TAPE_STATE_SPACE_REMAIN_UNS 0x00000020

struct ndmp4_tape_get_state_reply {
	u_long unsupported;
	ndmp4_error error;
	u_long flags;
	u_long file_num;
	u_long soft_errors;
	u_long block_size;
	u_long blockno;
	ndmp4_u_quad total_space;
	ndmp4_u_quad space_remain;
};
typedef struct ndmp4_tape_get_state_reply ndmp4_tape_get_state_reply;

enum ndmp4_tape_mtio_op {
	NDMP4_MTIO_FSF = 0,
	NDMP4_MTIO_BSF = 1,
	NDMP4_MTIO_FSR = 2,
	NDMP4_MTIO_BSR = 3,
	NDMP4_MTIO_REW = 4,
	NDMP4_MTIO_EOF = 5,
	NDMP4_MTIO_OFF = 6,
	NDMP4_MTIO_TUR = 7,
};
typedef enum ndmp4_tape_mtio_op ndmp4_tape_mtio_op;

struct ndmp4_tape_mtio_request {
	ndmp4_tape_mtio_op tape_op;
	u_long count;
};
typedef struct ndmp4_tape_mtio_request ndmp4_tape_mtio_request;

struct ndmp4_tape_mtio_reply {
	ndmp4_error error;
	u_long resid_count;
};
typedef struct ndmp4_tape_mtio_reply ndmp4_tape_mtio_reply;

struct ndmp4_tape_write_request {
	struct {
		u_int data_out_len;
		char *data_out_val;
	} data_out;
};
typedef struct ndmp4_tape_write_request ndmp4_tape_write_request;

struct ndmp4_tape_write_reply {
	ndmp4_error error;
	u_long count;
};
typedef struct ndmp4_tape_write_reply ndmp4_tape_write_reply;

struct ndmp4_tape_read_request {
	u_long count;
};
typedef struct ndmp4_tape_read_request ndmp4_tape_read_request;

struct ndmp4_tape_read_reply {
	ndmp4_error error;
	struct {
		u_int data_in_len;
		char *data_in_val;
	} data_in;
};
typedef struct ndmp4_tape_read_reply ndmp4_tape_read_reply;

typedef ndmp4_scsi_execute_cdb_request ndmp4_tape_execute_cdb_request;

typedef ndmp4_scsi_execute_cdb_reply ndmp4_tape_execute_cdb_reply;

enum ndmp4_data_operation {
	NDMP4_DATA_OP_NOACTION = 0,
	NDMP4_DATA_OP_BACKUP = 1,
	NDMP4_DATA_OP_RECOVER = 2,
	NDMP4_DATA_OP_RECOVER_FILEHIST = 3,
};
typedef enum ndmp4_data_operation ndmp4_data_operation;

enum ndmp4_data_state {
	NDMP4_DATA_STATE_IDLE = 0,
	NDMP4_DATA_STATE_ACTIVE = 1,
	NDMP4_DATA_STATE_HALTED = 2,
	NDMP4_DATA_STATE_LISTEN = 3,
	NDMP4_DATA_STATE_CONNECTED = 4,
};
typedef enum ndmp4_data_state ndmp4_data_state;

enum ndmp4_data_halt_reason {
	NDMP4_DATA_HALT_NA = 0,
	NDMP4_DATA_HALT_SUCCESSFUL = 1,
	NDMP4_DATA_HALT_ABORTED = 2,
	NDMP4_DATA_HALT_INTERNAL_ERROR = 3,
	NDMP4_DATA_HALT_CONNECT_ERROR = 4,
};
typedef enum ndmp4_data_halt_reason ndmp4_data_halt_reason;

struct ndmp4_tcp_addr {
	u_long ip_addr;
	u_short port;
	struct {
		u_int addr_env_len;
		ndmp4_pval *addr_env_val;
	} addr_env;
};
typedef struct ndmp4_tcp_addr ndmp4_tcp_addr;

struct ndmp4_ipc_addr {
	struct {
		u_int comm_data_len;
		char *comm_data_val;
	} comm_data;
};
typedef struct ndmp4_ipc_addr ndmp4_ipc_addr;

struct ndmp4_addr {
	ndmp4_addr_type addr_type;
	union {
		struct {
			u_int tcp_addr_len;
			ndmp4_tcp_addr *tcp_addr_val;
		} tcp_addr;
		ndmp4_ipc_addr ipc_addr;
	} ndmp4_addr_u;
};
typedef struct ndmp4_addr ndmp4_addr;
#define NDMP4_DATA_STATE_EST_BYTES_REMAIN_UNS 0x00000001
#define NDMP4_DATA_STATE_EST_TIME_REMAIN_UNS 0x00000002

struct ndmp4_data_get_state_reply {
	u_long unsupported;
	ndmp4_error error;
	ndmp4_data_operation operation;
	ndmp4_data_state state;
	ndmp4_data_halt_reason halt_reason;
	ndmp4_u_quad bytes_processed;
	ndmp4_u_quad est_bytes_remain;
	u_long est_time_remain;
	ndmp4_addr data_connection_addr;
	ndmp4_u_quad read_offset;
	ndmp4_u_quad read_length;
};
typedef struct ndmp4_data_get_state_reply ndmp4_data_get_state_reply;

struct ndmp4_data_listen_request {
	ndmp4_addr_type addr_type;
};
typedef struct ndmp4_data_listen_request ndmp4_data_listen_request;

struct ndmp4_data_listen_reply {
	ndmp4_error error;
	ndmp4_addr connect_addr;
};
typedef struct ndmp4_data_listen_reply ndmp4_data_listen_reply;

struct ndmp4_data_connect_request {
	ndmp4_addr addr;
};
typedef struct ndmp4_data_connect_request ndmp4_data_connect_request;

struct ndmp4_data_connect_reply {
	ndmp4_error error;
};
typedef struct ndmp4_data_connect_reply ndmp4_data_connect_reply;

struct ndmp4_data_start_backup_request {
	char *butype_name;
	struct {
		u_int env_len;
		ndmp4_pval *env_val;
	} env;
};
typedef struct ndmp4_data_start_backup_request ndmp4_data_start_backup_request;

struct ndmp4_data_start_backup_reply {
	ndmp4_error error;
};
typedef struct ndmp4_data_start_backup_reply ndmp4_data_start_backup_reply;

struct ndmp4_name {
	char *original_path;
	char *destination_path;
	char *name;
	char *other_name;
	ndmp4_u_quad node;
	ndmp4_u_quad fh_info;
};
typedef struct ndmp4_name ndmp4_name;

struct ndmp4_data_start_recover_request {
	struct {
		u_int env_len;
		ndmp4_pval *env_val;
	} env;
	struct {
		u_int nlist_len;
		ndmp4_name *nlist_val;
	} nlist;
	char *butype_name;
};
typedef struct ndmp4_data_start_recover_request ndmp4_data_start_recover_request;

struct ndmp4_data_start_recover_reply {
	ndmp4_error error;
};
typedef struct ndmp4_data_start_recover_reply ndmp4_data_start_recover_reply;

struct ndmp4_data_start_recover_filehist_request {
	struct {
		u_int env_len;
		ndmp4_pval *env_val;
	} env;
	struct {
		u_int nlist_len;
		ndmp4_name *nlist_val;
	} nlist;
	char *butype_name;
};
typedef struct ndmp4_data_start_recover_filehist_request ndmp4_data_start_recover_filehist_request;

struct ndmp4_data_start_recover_filehist_reply {
	ndmp4_error error;
};
typedef struct ndmp4_data_start_recover_filehist_reply ndmp4_data_start_recover_filehist_reply;

struct ndmp4_data_abort_reply {
	ndmp4_error error;
};
typedef struct ndmp4_data_abort_reply ndmp4_data_abort_reply;

struct ndmp4_data_stop_reply {
	ndmp4_error error;
};
typedef struct ndmp4_data_stop_reply ndmp4_data_stop_reply;

struct ndmp4_data_get_env_reply {
	ndmp4_error error;
	struct {
		u_int env_len;
		ndmp4_pval *env_val;
	} env;
};
typedef struct ndmp4_data_get_env_reply ndmp4_data_get_env_reply;

enum ndmp4_mover_mode {
	NDMP4_MOVER_MODE_READ = 0,
	NDMP4_MOVER_MODE_WRITE = 1,
	NDMP4_MOVER_MODE_NOACTION = 2,
};
typedef enum ndmp4_mover_mode ndmp4_mover_mode;

enum ndmp4_mover_state {
	NDMP4_MOVER_STATE_IDLE = 0,
	NDMP4_MOVER_STATE_LISTEN = 1,
	NDMP4_MOVER_STATE_ACTIVE = 2,
	NDMP4_MOVER_STATE_PAUSED = 3,
	NDMP4_MOVER_STATE_HALTED = 4,
};
typedef enum ndmp4_mover_state ndmp4_mover_state;

enum ndmp4_mover_pause_reason {
	NDMP4_MOVER_PAUSE_NA = 0,
	NDMP4_MOVER_PAUSE_EOM = 1,
	NDMP4_MOVER_PAUSE_EOF = 2,
	NDMP4_MOVER_PAUSE_SEEK = 3,
	NDMP4_MOVER_PAUSE_EOW = 5,
};
typedef enum ndmp4_mover_pause_reason ndmp4_mover_pause_reason;

enum ndmp4_mover_halt_reason {
	NDMP4_MOVER_HALT_NA = 0,
	NDMP4_MOVER_HALT_CONNECT_CLOSED = 1,
	NDMP4_MOVER_HALT_ABORTED = 2,
	NDMP4_MOVER_HALT_INTERNAL_ERROR = 3,
	NDMP4_MOVER_HALT_CONNECT_ERROR = 4,
	NDMP4_MOVER_HALT_MEDIA_ERROR = 5,
};
typedef enum ndmp4_mover_halt_reason ndmp4_mover_halt_reason;

struct ndmp4_mover_set_record_size_request {
	u_long len;
};
typedef struct ndmp4_mover_set_record_size_request ndmp4_mover_set_record_size_request;

struct ndmp4_mover_set_record_size_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_set_record_size_reply ndmp4_mover_set_record_size_reply;

struct ndmp4_mover_set_window_request {
	ndmp4_u_quad offset;
	ndmp4_u_quad length;
};
typedef struct ndmp4_mover_set_window_request ndmp4_mover_set_window_request;

struct ndmp4_mover_set_window_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_set_window_reply ndmp4_mover_set_window_reply;

struct ndmp4_mover_connect_request {
	ndmp4_mover_mode mode;
	ndmp4_addr addr;
};
typedef struct ndmp4_mover_connect_request ndmp4_mover_connect_request;

struct ndmp4_mover_connect_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_connect_reply ndmp4_mover_connect_reply;

struct ndmp4_mover_listen_request {
	ndmp4_mover_mode mode;
	ndmp4_addr_type addr_type;
};
typedef struct ndmp4_mover_listen_request ndmp4_mover_listen_request;

struct ndmp4_mover_listen_reply {
	ndmp4_error error;
	ndmp4_addr connect_addr;
};
typedef struct ndmp4_mover_listen_reply ndmp4_mover_listen_reply;

struct ndmp4_mover_read_request {
	ndmp4_u_quad offset;
	ndmp4_u_quad length;
};
typedef struct ndmp4_mover_read_request ndmp4_mover_read_request;

struct ndmp4_mover_read_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_read_reply ndmp4_mover_read_reply;

struct ndmp4_mover_get_state_reply {
	ndmp4_error error;
	ndmp4_mover_mode mode;
	ndmp4_mover_state state;
	ndmp4_mover_pause_reason pause_reason;
	ndmp4_mover_halt_reason halt_reason;
	u_long record_size;
	u_long record_num;
	ndmp4_u_quad bytes_moved;
	ndmp4_u_quad seek_position;
	ndmp4_u_quad bytes_left_to_read;
	ndmp4_u_quad window_offset;
	ndmp4_u_quad window_length;
	ndmp4_addr data_connection_addr;
};
typedef struct ndmp4_mover_get_state_reply ndmp4_mover_get_state_reply;

struct ndmp4_mover_continue_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_continue_reply ndmp4_mover_continue_reply;

struct ndmp4_mover_close_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_close_reply ndmp4_mover_close_reply;

struct ndmp4_mover_abort_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_abort_reply ndmp4_mover_abort_reply;

struct ndmp4_mover_stop_reply {
	ndmp4_error error;
};
typedef struct ndmp4_mover_stop_reply ndmp4_mover_stop_reply;

struct ndmp4_notify_data_halted_post {
	ndmp4_data_halt_reason reason;
};
typedef struct ndmp4_notify_data_halted_post ndmp4_notify_data_halted_post;

enum ndmp4_connection_status_reason {
	NDMP4_CONNECTED = 0,
	NDMP4_SHUTDOWN = 1,
	NDMP4_REFUSED = 2,
};
typedef enum ndmp4_connection_status_reason ndmp4_connection_status_reason;

struct ndmp4_notify_connection_status_post {
	ndmp4_connection_status_reason reason;
	u_short protocol_version;
	char *text_reason;
};
typedef struct ndmp4_notify_connection_status_post ndmp4_notify_connection_status_post;

struct ndmp4_notify_mover_halted_post {
	ndmp4_mover_halt_reason reason;
};
typedef struct ndmp4_notify_mover_halted_post ndmp4_notify_mover_halted_post;

struct ndmp4_notify_mover_paused_post {
	ndmp4_mover_pause_reason reason;
	ndmp4_u_quad seek_position;
};
typedef struct ndmp4_notify_mover_paused_post ndmp4_notify_mover_paused_post;

struct ndmp4_notify_data_read_post {
	ndmp4_u_quad offset;
	ndmp4_u_quad length;
};
typedef struct ndmp4_notify_data_read_post ndmp4_notify_data_read_post;

enum ndmp4_has_associated_message {
	NDMP4_NO_ASSOCIATED_MESSAGE = 0,
	NDMP4_HAS_ASSOCIATED_MESSAGE = 1,
};
typedef enum ndmp4_has_associated_message ndmp4_has_associated_message;

enum ndmp4_log_type {
	NDMP4_LOG_NORMAL = 0,
	NDMP4_LOG_DEBUG = 1,
	NDMP4_LOG_ERROR = 2,
	NDMP4_LOG_WARNING = 3,
};
typedef enum ndmp4_log_type ndmp4_log_type;

struct ndmp4_log_message_post {
	ndmp4_log_type log_type;
	u_long message_id;
	char *entry;
	ndmp4_has_associated_message associated_message_valid;
	u_long associated_message_sequence;
};
typedef struct ndmp4_log_message_post ndmp4_log_message_post;

enum ndmp4_recovery_status {
	NDMP4_RECOVERY_SUCCESSFUL = 0,
	NDMP4_RECOVERY_FAILED_PERMISSION = 1,
	NDMP4_RECOVERY_FAILED_NOT_FOUND = 2,
	NDMP4_RECOVERY_FAILED_NO_DIRECTORY = 3,
	NDMP4_RECOVERY_FAILED_OUT_OF_MEMORY = 4,
	NDMP4_RECOVERY_FAILED_IO_ERROR = 5,
	NDMP4_RECOVERY_FAILED_UNDEFINED_ERROR = 6,
};
typedef enum ndmp4_recovery_status ndmp4_recovery_status;

struct ndmp4_log_file_post {
	char *name;
	ndmp4_recovery_status recovery_status;
};
typedef struct ndmp4_log_file_post ndmp4_log_file_post;

enum ndmp4_fs_type {
	NDMP4_FS_UNIX = 0,
	NDMP4_FS_NT = 1,
	NDMP4_FS_OTHER = 2,
};
typedef enum ndmp4_fs_type ndmp4_fs_type;

typedef char *ndmp4_path;

struct ndmp4_nt_path {
	ndmp4_path nt_path;
	ndmp4_path dos_path;
};
typedef struct ndmp4_nt_path ndmp4_nt_path;

struct ndmp4_file_name {
	ndmp4_fs_type fs_type;
	union {
		ndmp4_path unix_name;
		ndmp4_nt_path nt_name;
		ndmp4_path other_name;
	} ndmp4_file_name_u;
};
typedef struct ndmp4_file_name ndmp4_file_name;

enum ndmp4_file_type {
	NDMP4_FILE_DIR = 0,
	NDMP4_FILE_FIFO = 1,
	NDMP4_FILE_CSPEC = 2,
	NDMP4_FILE_BSPEC = 3,
	NDMP4_FILE_REG = 4,
	NDMP4_FILE_SLINK = 5,
	NDMP4_FILE_SOCK = 6,
	NDMP4_FILE_REGISTRY = 7,
	NDMP4_FILE_OTHER = 8,
};
typedef enum ndmp4_file_type ndmp4_file_type;
#define NDMP4_FILE_STAT_ATIME_UNS 0x00000001
#define NDMP4_FILE_STAT_CTIME_UNS 0x00000002
#define NDMP4_FILE_STAT_GROUP_UNS 0x00000004

struct ndmp4_file_stat {
	u_long unsupported;
	ndmp4_fs_type fs_type;
	ndmp4_file_type ftype;
	u_long mtime;
	u_long atime;
	u_long ctime;
	u_long owner;
	u_long group;
	u_long fattr;
	ndmp4_u_quad size;
	u_long links;
};
typedef struct ndmp4_file_stat ndmp4_file_stat;

struct ndmp4_file {
	struct {
		u_int names_len;
		ndmp4_file_name *names_val;
	} names;
	struct {
		u_int stats_len;
		ndmp4_file_stat *stats_val;
	} stats;
	ndmp4_u_quad node;
	ndmp4_u_quad fh_info;
};
typedef struct ndmp4_file ndmp4_file;

struct ndmp4_fh_add_file_post {
	struct {
		u_int files_len;
		ndmp4_file *files_val;
	} files;
};
typedef struct ndmp4_fh_add_file_post ndmp4_fh_add_file_post;

struct ndmp4_dir {
	struct {
		u_int names_len;
		ndmp4_file_name *names_val;
	} names;
	ndmp4_u_quad node;
	ndmp4_u_quad parent;
};
typedef struct ndmp4_dir ndmp4_dir;

struct ndmp4_fh_add_dir_post {
	struct {
		u_int dirs_len;
		ndmp4_dir *dirs_val;
	} dirs;
};
typedef struct ndmp4_fh_add_dir_post ndmp4_fh_add_dir_post;

struct ndmp4_node {
	struct {
		u_int stats_len;
		ndmp4_file_stat *stats_val;
	} stats;
	ndmp4_u_quad node;
	ndmp4_u_quad fh_info;
};
typedef struct ndmp4_node ndmp4_node;

struct ndmp4_fh_add_node_post {
	struct {
		u_int nodes_len;
		ndmp4_node *nodes_val;
	} nodes;
};
typedef struct ndmp4_fh_add_node_post ndmp4_fh_add_node_post;
#endif /* !NDMOS_OPTION_NO_NDMP4 */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr__ndmp4_u_quad (XDR *, _ndmp4_u_quad*);
extern  bool_t xdr_ndmp4_header_message_type (XDR *, ndmp4_header_message_type*);
extern  bool_t xdr_ndmp4_error (XDR *, ndmp4_error*);
extern  bool_t xdr_ndmp4_message (XDR *, ndmp4_message*);
extern  bool_t xdr_ndmp4_header (XDR *, ndmp4_header*);
extern  bool_t xdr_ndmp4_pval (XDR *, ndmp4_pval*);
extern  bool_t xdr_ndmp4_connect_open_request (XDR *, ndmp4_connect_open_request*);
extern  bool_t xdr_ndmp4_connect_open_reply (XDR *, ndmp4_connect_open_reply*);
extern  bool_t xdr_ndmp4_auth_type (XDR *, ndmp4_auth_type*);
extern  bool_t xdr_ndmp4_auth_text (XDR *, ndmp4_auth_text*);
extern  bool_t xdr_ndmp4_auth_md5 (XDR *, ndmp4_auth_md5*);
extern  bool_t xdr_ndmp4_auth_data (XDR *, ndmp4_auth_data*);
extern  bool_t xdr_ndmp4_auth_attr (XDR *, ndmp4_auth_attr*);
extern  bool_t xdr_ndmp4_connect_client_auth_request (XDR *, ndmp4_connect_client_auth_request*);
extern  bool_t xdr_ndmp4_connect_client_auth_reply (XDR *, ndmp4_connect_client_auth_reply*);
extern  bool_t xdr_ndmp4_connect_server_auth_request (XDR *, ndmp4_connect_server_auth_request*);
extern  bool_t xdr_ndmp4_connect_server_auth_reply (XDR *, ndmp4_connect_server_auth_reply*);
extern  bool_t xdr_ndmp4_config_get_host_info_reply (XDR *, ndmp4_config_get_host_info_reply*);
extern  bool_t xdr_ndmp4_config_get_server_info_reply (XDR *, ndmp4_config_get_server_info_reply*);
extern  bool_t xdr_ndmp4_addr_type (XDR *, ndmp4_addr_type*);
extern  bool_t xdr_ndmp4_config_get_connection_type_reply (XDR *, ndmp4_config_get_connection_type_reply*);
extern  bool_t xdr_ndmp4_config_get_auth_attr_request (XDR *, ndmp4_config_get_auth_attr_request*);
extern  bool_t xdr_ndmp4_config_get_auth_attr_reply (XDR *, ndmp4_config_get_auth_attr_reply*);
extern  bool_t xdr_ndmp4_butype_info (XDR *, ndmp4_butype_info*);
extern  bool_t xdr_ndmp4_config_get_butype_info_reply (XDR *, ndmp4_config_get_butype_info_reply*);
extern  bool_t xdr_ndmp4_fs_info (XDR *, ndmp4_fs_info*);
extern  bool_t xdr_ndmp4_config_get_fs_info_reply (XDR *, ndmp4_config_get_fs_info_reply*);
extern  bool_t xdr_ndmp4_device_capability (XDR *, ndmp4_device_capability*);
extern  bool_t xdr_ndmp4_device_info (XDR *, ndmp4_device_info*);
extern  bool_t xdr_ndmp4_config_get_tape_info_reply (XDR *, ndmp4_config_get_tape_info_reply*);
extern  bool_t xdr_ndmp4_config_get_scsi_info_reply (XDR *, ndmp4_config_get_scsi_info_reply*);
extern  bool_t xdr_ndmp4_class_list (XDR *, ndmp4_class_list*);
extern  bool_t xdr_ndmp4_class_version (XDR *, ndmp4_class_version*);
extern  bool_t xdr_ndmp4_config_get_ext_list_reply (XDR *, ndmp4_config_get_ext_list_reply*);
extern  bool_t xdr_ndmp4_config_set_ext_list_request (XDR *, ndmp4_config_set_ext_list_request*);
extern  bool_t xdr_ndmp4_config_set_ext_list_reply (XDR *, ndmp4_config_set_ext_list_reply*);
extern  bool_t xdr_ndmp4_scsi_open_request (XDR *, ndmp4_scsi_open_request*);
extern  bool_t xdr_ndmp4_scsi_open_reply (XDR *, ndmp4_scsi_open_reply*);
extern  bool_t xdr_ndmp4_scsi_close_reply (XDR *, ndmp4_scsi_close_reply*);
extern  bool_t xdr_ndmp4_scsi_get_state_reply (XDR *, ndmp4_scsi_get_state_reply*);
extern  bool_t xdr_ndmp4_scsi_reset_device_reply (XDR *, ndmp4_scsi_reset_device_reply*);
extern  bool_t xdr_ndmp4_execute_cdb_request (XDR *, ndmp4_execute_cdb_request*);
extern  bool_t xdr_ndmp4_execute_cdb_reply (XDR *, ndmp4_execute_cdb_reply*);
extern  bool_t xdr_ndmp4_scsi_execute_cdb_request (XDR *, ndmp4_scsi_execute_cdb_request*);
extern  bool_t xdr_ndmp4_scsi_execute_cdb_reply (XDR *, ndmp4_scsi_execute_cdb_reply*);
extern  bool_t xdr_ndmp4_tape_open_mode (XDR *, ndmp4_tape_open_mode*);
extern  bool_t xdr_ndmp4_tape_open_request (XDR *, ndmp4_tape_open_request*);
extern  bool_t xdr_ndmp4_tape_open_reply (XDR *, ndmp4_tape_open_reply*);
extern  bool_t xdr_ndmp4_tape_close_reply (XDR *, ndmp4_tape_close_reply*);
extern  bool_t xdr_ndmp4_tape_get_state_reply (XDR *, ndmp4_tape_get_state_reply*);
extern  bool_t xdr_ndmp4_tape_mtio_op (XDR *, ndmp4_tape_mtio_op*);
extern  bool_t xdr_ndmp4_tape_mtio_request (XDR *, ndmp4_tape_mtio_request*);
extern  bool_t xdr_ndmp4_tape_mtio_reply (XDR *, ndmp4_tape_mtio_reply*);
extern  bool_t xdr_ndmp4_tape_write_request (XDR *, ndmp4_tape_write_request*);
extern  bool_t xdr_ndmp4_tape_write_reply (XDR *, ndmp4_tape_write_reply*);
extern  bool_t xdr_ndmp4_tape_read_request (XDR *, ndmp4_tape_read_request*);
extern  bool_t xdr_ndmp4_tape_read_reply (XDR *, ndmp4_tape_read_reply*);
extern  bool_t xdr_ndmp4_tape_execute_cdb_request (XDR *, ndmp4_tape_execute_cdb_request*);
extern  bool_t xdr_ndmp4_tape_execute_cdb_reply (XDR *, ndmp4_tape_execute_cdb_reply*);
extern  bool_t xdr_ndmp4_data_operation (XDR *, ndmp4_data_operation*);
extern  bool_t xdr_ndmp4_data_state (XDR *, ndmp4_data_state*);
extern  bool_t xdr_ndmp4_data_halt_reason (XDR *, ndmp4_data_halt_reason*);
extern  bool_t xdr_ndmp4_tcp_addr (XDR *, ndmp4_tcp_addr*);
extern  bool_t xdr_ndmp4_ipc_addr (XDR *, ndmp4_ipc_addr*);
extern  bool_t xdr_ndmp4_addr (XDR *, ndmp4_addr*);
extern  bool_t xdr_ndmp4_data_get_state_reply (XDR *, ndmp4_data_get_state_reply*);
extern  bool_t xdr_ndmp4_data_listen_request (XDR *, ndmp4_data_listen_request*);
extern  bool_t xdr_ndmp4_data_listen_reply (XDR *, ndmp4_data_listen_reply*);
extern  bool_t xdr_ndmp4_data_connect_request (XDR *, ndmp4_data_connect_request*);
extern  bool_t xdr_ndmp4_data_connect_reply (XDR *, ndmp4_data_connect_reply*);
extern  bool_t xdr_ndmp4_data_start_backup_request (XDR *, ndmp4_data_start_backup_request*);
extern  bool_t xdr_ndmp4_data_start_backup_reply (XDR *, ndmp4_data_start_backup_reply*);
extern  bool_t xdr_ndmp4_name (XDR *, ndmp4_name*);
extern  bool_t xdr_ndmp4_data_start_recover_request (XDR *, ndmp4_data_start_recover_request*);
extern  bool_t xdr_ndmp4_data_start_recover_reply (XDR *, ndmp4_data_start_recover_reply*);
extern  bool_t xdr_ndmp4_data_start_recover_filehist_request (XDR *, ndmp4_data_start_recover_filehist_request*);
extern  bool_t xdr_ndmp4_data_start_recover_filehist_reply (XDR *, ndmp4_data_start_recover_filehist_reply*);
extern  bool_t xdr_ndmp4_data_abort_reply (XDR *, ndmp4_data_abort_reply*);
extern  bool_t xdr_ndmp4_data_stop_reply (XDR *, ndmp4_data_stop_reply*);
extern  bool_t xdr_ndmp4_data_get_env_reply (XDR *, ndmp4_data_get_env_reply*);
extern  bool_t xdr_ndmp4_mover_mode (XDR *, ndmp4_mover_mode*);
extern  bool_t xdr_ndmp4_mover_state (XDR *, ndmp4_mover_state*);
extern  bool_t xdr_ndmp4_mover_pause_reason (XDR *, ndmp4_mover_pause_reason*);
extern  bool_t xdr_ndmp4_mover_halt_reason (XDR *, ndmp4_mover_halt_reason*);
extern  bool_t xdr_ndmp4_mover_set_record_size_request (XDR *, ndmp4_mover_set_record_size_request*);
extern  bool_t xdr_ndmp4_mover_set_record_size_reply (XDR *, ndmp4_mover_set_record_size_reply*);
extern  bool_t xdr_ndmp4_mover_set_window_request (XDR *, ndmp4_mover_set_window_request*);
extern  bool_t xdr_ndmp4_mover_set_window_reply (XDR *, ndmp4_mover_set_window_reply*);
extern  bool_t xdr_ndmp4_mover_connect_request (XDR *, ndmp4_mover_connect_request*);
extern  bool_t xdr_ndmp4_mover_connect_reply (XDR *, ndmp4_mover_connect_reply*);
extern  bool_t xdr_ndmp4_mover_listen_request (XDR *, ndmp4_mover_listen_request*);
extern  bool_t xdr_ndmp4_mover_listen_reply (XDR *, ndmp4_mover_listen_reply*);
extern  bool_t xdr_ndmp4_mover_read_request (XDR *, ndmp4_mover_read_request*);
extern  bool_t xdr_ndmp4_mover_read_reply (XDR *, ndmp4_mover_read_reply*);
extern  bool_t xdr_ndmp4_mover_get_state_reply (XDR *, ndmp4_mover_get_state_reply*);
extern  bool_t xdr_ndmp4_mover_continue_reply (XDR *, ndmp4_mover_continue_reply*);
extern  bool_t xdr_ndmp4_mover_close_reply (XDR *, ndmp4_mover_close_reply*);
extern  bool_t xdr_ndmp4_mover_abort_reply (XDR *, ndmp4_mover_abort_reply*);
extern  bool_t xdr_ndmp4_mover_stop_reply (XDR *, ndmp4_mover_stop_reply*);
extern  bool_t xdr_ndmp4_notify_data_halted_post (XDR *, ndmp4_notify_data_halted_post*);
extern  bool_t xdr_ndmp4_connection_status_reason (XDR *, ndmp4_connection_status_reason*);
extern  bool_t xdr_ndmp4_notify_connection_status_post (XDR *, ndmp4_notify_connection_status_post*);
extern  bool_t xdr_ndmp4_notify_mover_halted_post (XDR *, ndmp4_notify_mover_halted_post*);
extern  bool_t xdr_ndmp4_notify_mover_paused_post (XDR *, ndmp4_notify_mover_paused_post*);
extern  bool_t xdr_ndmp4_notify_data_read_post (XDR *, ndmp4_notify_data_read_post*);
extern  bool_t xdr_ndmp4_has_associated_message (XDR *, ndmp4_has_associated_message*);
extern  bool_t xdr_ndmp4_log_type (XDR *, ndmp4_log_type*);
extern  bool_t xdr_ndmp4_log_message_post (XDR *, ndmp4_log_message_post*);
extern  bool_t xdr_ndmp4_recovery_status (XDR *, ndmp4_recovery_status*);
extern  bool_t xdr_ndmp4_log_file_post (XDR *, ndmp4_log_file_post*);
extern  bool_t xdr_ndmp4_fs_type (XDR *, ndmp4_fs_type*);
extern  bool_t xdr_ndmp4_path (XDR *, ndmp4_path*);
extern  bool_t xdr_ndmp4_nt_path (XDR *, ndmp4_nt_path*);
extern  bool_t xdr_ndmp4_file_name (XDR *, ndmp4_file_name*);
extern  bool_t xdr_ndmp4_file_type (XDR *, ndmp4_file_type*);
extern  bool_t xdr_ndmp4_file_stat (XDR *, ndmp4_file_stat*);
extern  bool_t xdr_ndmp4_file (XDR *, ndmp4_file*);
extern  bool_t xdr_ndmp4_fh_add_file_post (XDR *, ndmp4_fh_add_file_post*);
extern  bool_t xdr_ndmp4_dir (XDR *, ndmp4_dir*);
extern  bool_t xdr_ndmp4_fh_add_dir_post (XDR *, ndmp4_fh_add_dir_post*);
extern  bool_t xdr_ndmp4_node (XDR *, ndmp4_node*);
extern  bool_t xdr_ndmp4_fh_add_node_post (XDR *, ndmp4_fh_add_node_post*);

#else /* K&R C */
extern bool_t xdr__ndmp4_u_quad ();
extern bool_t xdr_ndmp4_header_message_type ();
extern bool_t xdr_ndmp4_error ();
extern bool_t xdr_ndmp4_message ();
extern bool_t xdr_ndmp4_header ();
extern bool_t xdr_ndmp4_pval ();
extern bool_t xdr_ndmp4_connect_open_request ();
extern bool_t xdr_ndmp4_connect_open_reply ();
extern bool_t xdr_ndmp4_auth_type ();
extern bool_t xdr_ndmp4_auth_text ();
extern bool_t xdr_ndmp4_auth_md5 ();
extern bool_t xdr_ndmp4_auth_data ();
extern bool_t xdr_ndmp4_auth_attr ();
extern bool_t xdr_ndmp4_connect_client_auth_request ();
extern bool_t xdr_ndmp4_connect_client_auth_reply ();
extern bool_t xdr_ndmp4_connect_server_auth_request ();
extern bool_t xdr_ndmp4_connect_server_auth_reply ();
extern bool_t xdr_ndmp4_config_get_host_info_reply ();
extern bool_t xdr_ndmp4_config_get_server_info_reply ();
extern bool_t xdr_ndmp4_addr_type ();
extern bool_t xdr_ndmp4_config_get_connection_type_reply ();
extern bool_t xdr_ndmp4_config_get_auth_attr_request ();
extern bool_t xdr_ndmp4_config_get_auth_attr_reply ();
extern bool_t xdr_ndmp4_butype_info ();
extern bool_t xdr_ndmp4_config_get_butype_info_reply ();
extern bool_t xdr_ndmp4_fs_info ();
extern bool_t xdr_ndmp4_config_get_fs_info_reply ();
extern bool_t xdr_ndmp4_device_capability ();
extern bool_t xdr_ndmp4_device_info ();
extern bool_t xdr_ndmp4_config_get_tape_info_reply ();
extern bool_t xdr_ndmp4_config_get_scsi_info_reply ();
extern bool_t xdr_ndmp4_class_list ();
extern bool_t xdr_ndmp4_class_version ();
extern bool_t xdr_ndmp4_config_get_ext_list_reply ();
extern bool_t xdr_ndmp4_config_set_ext_list_request ();
extern bool_t xdr_ndmp4_config_set_ext_list_reply ();
extern bool_t xdr_ndmp4_scsi_open_request ();
extern bool_t xdr_ndmp4_scsi_open_reply ();
extern bool_t xdr_ndmp4_scsi_close_reply ();
extern bool_t xdr_ndmp4_scsi_get_state_reply ();
extern bool_t xdr_ndmp4_scsi_reset_device_reply ();
extern bool_t xdr_ndmp4_execute_cdb_request ();
extern bool_t xdr_ndmp4_execute_cdb_reply ();
extern bool_t xdr_ndmp4_scsi_execute_cdb_request ();
extern bool_t xdr_ndmp4_scsi_execute_cdb_reply ();
extern bool_t xdr_ndmp4_tape_open_mode ();
extern bool_t xdr_ndmp4_tape_open_request ();
extern bool_t xdr_ndmp4_tape_open_reply ();
extern bool_t xdr_ndmp4_tape_close_reply ();
extern bool_t xdr_ndmp4_tape_get_state_reply ();
extern bool_t xdr_ndmp4_tape_mtio_op ();
extern bool_t xdr_ndmp4_tape_mtio_request ();
extern bool_t xdr_ndmp4_tape_mtio_reply ();
extern bool_t xdr_ndmp4_tape_write_request ();
extern bool_t xdr_ndmp4_tape_write_reply ();
extern bool_t xdr_ndmp4_tape_read_request ();
extern bool_t xdr_ndmp4_tape_read_reply ();
extern bool_t xdr_ndmp4_tape_execute_cdb_request ();
extern bool_t xdr_ndmp4_tape_execute_cdb_reply ();
extern bool_t xdr_ndmp4_data_operation ();
extern bool_t xdr_ndmp4_data_state ();
extern bool_t xdr_ndmp4_data_halt_reason ();
extern bool_t xdr_ndmp4_tcp_addr ();
extern bool_t xdr_ndmp4_ipc_addr ();
extern bool_t xdr_ndmp4_addr ();
extern bool_t xdr_ndmp4_data_get_state_reply ();
extern bool_t xdr_ndmp4_data_listen_request ();
extern bool_t xdr_ndmp4_data_listen_reply ();
extern bool_t xdr_ndmp4_data_connect_request ();
extern bool_t xdr_ndmp4_data_connect_reply ();
extern bool_t xdr_ndmp4_data_start_backup_request ();
extern bool_t xdr_ndmp4_data_start_backup_reply ();
extern bool_t xdr_ndmp4_name ();
extern bool_t xdr_ndmp4_data_start_recover_request ();
extern bool_t xdr_ndmp4_data_start_recover_reply ();
extern bool_t xdr_ndmp4_data_start_recover_filehist_request ();
extern bool_t xdr_ndmp4_data_start_recover_filehist_reply ();
extern bool_t xdr_ndmp4_data_abort_reply ();
extern bool_t xdr_ndmp4_data_stop_reply ();
extern bool_t xdr_ndmp4_data_get_env_reply ();
extern bool_t xdr_ndmp4_mover_mode ();
extern bool_t xdr_ndmp4_mover_state ();
extern bool_t xdr_ndmp4_mover_pause_reason ();
extern bool_t xdr_ndmp4_mover_halt_reason ();
extern bool_t xdr_ndmp4_mover_set_record_size_request ();
extern bool_t xdr_ndmp4_mover_set_record_size_reply ();
extern bool_t xdr_ndmp4_mover_set_window_request ();
extern bool_t xdr_ndmp4_mover_set_window_reply ();
extern bool_t xdr_ndmp4_mover_connect_request ();
extern bool_t xdr_ndmp4_mover_connect_reply ();
extern bool_t xdr_ndmp4_mover_listen_request ();
extern bool_t xdr_ndmp4_mover_listen_reply ();
extern bool_t xdr_ndmp4_mover_read_request ();
extern bool_t xdr_ndmp4_mover_read_reply ();
extern bool_t xdr_ndmp4_mover_get_state_reply ();
extern bool_t xdr_ndmp4_mover_continue_reply ();
extern bool_t xdr_ndmp4_mover_close_reply ();
extern bool_t xdr_ndmp4_mover_abort_reply ();
extern bool_t xdr_ndmp4_mover_stop_reply ();
extern bool_t xdr_ndmp4_notify_data_halted_post ();
extern bool_t xdr_ndmp4_connection_status_reason ();
extern bool_t xdr_ndmp4_notify_connection_status_post ();
extern bool_t xdr_ndmp4_notify_mover_halted_post ();
extern bool_t xdr_ndmp4_notify_mover_paused_post ();
extern bool_t xdr_ndmp4_notify_data_read_post ();
extern bool_t xdr_ndmp4_has_associated_message ();
extern bool_t xdr_ndmp4_log_type ();
extern bool_t xdr_ndmp4_log_message_post ();
extern bool_t xdr_ndmp4_recovery_status ();
extern bool_t xdr_ndmp4_log_file_post ();
extern bool_t xdr_ndmp4_fs_type ();
extern bool_t xdr_ndmp4_path ();
extern bool_t xdr_ndmp4_nt_path ();
extern bool_t xdr_ndmp4_file_name ();
extern bool_t xdr_ndmp4_file_type ();
extern bool_t xdr_ndmp4_file_stat ();
extern bool_t xdr_ndmp4_file ();
extern bool_t xdr_ndmp4_fh_add_file_post ();
extern bool_t xdr_ndmp4_dir ();
extern bool_t xdr_ndmp4_fh_add_dir_post ();
extern bool_t xdr_ndmp4_node ();
extern bool_t xdr_ndmp4_fh_add_node_post ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NDMP4_H_RPCGEN */
