/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_route_ip_h__
#define __ls10_dev_route_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_ROUTE          0x00005fff:0x00005000 /* RW--D */
#define NV_ROUTE_REG_TABLE_ADDRESS                         0x00005080      /* RW-4R */
#define NV_ROUTE_REG_TABLE_ADDRESS_INDEX                   7:0             /* RWEVF */
#define NV_ROUTE_REG_TABLE_ADDRESS_INDEX_MIN               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_ADDRESS_INDEX_GLTAB_DEPTH       0x000000ff      /* RW--V */
#define NV_ROUTE_REG_TABLE_ADDRESS_AUTO_INCR               31:31           /* RWEVF */
#define NV_ROUTE_REG_TABLE_ADDRESS_AUTO_INCR_DISABLE       0x00000000      /* RW--V */
#define NV_ROUTE_REG_TABLE_ADDRESS_AUTO_INCR_ENABLE        0x00000001      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0                           0x00005090      /* RW-4R */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_0                     3:0             /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_0_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_1                     7:4             /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_1_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_2                     11:8            /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_2_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_3                     15:12           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_3_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_4                     19:16           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_4_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_5                     23:20           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_5_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_6                     27:24           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_6_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_7                     31:28           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA0_GLX_7_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1                           0x00005094      /* RW-4R */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_8                     3:0             /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_8_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_9                     7:4             /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_9_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_10                    11:8            /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_10_INIT               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_11                    15:12           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_11_INIT               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_12                    19:16           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_12_INIT               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_13                    23:20           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_13_INIT               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_14                    27:24           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_14_INIT               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_15                    31:28           /* RWEVF */
#define NV_ROUTE_REG_TABLE_DATA1_GLX_15_INIT               0x00000000      /* RWE-V */
#define NV_ROUTE_REG_TABLE_DATA2                           0x00005098      /* R--4R */
#define NV_ROUTE_REG_TABLE_DATA2_ECC                       7:0             /* R-EVF */
#define NV_ROUTE_REG_TABLE_DATA2_ECC_INIT                  0x00000000      /* R-E-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0                          0x000050a0      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0                    1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN0_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1                    5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN1_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2                    9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN2_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3                    13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN3_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4                    17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN4_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5                    21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN5_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6                    25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN6_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7                    29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE0_RFUN7_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1                          0x000050a4      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8                    1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN8_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9                    5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_SPRAY              0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_RESERVED           0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_RANDOM             0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN9_ALTERNATE          0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10                   9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN10_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11                   13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN11_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12                   17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN12_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13                   21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN13_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14                   25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN14_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15                   29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE1_RFUN15_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2                          0x000050a8      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16                   1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN16_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17                   5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN17_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18                   9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN18_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19                   13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN19_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20                   17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN20_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21                   21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN21_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22                   25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN22_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23                   29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE2_RFUN23_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3                          0x000050ac      /* RW-4R */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24                   1:0             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN24_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25                   5:4             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN25_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26                   9:8             /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN26_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27                   13:12           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN27_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28                   17:16           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN28_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29                   21:20           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN29_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30                   25:24           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN30_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31                   29:28           /* RWEVF */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_SPRAY             0x00000000      /* RWE-V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_RESERVED          0x00000001      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_RANDOM            0x00000002      /* RW--V */
#define NV_ROUTE_CMD_ROUTE_TABLE3_RFUN31_ALTERNATE         0x00000003      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0                              0x00005400      /* RW-4R */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR                  0:0             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR__ONWRITE         "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR_NONE             0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_ROUTEBUFERR_CLEAR            0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR             1:1             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR__ONWRITE    "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_NOPORTDEFINEDERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR        2:2             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR__ONWRITE "oneToClear"  /*       */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR_NONE   0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_INVALIDROUTEPOLICYERR_CLEAR  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR            3:3             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR__ONWRITE   "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_LIMIT_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR              4:4             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR__ONWRITE     "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_GLT_ECC_DBE_ERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR                 6:6             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR__ONWRITE        "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR_NONE            0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_PDCTRLPARERR_CLEAR           0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR            7:7             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR__ONWRITE   "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_LIMIT_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR              8:8             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR__ONWRITE     "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_NVS_ECC_DBE_ERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR                    9:9             /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR__ONWRITE           "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR_NONE               0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_CDTPARERR_CLEAR              0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_LIMIT_ERR          10:10           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_LIMIT_ERR__ONWRITE "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_LIMIT_ERR_NONE     0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_LIMIT_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_DBE_ERR            11:11           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_DBE_ERR__ONWRITE   "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_DBE_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_MCRID_ECC_DBE_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_LIMIT_ERR       12:12           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_LIMIT_ERR__ONWRITE "oneToClear" /*       */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_LIMIT_ERR_NONE  0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_LIMIT_ERR_CLEAR 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_DBE_ERR         13:13           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_DBE_ERR__ONWRITE "oneToClear"   /*       */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_DBE_ERR_NONE    0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_EXTMCRID_ECC_DBE_ERR_CLEAR   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_LIMIT_ERR            14:14           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_LIMIT_ERR__ONWRITE   "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_LIMIT_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_LIMIT_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_DBE_ERR              15:15           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_DBE_ERR__ONWRITE     "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_DBE_ERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_RAM_ECC_DBE_ERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_INVALID_MCRID_ERR            16:16           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_INVALID_MCRID_ERR__ONWRITE   "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_INVALID_MCRID_ERR_NONE       0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_INVALID_MCRID_ERR_CLEAR      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_STATUS_0_MC_TRIGGER_ERR               17:17           /* RWDVF */
#define NV_ROUTE_ERR_STATUS_0_MC_TRIGGER_ERR__ONWRITE      "oneToClear"    /*       */
#define NV_ROUTE_ERR_STATUS_0_MC_TRIGGER_ERR_NONE          0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_STATUS_0_MC_TRIGGER_ERR_CLEAR         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0                              0x00005404      /* RW-4R */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR                  0:0             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR__PROD            0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR_DISABLE          0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_ROUTEBUFERR_ENABLE           0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR             1:1             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR__PROD       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_NOPORTDEFINEDERR_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR        2:2             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR__PROD  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR            3:3             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR__PROD      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_LIMIT_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR              4:4             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_GLT_ECC_DBE_ERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR                 6:6             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR__PROD           0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR_DISABLE         0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_PDCTRLPARERR_ENABLE          0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR            7:7             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR__PROD      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_LIMIT_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR              8:8             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_NVS_ECC_DBE_ERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR                    9:9             /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR__PROD              0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR_DISABLE            0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_CDTPARERR_ENABLE             0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_LIMIT_ERR          10:10           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_LIMIT_ERR__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_LIMIT_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_LIMIT_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_DBE_ERR            11:11           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_DBE_ERR__PROD      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_DBE_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_MCRID_ECC_DBE_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_LIMIT_ERR       12:12           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_LIMIT_ERR__PROD 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_LIMIT_ERR_DISABLE 0x00000000    /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_LIMIT_ERR_ENABLE 0x00000001     /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_DBE_ERR         13:13           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_DBE_ERR__PROD   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_DBE_ERR_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_EXTMCRID_ECC_DBE_ERR_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_LIMIT_ERR            14:14           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_LIMIT_ERR__PROD      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_LIMIT_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_LIMIT_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_DBE_ERR              15:15           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_DBE_ERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_DBE_ERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_RAM_ECC_DBE_ERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALID_MCRID_ERR            16:16           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_INVALID_MCRID_ERR__PROD      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALID_MCRID_ERR_DISABLE    0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_INVALID_MCRID_ERR_ENABLE     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_LOG_EN_0_MC_TRIGGER_ERR               17:17           /* RWEVF */
#define NV_ROUTE_ERR_LOG_EN_0_MC_TRIGGER_ERR_DISABLE       0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_LOG_EN_0_MC_TRIGGER_ERR_ENABLE        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0                     0x00005408      /* RW-4R */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR         0:0             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR__PROD   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_ROUTEBUFERR_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR    1:1             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR 2:2           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR   3:3             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR     4:4             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR        6:6             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR__PROD  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_PDCTRLPARERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR   7:7             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR     8:8             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR           9:9             /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR__PROD     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR_DISABLE   0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_CDTPARERR_ENABLE    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR 10:10           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR   11:11           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR__PROD 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR 12:12        /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR 13:13          /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR   14:14           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR     15:15           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALID_MCRID_ERR   16:16           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALID_MCRID_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_INVALID_MCRID_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MC_TRIGGER_ERR      17:17           /* RWEVF */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MC_TRIGGER_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_ROUTE_ERR_FATAL_REPORT_EN_0_MC_TRIGGER_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0                 0x0000540c      /* RW-4R */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR     0:0             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_ROUTEBUFERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR 1:1            /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NOPORTDEFINEDERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR 2:2       /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR 3:3           /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR 4:4             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_GLT_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR    6:6             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_PDCTRLPARERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR 7:7           /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR 8:8             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_NVS_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR       9:9             /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR_DISABLE 0x00000000    /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_CDTPARERR_ENABLE 0x00000001     /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR 10:10       /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR 11:11         /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MCRID_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR 12:12    /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR 13:13      /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_EXTMCRID_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR 14:14         /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR 15:15           /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_RAM_ECC_DBE_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALID_MCRID_ERR 16:16         /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALID_MCRID_ERR__PROD 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALID_MCRID_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_INVALID_MCRID_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MC_TRIGGER_ERR  17:17           /* RWEVF */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MC_TRIGGER_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_NON_FATAL_REPORT_EN_0_MC_TRIGGER_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CORRECTABLE_REPORT_EN_0               0x00005410      /* RW-4R */
#define NV_ROUTE_ERR_CONTAIN_EN_0                          0x00005414      /* RW-4R */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR              0:0             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR__PROD        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR_DISABLE      0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_ROUTEBUFERR_ENABLE       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR         1:1             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR_DISABLE 0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NOPORTDEFINEDERR_ENABLE  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR    2:2             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALIDROUTEPOLICYERR_ENABLE 0x00000001  /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR        3:3             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_LIMIT_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR          4:4             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_GLT_ECC_DBE_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR             6:6             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR__PROD       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_PDCTRLPARERR_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR        7:7             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_LIMIT_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR          8:8             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_NVS_ECC_DBE_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR                9:9             /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR__PROD          0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR_DISABLE        0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_CDTPARERR_ENABLE         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_LIMIT_ERR      10:10           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_LIMIT_ERR_DISABLE 0x00000000   /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_LIMIT_ERR_ENABLE 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_DBE_ERR        11:11           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_DBE_ERR__PROD  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_DBE_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MCRID_ECC_DBE_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_LIMIT_ERR   12:12           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_LIMIT_ERR_DISABLE 0x00000000 /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_LIMIT_ERR_ENABLE 0x00000001 /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_DBE_ERR     13:13           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_DBE_ERR__PROD 0x00000001    /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_DBE_ERR_DISABLE 0x00000000  /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_EXTMCRID_ECC_DBE_ERR_ENABLE 0x00000001   /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_LIMIT_ERR        14:14           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_LIMIT_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_LIMIT_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_DBE_ERR          15:15           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_DBE_ERR__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_DBE_ERR_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_RAM_ECC_DBE_ERR_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALID_MCRID_ERR        16:16           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALID_MCRID_ERR_DISABLE 0x00000000     /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_INVALID_MCRID_ERR_ENABLE 0x00000001      /* RW--V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MC_TRIGGER_ERR           17:17           /* RWEVF */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MC_TRIGGER_ERR_DISABLE   0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_CONTAIN_EN_0_MC_TRIGGER_ERR_ENABLE    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0                               0x0000541c      /* RW-4R */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR                   0:0             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR__ONWRITE          "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR_NONE              0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_ROUTEBUFERR_CLEAR             0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR              1:1             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR__ONWRITE     "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR_NONE         0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_NOPORTDEFINEDERR_CLEAR        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR         2:2             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR__ONWRITE "oneToClear"   /*       */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR_NONE    0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_INVALIDROUTEPOLICYERR_CLEAR   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR             3:3             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR__ONWRITE    "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_LIMIT_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR               4:4             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR__ONWRITE      "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR_NONE          0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_GLT_ECC_DBE_ERR_CLEAR         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR                  6:6             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR__ONWRITE         "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR_NONE             0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_PDCTRLPARERR_CLEAR            0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR             7:7             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR__ONWRITE    "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_LIMIT_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR               8:8             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR__ONWRITE      "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR_NONE          0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_NVS_ECC_DBE_ERR_CLEAR         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR                     9:9             /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR__ONWRITE            "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR_NONE                0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_CDTPARERR_CLEAR               0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_LIMIT_ERR           10:10           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_LIMIT_ERR__ONWRITE  "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_LIMIT_ERR_NONE      0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_LIMIT_ERR_CLEAR     0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_DBE_ERR             11:11           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_DBE_ERR__ONWRITE    "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_DBE_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_MCRID_ECC_DBE_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_LIMIT_ERR        12:12           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_LIMIT_ERR__ONWRITE "oneToClear"  /*       */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_LIMIT_ERR_NONE   0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_LIMIT_ERR_CLEAR  0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_DBE_ERR          13:13           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_DBE_ERR__ONWRITE "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_DBE_ERR_NONE     0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_EXTMCRID_ECC_DBE_ERR_CLEAR    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_LIMIT_ERR             14:14           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_LIMIT_ERR__ONWRITE    "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_LIMIT_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_LIMIT_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_DBE_ERR               15:15           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_DBE_ERR__ONWRITE      "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_DBE_ERR_NONE          0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_RAM_ECC_DBE_ERR_CLEAR         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_INVALID_MCRID_ERR             16:16           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_INVALID_MCRID_ERR__ONWRITE    "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_INVALID_MCRID_ERR_NONE        0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_INVALID_MCRID_ERR_CLEAR       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_FIRST_0_MC_TRIGGER_ERR                17:17           /* RWDVF */
#define NV_ROUTE_ERR_FIRST_0_MC_TRIGGER_ERR__ONWRITE       "oneToClear"    /*       */
#define NV_ROUTE_ERR_FIRST_0_MC_TRIGGER_ERR_NONE           0x00000000      /* RWD-V */
#define NV_ROUTE_ERR_FIRST_0_MC_TRIGGER_ERR_CLEAR          0x00000001      /* RW--V */
#define NV_ROUTE_ERR_HEADER_LOG_4                          0x00005430      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_4_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_4_DW_INIT                  0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_5                          0x00005434      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_5_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_5_DW_INIT                  0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_6                          0x00005438      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_6_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_6_DW_INIT                  0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_7                          0x0000543c      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_7_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_7_DW_INIT                  0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_8                          0x00005440      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_8_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_8_DW_INIT                  0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_9                          0x00005444      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_9_DW                       31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_9_DW_INIT                  0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_10                         0x00005448      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_10_DW                      31:0            /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_10_DW_INIT                 0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_VALID                      0x0000544c      /* R--4R */
#define NV_ROUTE_ERR_HEADER_LOG_VALID_HEADERVALID0         0:0             /* R-DVF */
#define NV_ROUTE_ERR_HEADER_LOG_VALID_HEADERVALID0_INVALID 0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_HEADER_LOG_VALID_HEADERVALID0_VALID   0x00000001      /* R---V */
#define NV_ROUTE_ERR_TIMESTAMP_LOG                         0x00005450      /* R--4R */
#define NV_ROUTE_ERR_TIMESTAMP_LOG_TIMESTAMP               23:0            /* R-DVF */
#define NV_ROUTE_ERR_TIMESTAMP_LOG_TIMESTAMP_INIT          0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_MISC_LOG_0                            0x00005454      /* R--4R */
#define NV_ROUTE_ERR_MISC_LOG_0_SPORT                      5:0             /* R-DVF */
#define NV_ROUTE_ERR_MISC_LOG_0_SPORT_INIT                 0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_MISC_LOG_0_ENCODEDVC                  10:8            /* R-DVF */
#define NV_ROUTE_ERR_MISC_LOG_0_ENCODEDVC_INIT             0x00000000      /* R-D-V */
#define NV_ROUTE_ERR_ECC_CTRL                              0x00005470      /* RW-4R */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE               0:0             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE_ENABLE        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE_DISABLE       0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_GLT_ECC_ENABLE__PROD         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE               2:2             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE_ENABLE        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE_DISABLE       0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_NVS_ECC_ENABLE__PROD         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_MCRID_ECC_ENABLE             3:3             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_MCRID_ECC_ENABLE_ENABLE      0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_MCRID_ECC_ENABLE_DISABLE     0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_MCRID_ECC_ENABLE__PROD       0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_EXTMCRID_ECC_ENABLE          4:4             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_EXTMCRID_ECC_ENABLE_ENABLE   0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_EXTMCRID_ECC_ENABLE_DISABLE  0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_EXTMCRID_ECC_ENABLE__PROD    0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKENBGLT           5:5             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKENBGLT_DISABLE   0x00000000      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKENBGLT_ENABLE    0x00000001      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKMCRIDENB         6:6             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKMCRIDENB_DISABLE 0x00000000      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKMCRIDENB_ENABLE  0x00000001      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKEXTMCRIDENB      7:7             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKEXTMCRIDENB_DISABLE 0x00000000   /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_ECCWRITEBACKEXTMCRIDENB_ENABLE 0x00000001    /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_RAM_ECC_ENABLE               8:8             /* RWEVF */
#define NV_ROUTE_ERR_ECC_CTRL_RAM_ECC_ENABLE_ENABLE        0x00000001      /* RW--V */
#define NV_ROUTE_ERR_ECC_CTRL_RAM_ECC_ENABLE_DISABLE       0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_ECC_CTRL_RAM_ECC_ENABLE__PROD         0x00000001      /* RW--V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER                 0x00005480      /* RW-4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_ERROR_COUNT     23:0            /* RWDVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000     /* RWD-V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT           0x00005484      /* RW-4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0          /* RWDVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS                 0x00005488      /* R--4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_ERROR_ADDRESS   7:0             /* R-DVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000   /* R-D-V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID           0x0000548c      /* R--4R */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID_VALID     0:0             /* R-DVF */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000  /* R-D-V */
#define NV_ROUTE_ERR_GLT_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001    /* R---V */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER                 0x00005490      /* RW-4R */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_ERROR_COUNT     23:0            /* RWDVF */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000     /* RWD-V */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT           0x00005494      /* RW-4R */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0          /* RWDVF */
#define NV_ROUTE_ERR_NVS_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_COUNTER               0x00005498      /* RW-4R */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_COUNTER_ERROR_COUNT   23:0            /* RWDVF */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000   /* RWD-V */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_COUNTER_LIMIT         0x0000549c      /* RW-4R */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0        /* RWDVF */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS               0x000054a0      /* R--4R */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS_ERROR_ADDRESS 6:0             /* R-DVF */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000 /* R-D-V */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS_VALID         0x000054a4      /* R--4R */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS_VALID_VALID   0:0             /* R-DVF */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000 /* R-D-V */
#define NV_ROUTE_ERR_MCRID_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001  /* R---V */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_COUNTER            0x000054a8      /* RW-4R */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_COUNTER_ERROR_COUNT 23:0           /* RWDVF */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000 /* RWD-V */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_COUNTER_LIMIT      0x000054ac      /* RW-4R */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0     /* RWDVF */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS            0x000054b0      /* R--4R */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS_ERROR_ADDRESS 3:0          /* R-DVF */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000 /* R-D-V */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS_VALID      0x000054b4      /* R--4R */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS_VALID_VALID 0:0            /* R-DVF */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000 /* R-D-V */
#define NV_ROUTE_ERR_EXTMCRID_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001 /* R---V */
#define NV_ROUTE_MCRID_ECC                                 0x000054b8      /* R--4R */
#define NV_ROUTE_MCRID_ECC_MCRID_ECC                       10:0            /* R-EVF */
#define NV_ROUTE_MCRID_ECC_MCRID_ECC_INIT                  0x00000000      /* R-E-V */
#define NV_ROUTE_MCRID_ECC_EXTMCRID_ECC                    26:16           /* R-EVF */
#define NV_ROUTE_MCRID_ECC_EXTMCRID_ECC_INIT               0x00000000      /* R-E-V */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_COUNTER                 0x000054bc      /* RW-4R */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_COUNTER_ERROR_COUNT     23:0            /* RWDVF */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_COUNTER_ERROR_COUNT_INIT 0x00000000     /* RWD-V */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_COUNTER_LIMIT           0x000054c0      /* RW-4R */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT 23:0          /* RWDVF */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_COUNTER_LIMIT_ERROR_LIMIT_INIT 0x00ffffff /* RWD-V */
#define NV_ROUTE_RIDTABADDR                                0x00005600      /* RW-4R */
#define NV_ROUTE_RIDTABADDR_INDEX                          6:0             /* RWEVF */
#define NV_ROUTE_RIDTABADDR_INDEX_INIT                     0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABADDR_INDEX_MCRIDTAB_DEPTH           0x0000007f      /* RW--V */
#define NV_ROUTE_RIDTABADDR_INDEX_MCRIDEXTTAB_DEPTH        0x0000000f      /* RW--V */
#define NV_ROUTE_RIDTABADDR_RAM_SEL                        16:16           /* RWEVF */
#define NV_ROUTE_RIDTABADDR_RAM_SEL_SELECTSMCRIDROUTERAM   0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABADDR_RAM_SEL_SELECTSEXTMCRIDROUTERAM 0x00000001     /* RW--V */
#define NV_ROUTE_RIDTABADDR_AUTO_INCR                      31:31           /* RWEVF */
#define NV_ROUTE_RIDTABADDR_AUTO_INCR_ENABLE               0x00000001      /* RWE-V */
#define NV_ROUTE_RIDTABADDR_AUTO_INCR_DISABLE              0x00000000      /* RW--V */
#define NV_ROUTE_RIDTABDATA0                               0x00005610      /* RW-4R */
#define NV_ROUTE_RIDTABDATA0_MCPL_SIZE                     5:0             /* RWEVF */
#define NV_ROUTE_RIDTABDATA0_MCPL_SIZE_INIT                0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA0_MCPL_SPRAY_SIZE               11:8            /* RWEVF */
#define NV_ROUTE_RIDTABDATA0_MCPL_SPRAY_SIZE_INIT          0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA0_MCPL_RID_EXT_PTR              19:16           /* RWEVF */
#define NV_ROUTE_RIDTABDATA0_MCPL_RID_EXT_PTR_INIT         0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA0_MCPL_NO_DYN_RSP               29:29           /* RWEVF */
#define NV_ROUTE_RIDTABDATA0_MCPL_NO_DYN_RSP_INIT          0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA0_MCPL_RID_EXT_PTR_VAL          30:30           /* RWEVF */
#define NV_ROUTE_RIDTABDATA0_MCPL_RID_EXT_PTR_VAL_INIT     0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA0_VALID                         31:31           /* RWEVF */
#define NV_ROUTE_RIDTABDATA0_VALID_INIT                    0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA0_VALID_VALID                   0x00000001      /* RW--V */
#define NV_ROUTE_RIDTABDATA1                               0x00005614      /* RW-4R */
#define NV_ROUTE_RIDTABDATA1_MCPL_E_PORT                   3:0             /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_E_PORT_INIT              0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_E_ALTPATH                4:4             /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_E_ALTPATH_INIT           0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_E_REQ_VCHOP              6:5             /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_E_REQ_VCHOP_INIT         0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_O_PORT                   10:7            /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_O_PORT_INIT              0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_O_ALTPATH                11:11           /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_O_ALTPATH_INIT           0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_O_REQ_VCHOP              13:12           /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_O_REQ_VCHOP_INIT         0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_TCP                      15:14           /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_TCP_INIT                 0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_PORT_FLAG                16:16           /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_PORT_FLAG_INIT           0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_RND_CONTINUE             17:17           /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_RND_CONTINUE_INIT        0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA1_MCPL_LAST_RND                 18:18           /* RWEVF */
#define NV_ROUTE_RIDTABDATA1_MCPL_LAST_RND_INIT            0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA2                               0x00005618      /* RW-4R */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR0                 4:0             /* RWEVF */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR0_INIT            0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR1                 12:8            /* RWEVF */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR1_INIT            0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR2                 20:16           /* RWEVF */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR2_INIT            0x00000000      /* RWE-V */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR3                 28:24           /* RWEVF */
#define NV_ROUTE_RIDTABDATA2_MCPL_STR_PTR3_INIT            0x00000000      /* RWE-V */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS                 0x0000561c      /* R--4R */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS_ERROR_ADDRESS   8:0             /* R-DVF */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS_ERROR_ADDRESS_INIT 0x00000000   /* R-D-V */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS_VALID           0x00005620      /* R--4R */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS_VALID_VALID     0:0             /* R-DVF */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS_VALID_VALID_INVALID 0x00000000  /* R-D-V */
#define NV_ROUTE_ERR_RAM_ECC_ERROR_ADDRESS_VALID_VALID_VALID 0x00000001    /* R---V */
#endif // __ls10_dev_route_ip_h__
