/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_LOGENTRYACCESS_H_
#define OPENDRIM_LOGENTRYACCESS_H_

#include "OpenDRIM_RecordLogPackage_Common.h"

#include "OpenDRIM_LogEntry.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_load(const CMPIBroker* broker, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_unload(string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_LogEntry>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_LogEntry& instance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogEntry& newInstance, const OpenDRIM_LogEntry& oldInstance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogEntry& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogEntry& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_populate(OpenDRIM_LogEntry& instance, const string& filename, string& line, struct tm* tp, const string& discriminant, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_makeInstances(const string& filename, vector<OpenDRIM_LogEntry>& result, const string& discriminant, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_retrieveInDatetimeBoundaries(const string& log_file, const string& datetime_lower_limit, const string& datetime_upper_limit, vector<OpenDRIM_LogEntry>& log_entries, string& errorMessage);

#endif /*OPENDRIM_LOGENTRYACCESS_H_*/
