/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "OpenDRIM_DHCPCapabilitiesAccess.h"

string InstanceID;

int DHCP_OpenDRIM_DHCPCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	 CF_assert(CF_getSystemName(InstanceID, errorMessage));
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPCapabilities_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DHCPCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_DHCPCapabilities instance;
	instance.setInstanceID(InstanceID);
	
	if (discriminant == "ei") {
		CF_assert(DHCP_OpenDRIM_DHCPCapabilities_populate(instance, errorMessage));
	}
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DHCPCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;
	if(instance.InstanceID!=InstanceID)
	{
		errorMessage="No instance";
		return NOT_FOUND;
	}
	CF_assert(DHCP_OpenDRIM_DHCPCapabilities_populate(instance, errorMessage));
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPCapabilities& newInstance, const OpenDRIM_DHCPCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPCapabilities_populate(OpenDRIM_DHCPCapabilities& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID                [KEY]
	 * [X] ElementName
	 * [X] ElementNameEditSupported
	 * [X] OptionsSupported
	 * + Conditional:
	 * [X] MaxElementNameLen
	 */
	
	vector<unsigned short> optionsSupported;
	string cmd;
	string output;
	
	instance.setElementName("DHCP Capabilities");
	instance.setMaxElementNameLen(256);
	instance.setElementNameEditSupported(false);
	
	cmd="dhclient --version 2>&1";
	
	CF_assert(CF_runCommandFL(cmd,output,errorMessage));
	
	// Options Supported by dhclient v3.1.*
	if(output.find("isc-dhclient-V3.1")!=string::npos)
	{
		for(unsigned int i=3;i<=84;i++)
		{
			if((i>=3 && i<=63) || (i>=66 && i<=81) || i==84)
				optionsSupported.push_back(i);
		}
		optionsSupported.push_back(120);
	}
	
	instance.setOptionsSupported(optionsSupported);
	
	_L_;
	return OK;
}

