RabbitMQ `3.9.25` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 24.2, and supports Erlang 25. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

Starting with this release, RabbitMQ requires Erlang 24.2 or later versions. Nodes **will fail to start** on older Erlang releases.

## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).


### CLI Tools

#### Bug Fixes

  * `rabbitmq-diagnostics status` now handles server responses where free disk space
    is not yet computed. This is the case with nodes early in the boot process.

    GitHub issue: [#6303](https://github.com/rabbitmq/rabbitmq-server/pull/6303)

### Management Plugin

#### Bug Fixes

  * Management UI links now include "noopener" and "noreferrer" attributes to protect
    them against [reverse tabnabbing](https://owasp.org/www-community/attacks/Reverse_Tabnabbing).
    Note that since management UI only includes a small number of external links to trusted resources,
    reverse tabnabbing is unlikely to affect most users. However, it can show up in security scanner results
    and become an issue in environments where a modified version of RabbitMQ is offered as a service.

    Contributed by @illotum (AWS).

    GitHub issue: [#6211](https://github.com/rabbitmq/rabbitmq-server/pull/6211)

### Shovel Plugin

#### Bug Fixes

  * Plugin could stop in environments where no static Shovels were defined and a specific
    sequence of events happens at the same time.

    Contributed by @gomoripeti.

    GitHub issue: [#6286](https://github.com/rabbitmq/rabbitmq-server/pull/6286)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.25.tar.xz`
instead of the source tarball produced by GitHub.
