/* $Id$ 
 *
 * Mov: move (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __MOV_HPP_INCLUDED
#define __MOV_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! move data from one virtual register to another one.
/** This class represents the MOV opcode, which moves data
 *  from one virtual register into another one. Based on operand
 *  types, it can also move data from or to memory.
 *
 *  read operands: src
 *  write operands: dst
 *  Operation: dst = src
 */
class Mov : public OpCode {
public:
	//! c'tor
	/** @param source source of the operation.
	 *  @param destination destination operand.
	 */
	Mov(
		Operand *source, 
		Operand *destination
		) : 	src(source), 
			dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! source of the instruction
	Operand *src;
	//! destination
	Operand *dst;

protected:
	virtual ~Mov() {
		util::MiscUtil::terminate(this->src);
		util::MiscUtil::terminate(this->dst);
	}

}; 

}; /* namespace intermediate */

#endif /* __MOV_HPP_INCLUDED */
