/* Copyright (C) 2001-2020 Artifex Software, Inc.
   All Rights Reserved.

   This software is provided AS-IS with no warranty, either express or
   implied.

   This software is distributed under license and may not be copied,
   modified or distributed except as expressly authorized under the terms
   of the license contained in the file LICENSE in this distribution.

   Refer to licensing information at http://www.artifex.com or contact
   Artifex Software, Inc.,  1305 Grant Avenue - Suite 200, Novato,
   CA 94945, U.S.A., +1(415)492-9861, for further information.
*/

/* Resource data (Rez format) for the MacOS Ghostscript shlib example wrapper
   contributed by Nigel Hathaway. See dmmain.c for rest of this code.
 */

#include "Types.r"

resource 'BNDL' (128) {
	'MCGS',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'ICN#',
		{	/* array IDArray: 1 elements */
			/* [1] */
			0, 128
		},
		/* [2] */
		'FREF',
		{	/* array IDArray: 2 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129
		}
	}
};

resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'FREF' (129) {
	'****',
	1,
	""
};

data 'MWBB' (1008) {
	$"0001 0000"                                          /* .... */
};

data 'MPSR' (1005) {
       $"0009 4D6F 6E61 636F 0000 0000 0000 0000"            /* .Monaco........ */
       $"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
       $"0000 0003 0004 0030 0004 01CA 027B 0030"            /* .......0....{.0 */
       $"0004 01CA 027B BA5E B2EF 0000 0000 0000"            /* ....{^E..... */
       $"0000 0000 0000 0100"                                /* ........ */
};

resource 'ICN#' (128, "Application Icon") {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0000 0000 0800 0000 0A00 000B F200"
		$"007F 4200 00FC 0700 01F0 1F80 03E0 1F80"
		$"03E5 3FC0 03E0 1FC0 03E0 0FC0 03F0 0780"
		$"01F8 8300 00FC 4600 003C 0800 00F4 0000"
		$"03E0 0000 07E0 0000 07FF 6000 07FF FF00"
		$"07FF FFC0 01FF FFE0 007F FFF0 0000 17F0"
		$"0780 01F8 0F04 00F0 0E08 03E0 0F07 FFD0"
		$"0780 D820 03F0 0380 007F FC00 0005 40",
		/* [2] */
		$"0000 1800 0000 1E00 0000 1E00 001F FF00"
		$"00FF FF00 01FF FF00 03FF FF80 03FF FFC0"
		$"07FF FFC0 07FF FFC0 07FF FFC0 03FF FFC0"
		$"03FF FF80 01FF FF00 007F FE00 03FF F000"
		$"07FF F800 07FF FE00 0FFF FF80 0FFF FFE0"
		$"07FF FFF0 03FF FFF8 01FF FFF8 027F FFFC"
		$"1FFF FFFC 1FFF FFFC 1FFF FFF8 1FFF FFF8"
		$"1FFF FFF0 07FF FFC0 01FF FF00 007F FC"
	}
};

resource 'ics#' (128, "Application Icon") {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 00A0 0F10 1C78 1878 1C18 0E20 0600"
		$"1800 3FD0 1FF8 057C 300C 3358 18A8 0340",
		/* [2] */
		$"0070 07F0 1FF0 1FF8 3FF8 3FF8 1FF8 1FF0"
		$"3FF0 3FFC 3FFE 1FFE 7FFE 7FFE 7FFC 1FF0"
	}
};

resource 'icl8' (128, "Application Icon") {
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 F600 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 5656 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 00F6 FCF8 F900 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 00F6 56F9 FCAC"
	$"FCFC ACFE F600 FFF6 0000 0000 0000 0000"
	$"0000 0000 0000 0000 F5FA FDFF FFFF FFFF"
	$"FD81 F800 00F7 FFF7 0000 0000 0000 0000"
	$"0000 0000 0000 00F6 E0FF FFFF FFFD F92B"
	$"0000 0000 F6AC FFFA 0000 0000 0000 0000"
	$"0000 0000 0000 2BFF EAFF FFFE F700 0000"
	$"0000 0056 FFFF FFFF 8100 0000 0000 0000"
	$"0000 0000 0000 FCFF FFFF FF56 0000 00F5"
	$"F500 FAFF FFFF FFFF FFF8 0000 0000 0000"
	$"0000 0000 00F6 FFFF FFFF FE00 0079 0055"
	$"F600 FBFF FFFF FFFF FFFD 0000 0000 0000"
	$"0000 0000 002B FFFF FFFF FC00 007A F6F5"
	$"4F00 00AC FFFF FFFF FFFF 0000 0000 0000"
	$"0000 0000 00F6 FFFF FFFF FFF5 0000 F500"
	$"0000 00F5 ACFF FFFF FFFC 0000 0000 0000"
	$"0000 0000 0000 FCFF FFFF FF81 0000 0024"
	$"F600 0000 F5FD FFFF FF2B 0000 0000 0000"
	$"0000 0000 0000 F5FF FFFF FFFF 8100 0000"
	$"7A7A 0000 00FA FFFF F800 0000 0000 0000"
	$"0000 0000 0000 00F6 FDFF FFFF FFFB 0000"
	$"F579 0000 00FB F4F8 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0056 FFFF FFFF F800"
	$"0000 00F6 8181 0000 0000 0000 0000 0000"
	$"0000 0000 0000 00F8 81FE FFFF FDFA F500"
	$"0000 2BF7 0000 0000 0000 0000 0000 0000"
	$"0000 0000 00F5 FCFF FFFF FBF6 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 00AC FFFF FFFF FC2B 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 2BFF FFFF FFFF FFFF E0FC FC81"
	$"FAF9 FAF7 2B00 0000 0000 0000 0000 0000"
	$"0000 0000 F6FF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF ACF9 F600 0000 0000 0000"
	$"0000 0000 00FC FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FF81 F600 0000 0000"
	$"0000 0000 0000 FAFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FE2B 0000 0000"
	$"0000 0000 0000 0000 F8FB FCFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFD 0000 0000"
	$"0000 0000 0000 0000 0000 0000 00F5 F7F7"
	$"2BF7 F8FA FAFD FFFF FFFF FFFF F900 0000"
	$"0000 0000 F7AC FFFF FCF6 0000 0000 0000"
	$"0000 0000 0000 F5FE FFFF FFFF F900 0000"
	$"0000 00F6 FFFF FFFB 0000 0000 2B81 F700"
	$"0000 0000 0000 00F9 FFFF FFFF 0000 0000"
	$"0000 002B FFFF FF2B 0000 0000 FAFB 0000"
	$"0000 0000 00F5 F8FF FFFF FEF6 F500 0000"
	$"0000 00F5 FEFF FFFC 0000 0000 F5FC FDFC"
	$"ACFC ACFC FDFF FFFF FF81 F556 F500 0000"
	$"0000 0000 F8FF FFFF FBF5 0000 0000 F6FA"
	$"81AC FCFC FCFA 562B F5F8 FCF5 0000 0000"
	$"0000 0000 002B FCFF FFFE FCF9 F82B 0000"
	$"0000 0000 2BF7 FAFC FD56 0000 0000 0000"
	$"0000 0000 0000 00F7 FAFE FFFF FFFF FFFF"
	$"FFFF FFFF FFAC 812B 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 F52B F9F9 FAF9"
	$"FAF8 F72B F6"
};

resource 'icl4' (128, "Application Icon") {
	$"0000 0000 0000 0000 0000 C000 0000 0000"
	$"0000 0000 0000 0000 0000 CD00 0000 0000"
	$"0000 0000 0000 0000 000C ECD0 0000 0000"
	$"0000 0000 000C DDEE EEEE C0FC 0000 0000"
	$"0000 0000 0DFF FFFF AEC0 0CFC 0000 0000"
	$"0000 000C FFFF FEDC 0000 CEFD 0000 0000"
	$"0000 00CA FFFA C000 000D AFFF D000 0000"
	$"0000 00EF FFFD 000C 00DF FFFF FD00 0000"
	$"0000 0CFF FFF0 0D0C C0EF FFFF FE00 0000"
	$"0000 0CFF FFE0 07C0 C00E FFFF FF00 0000"
	$"0000 00FF FFF0 0000 0000 EFFF FE00 0000"
	$"0000 00EF FFFE 0000 C000 CAFF FC00 0000"
	$"0000 000F FFFF D000 7D00 0DFF C000 0000"
	$"0000 000C EFFF FE00 0D00 0EFD 0000 0000"
	$"0000 0000 0DFF FFD0 000C DD00 0000 0000"
	$"0000 000C EEFF AD00 00CC 0000 0000 0000"
	$"0000 00EF FFE0 0000 0000 0000 0000 0000"
	$"0000 0EFF FFEC 0000 0000 0000 0000 0000"
	$"0000 CFFF FFFF FEED DDDC C000 0000 0000"
	$"0000 CFFF FFFF FFFF FFFF FFED C000 0000"
	$"0000 0EFF FFFF FFFF FFFF FFFF FDC0 0000"
	$"0000 00DF FFFF FFFF FFFF FFFF FFAC 0000"
	$"0000 0000 CEEF FFFF FFFF FFFF FFFE 0000"
	$"0000 0000 0000 00CC CCDD DAFF FFFF D000"
	$"0000 CEFF EC00 0000 0000 000F FFFF D000"
	$"000C FFFE 0000 CEC0 0000 000D FFFF 0000"
	$"000C FFFC 0000 DD00 0000 00DF FFF0 C000"
	$"0000 FFFE 0000 0EFE EEEE FFFF FD0D 0000"
	$"0000 CFFF E000 00CD DEEE EDDC 0DE0 0000"
	$"0000 0CEF FFED CC00 0000 CCDD FC00 0000"
	$"0000 000C DAFF FFFF FFFF FEEC 0000 0000"
	$"0000 0000 000C DDDD DDCC"
};

resource 'ics8' (128, "Application Icon") {
	$"0000 0000 0000 0000 0000 2B00 0000 0000"
	$"0000 0000 0000 2B56 F8F9 F856 0000 0000"
	$"0000 0000 FBFF FFFB 56F5 F7FC 0000 0000"
	$"0000 00FC FFFD F500 00F9 FFFF F900 0000"
	$"0000 F5FF FF56 2B2A F6FB FFFF FF00 0000"
	$"0000 00FE FFFB 00F5 0000 FBFF FC00 0000"
	$"0000 00F8 FFFF FA00 7900 F7FD F500 0000"
	$"0000 00F5 F9FF FDF6 00F6 F800 0000 0000"
	$"0000 2BEA FF56 0000 0000 0000 0000 0000"
	$"0000 81FF FFFF FEFD FCFC FAF8 0000 0000"
	$"0000 F6FE FFFF FFFF FFFF FFFF FEF7 0000"
	$"0000 0000 2B56 FA81 81FC FDFF FFFF F600"
	$"0000 ACFE 2B00 2BF5 0000 00F8 FFFF F500"
	$"00F5 FFFC 0000 FA56 56F8 F9FD FE56 F500"
	$"0000 56E0 FBF7 F6F6 F856 56F9 56F6 0000"
	$"0000 0000 F881 FCAC FC81 FA2B"
};

resource 'ics4' (128, "Application Icon") {
	$"0000 0000 00C0 0000 0000 00CD CDCD 0000"
	$"0000 EFFD D0CE 0000 000E FA00 0DFF D000"
	$"000F FDCC 0EFF F000 000F FE00 00EF E000"
	$"000C FFD0 D0CE 0000 0000 DFF0 0CC0 0000"
	$"00CF FD00 0000 0000 00DF FFFA EEDD 0000"
	$"00CA FFFF FFFF FC00 0000 CDDE DEEF FFC0"
	$"00EF C0C0 000C FF00 00FE 00DD CDDF AD00"
	$"00DF DCC0 DCDD D000 0000 DDEE EDDC"
};

resource 'icm8' (128, "Application Icon") {
	$"0000 0000 0000 0000 0000 F800 0000 0000"
	$"0000 0000 2BFA FBAC 8156 F681 0000 0000"
	$"0000 00FA FFFD F7F5 0056 FDFF F800 0000"
	$"0000 F5FF FF56 2B2A F556 FFFF FF00 0000"
	$"0000 00FB FFFE F600 4F00 56FF F800 0000"
	$"0000 00F5 81EA FEF5 00F6 F8F6 0000 0000"
	$"0000 F8FF FFFA 2BF6 F600 0000 0000 0000"
	$"0000 56FF FFFF FFFF FFFF E0FC F9F5 0000"
	$"0000 00F6 F981 FBFC FCAC FDFF FFFD F500"
	$"0000 FDFD F600 F700 0000 0056 FFFE F500"
	$"0000 ACFE 2B00 F7F9 8181 FBFB 81F7 0000"
	$"0000 00F7 FAFB FBFA FAF9 56F8 F6"
};

resource 'icm4' (128, "Application Icon") {
	$"0000 0000 00C0 0000 0000 CDEE ECCE 0000"
	$"000D FAC0 0DEF C000 000F FD0C 0DFF F000"
	$"000E FFC0 C0DF C000 0000 DFEC 00CC 0000"
	$"00CF FDC0 C000 0000 00DF FFFF FFFE D000"
	$"000C DDEE EEFF FF00 00AE C0C0 000D FEC0"
	$"00FE C0CD DEDE DC00 000C DDED DDDC C0"
};

resource 'icm#' (128, "Application Icon") {
	{	/* array: 2 elements */
		/* [1] */
		$"0000 0350 1C30 1C78 1C10 0620 1900 3FF8"
		$"0B7C 300C 31B0 0720",
		/* [2] */
		$"0070 0FF0 1FF8 3FF8 3FF8 1FF0 3FF8 3FFC"
		$"1FFE 7FFE 7FFE 3FF8"
	}
};

resource 'icns' (128, "Application Icon") {
	{	/* array elementArray: 20 elements */
		/* [1] */
		'ICN#',
		$"0000 0000 0000 0800 0000 0A00 000B F200"
		$"007F 4200 00FC 0700 01F0 1F80 03E0 1F80"
		$"03E5 3FC0 03E0 1FC0 03E0 0FC0 03F0 0780"
		$"01F8 8300 00FC 4600 003C 0800 00F4 0000"
		$"03E0 0000 07E0 0000 07FF 6000 07FF FF00"
		$"07FF FFC0 01FF FFE0 007F FFF0 0000 17F0"
		$"0780 01F8 0F04 00F0 0E08 03E0 0F07 FFD0"
		$"0780 D820 03F0 0380 007F FC00 0005 4000"
		$"0000 1800 0000 1E00 0000 1E00 001F FF00"
		$"00FF FF00 01FF FF00 03FF FF80 03FF FFC0"
		$"07FF FFC0 07FF FFC0 07FF FFC0 03FF FFC0"
		$"03FF FF80 01FF FF00 007F FE00 03FF F000"
		$"07FF F800 07FF FE00 0FFF FF80 0FFF FFE0"
		$"07FF FFF0 03FF FFF8 01FF FFF8 027F FFFC"
		$"1FFF FFFC 1FFF FFFC 1FFF FFF8 1FFF FFF8"
		$"1FFF FFF0 07FF FFC0 01FF FF00 007F FC00",
		/* [2] */
		'icl4',
		$"0000 0000 0000 0000 0000 C000 0000 0000"
		$"0000 0000 0000 0000 0000 CD00 0000 0000"
		$"0000 0000 0000 0000 000C ECD0 0000 0000"
		$"0000 0000 000C DDEE EEEE C0FC 0000 0000"
		$"0000 0000 0DFF FFFF AEC0 0CFC 0000 0000"
		$"0000 000C FFFF FEDC 0000 CEFD 0000 0000"
		$"0000 00CA FFFA C000 000D AFFF D000 0000"
		$"0000 00EF FFFD 000C 00DF FFFF FD00 0000"
		$"0000 0CFF FFF0 0D0C C0EF FFFF FE00 0000"
		$"0000 0CFF FFE0 07C0 C00E FFFF FF00 0000"
		$"0000 00FF FFF0 0000 0000 EFFF FE00 0000"
		$"0000 00EF FFFE 0000 C000 CAFF FC00 0000"
		$"0000 000F FFFF D000 7D00 0DFF C000 0000"
		$"0000 000C EFFF FE00 0D00 0EFD 0000 0000"
		$"0000 0000 0DFF FFD0 000C DD00 0000 0000"
		$"0000 000C EEFF AD00 00CC 0000 0000 0000"
		$"0000 00EF FFE0 0000 0000 0000 0000 0000"
		$"0000 0EFF FFEC 0000 0000 0000 0000 0000"
		$"0000 CFFF FFFF FEED DDDC C000 0000 0000"
		$"0000 CFFF FFFF FFFF FFFF FFED C000 0000"
		$"0000 0EFF FFFF FFFF FFFF FFFF FDC0 0000"
		$"0000 00DF FFFF FFFF FFFF FFFF FFAC 0000"
		$"0000 0000 CEEF FFFF FFFF FFFF FFFE 0000"
		$"0000 0000 0000 00CC CCDD DAFF FFFF D000"
		$"0000 CEFF EC00 0000 0000 000F FFFF D000"
		$"000C FFFE 0000 CEC0 0000 000D FFFF 0000"
		$"000C FFFC 0000 DD00 0000 00DF FFF0 C000"
		$"0000 FFFE 0000 0EFE EEEE FFFF FD0D 0000"
		$"0000 CFFF E000 00CD DEEE EDDC 0DE0 0000"
		$"0000 0CEF FFED CC00 0000 CCDD FC00 0000"
		$"0000 000C DAFF FFFF FFFF FEEC 0000 0000"
		$"0000 0000 000C DDDD DDCC 0000 0000 0000",
		/* [3] */
		'icl8',
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 F600 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 5656 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00F6 FCF8 F900 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00F6 56F9 FCAC"
		$"FCFC ACFE F600 FFF6 0000 0000 0000 0000"
		$"0000 0000 0000 0000 F5FA FDFF FFFF FFFF"
		$"FD81 F800 00F7 FFF7 0000 0000 0000 0000"
		$"0000 0000 0000 00F6 E0FF FFFF FFFD F92B"
		$"0000 0000 F6AC FFFA 0000 0000 0000 0000"
		$"0000 0000 0000 2BFF EAFF FFFE F700 0000"
		$"0000 0056 FFFF FFFF 8100 0000 0000 0000"
		$"0000 0000 0000 FCFF FFFF FF56 0000 00F5"
		$"F500 FAFF FFFF FFFF FFF8 0000 0000 0000"
		$"0000 0000 00F6 FFFF FFFF FE00 0079 0055"
		$"F600 FBFF FFFF FFFF FFFD 0000 0000 0000"
		$"0000 0000 002B FFFF FFFF FC00 007A F6F5"
		$"4F00 00AC FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 00F6 FFFF FFFF FFF5 0000 F500"
		$"0000 00F5 ACFF FFFF FFFC 0000 0000 0000"
		$"0000 0000 0000 FCFF FFFF FF81 0000 0024"
		$"F600 0000 F5FD FFFF FF2B 0000 0000 0000"
		$"0000 0000 0000 F5FF FFFF FFFF 8100 0000"
		$"7A7A 0000 00FA FFFF F800 0000 0000 0000"
		$"0000 0000 0000 00F6 FDFF FFFF FFFB 0000"
		$"F579 0000 00FB F4F8 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0056 FFFF FFFF F800"
		$"0000 00F6 8181 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00F8 81FE FFFF FDFA F500"
		$"0000 2BF7 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00F5 FCFF FFFF FBF6 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00AC FFFF FFFF FC2B 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 2BFF FFFF FFFF FFFF E0FC FC81"
		$"FAF9 FAF7 2B00 0000 0000 0000 0000 0000"
		$"0000 0000 F6FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF ACF9 F600 0000 0000 0000"
		$"0000 0000 00FC FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF81 F600 0000 0000"
		$"0000 0000 0000 FAFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FE2B 0000 0000"
		$"0000 0000 0000 0000 F8FB FCFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFD 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00F5 F7F7"
		$"2BF7 F8FA FAFD FFFF FFFF FFFF F900 0000"
		$"0000 0000 F7AC FFFF FCF6 0000 0000 0000"
		$"0000 0000 0000 F5FE FFFF FFFF F900 0000"
		$"0000 00F6 FFFF FFFB 0000 0000 2B81 F700"
		$"0000 0000 0000 00F9 FFFF FFFF 0000 0000"
		$"0000 002B FFFF FF2B 0000 0000 FAFB 0000"
		$"0000 0000 00F5 F8FF FFFF FEF6 F500 0000"
		$"0000 00F5 FEFF FFFC 0000 0000 F5FC FDFC"
		$"ACFC ACFC FDFF FFFF FF81 F556 F500 0000"
		$"0000 0000 F8FF FFFF FBF5 0000 0000 F6FA"
		$"81AC FCFC FCFA 562B F5F8 FCF5 0000 0000"
		$"0000 0000 002B FCFF FFFE FCF9 F82B 0000"
		$"0000 0000 2BF7 FAFC FD56 0000 0000 0000"
		$"0000 0000 0000 00F7 FAFE FFFF FFFF FFFF"
		$"FFFF FFFF FFAC 812B 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 F52B F9F9 FAF9"
		$"FAF8 F72B F600 0000 0000 0000 0000 0000",
		/* [4] */
		'il32',
		$"91FF 00DF 9CFF 01A0 909A FF03 D350 AF80"
		$"91FF 02CF A080 8140 0538 24D5 FF00 DF8D"
		$"FF02 EF80 2081 0008 0420 60A2 FFFF BF00"
		$"BF8C FF01 CF10 8100 022C 86BF 81FF 03DF"
		$"3000 728B FF01 CF10 8000 0110 B083 FF01"
		$"9410 8000 0066 8AFF 0040 8100 00A2 80FF"
		$"03E5 E3FF 7C83 0000 A088 FF00 DF81 0008"
		$"10FF FF82 FF91 C7FF 6083 0000 3088 FF00"
		$"BF81 0009 40FF FF66 E3D5 BAFF F330 8300"
		$"88FF 00DF 8200 03EF FFF1 E381 FF01 EF30"
		$"8100 0044 89FF 004C 8100 006C 80FF 01F1"
		$"C780 FF05 EF20 0000 04C5 89FF 01DF 1081"
		$"0000 6C80 FF01 7458 80FF 0380 0000 A08B"
		$"FF01 D120 8100 0460 FFFF E382 80FF 0254"
		$"10A2 8EFF 0192 0280 0000 A081 FF03 DB64"
		$"60EF 8DFF 07AF 6412 0204 2080 EF80 FF01"
		$"CFBB 8EFF 01EF 4480 0001 50CF 96FF 0040"
		$"8100 0150 CF95 FF00 CF84 0003 1040 4268"
		$"8080 01BF D18C FF01 CF02 8D00 0238 92DF"
		$"89FF 0044 8F00 0204 62DF 88FF 0070 9000"
		$"0110 CF89 FF02 A060 408D 0001 22EF 8DFF"
		$"00DF 81BF 04A0 8070 2002 8200 0090 84FF"
		$"05B4 3600 0046 DB89 FF01 DF20 8100 0090"
		$"83FF 00DF 8000 0058 81FF 02CF 68BF 85FF"
		$"0080 8000 0110 EF83 FF00 BF80 0000 BF81"
		$"FF01 705A 84FF 07EF A410 0000 10CF EF83"
		$"FF04 EF10 0000 5281 FF02 EF42 2082 4000"
		$"2681 0003 68E7 96EF 84FF 05A2 0200 0052"
		$"EF81 FF02 D380 6080 4007 4480 90BF EFA4"
		$"54EF 86FF 08C3 4000 0010 5080 AFCF 83FF"
		$"05CF AF80 4C24 A28A FF02 BF70 2086 0004"
		$"0400 3260 C38F FF02 EFBF 9081 8003 A0BF"
		$"C7DF 88FF 91FF 00DE 9BFF 02FE A090 9AFF"
		$"03D3 50AF 8091 FF02 CFA0 8081 4005 3824"
		$"D4FF 00DF 8DFF 02EF 8020 8100 0804 2060"
		$"A2FF FFBF 00BF 8CFF 01CF 1081 0002 2C85"
		$"BF81 FF03 DF30 0072 8BFF 01CF 1080 0001"
		$"10B0 83FF 0194 1080 0000 668A FF00 4081"
		$"0000 A280 FF03 ECEB FF7C 8300 00A0 88FF"
		$"00DF 8100 0810 FFFF A6FF B1D7 FF60 8300"
		$"002F 88FF 00BF 8100 0940 FFFF 92EB E1CE"
		$"FFF2 3083 0088 FF00 DE82 0003 EFFF F5EB"
		$"81FF 01EF 3081 0000 4489 FF00 4C81 0000"
		$"6B80 FF01 F5D7 80FF 05EF 2000 0004 C589"
		$"FF01 DF10 8100 006B 80FF 019C 8780 FF03"
		$"8000 00A0 8BFF 01D1 2081 0004 60FF FFEB"
		$"A680 FF02 5410 A28E FF01 9202 8000 00A0"
		$"81FF 03DB 6360 EF8D FF07 AF64 1202 0420"
		$"80EF 80FF 01CF BB8E FF01 EF44 8000 0150"
		$"CF96 FF00 3F81 0001 50CF 95FF 00CF 8400"
		$"0310 4042 6880 8001 BFD1 8CFF 01CF 028D"
		$"0002 3892 DF89 FF00 448F 0002 0462 DF88"
		$"FF00 7090 0001 10CF 89FF 02A0 6040 8D00"
		$"0122 EF8D FF00 DF81 BF04 9F80 7020 0282"
		$"0000 9084 FF05 B336 0000 46DB 89FF 01DF"
		$"2081 0000 9083 FF00 DF80 0000 5881 FF04"
		$"CF68 BFFE FE83 FF00 8080 0001 10EF 83FF"
		$"00BF 8000 00BF 81FF 0170 5A84 FF07 EFA4"
		$"1000 0010 CFEE 83FF 04EF 1000 0052 81FF"
		$"08EF 4220 4040 3F3F 4026 8100 0368 E795"
		$"EF84 FF05 A102 0000 52EF 81FF 0DD3 8060"
		$"403F 3F43 8090 BFEF A354 EF86 FF08 C340"
		$"0000 1050 80AF CF82 FF06 FECF AF7F 4C24"
		$"A28A FF02 BF70 2086 0004 0400 3260 C38F"
		$"FF02 EFBF 9081 8003 A0BF C7DF 88FF 90FF"
		$"01FE DC9B FF03 FCA0 90FE 99FF 03D3 50AF"
		$"8091 FF02 CFA0 7F81 4005 3C24 D8FF 00DF"
		$"8DFF 02ED 8020 8100 0804 1E60 A4FF FFBF"
		$"00BF 8CFF 01CF 0F81 0003 2C80 BEFD 80FF"
		$"03DF 3000 748B FF01 CF10 8000 0110 B082"
		$"FF02 FE94 1080 0000 6C8A FF00 4081 0000"
		$"A480 FF03 F0EF FF7C 8300 00A0 88FF 00DE"
		$"8100 0810 FFFF B8FF C2DF FF5F 8300 002E"
		$"88FF 00BF 8100 0940 FFFF A7ED E7D8 FFF0"
		$"2F83 0088 FF00 DC82 0003 EFFF F6EE 81FF"
		$"01EE 3081 0000 4489 FF00 4C81 000E 6AFD"
		$"FFFF F6DE FDFF FFEF 2000 0008 C589 FF01"
		$"DE10 8100 056A FFFF FEAF 9E80 FF03 8000"
		$"00A0 8BFF 01D2 2081 0004 60FF FFEF B880"
		$"FF02 5410 A48E FF01 9404 8000 00A0 81FF"
		$"03DB 645F EF8C FF08 FDAF 6414 0404 1F80"
		$"EE80 FF01 CEBB 8EFF 01EF 4680 0002 50CE"
		$"FE95 FF00 3E81 0001 4ECE 95FF 00CD 8400"
		$"0310 4044 6880 8001 BFD2 8CFF 01CF 048D"
		$"0002 3894 DF89 FF00 478F 0002 0464 DF88"
		$"FF00 6F90 0001 10CF 88FF 03FE A060 408D"
		$"0001 23ED 86FF 00FE 83FF 00DF 81BF 049C"
		$"8070 2004 8200 0090 83FF 07FE B23C 0000"
		$"48DA FD88 FF01 DF20 8100 0090 83FF 00DF"
		$"8000 0057 81FF 04CF 70BF FCFC 82FF 01FE"
		$"8080 0001 10ED 83FF 00BF 8000 00BF 81FF"
		$"0270 58FD 83FF 07EF A410 0000 10CF EC83"
		$"FF04 EF10 0000 5481 FF08 ED44 2040 403D"
		$"3D40 2881 0003 68E7 9AEF 83FF 06FE A304"
		$"0000 53EF 81FF 0DD2 8060 3E3C 3C45 8090"
		$"BEEE A357 EF86 FF14 C240 0000 1050 80AF"
		$"CFFF FDFF FFFE FCCF AF7A 4C24 A48A FF02"
		$"BE70 1E86 0004 0800 3460 C78E FF03 FDEF"
		$"BF90 8180 04A0 BFCA DFFD 87FF",
		/* [5] */
		'l8mk',
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0005 FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0005 FFFF 0500 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 05FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0005 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0500 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 0005 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0005 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0005 FFFF FFFF FFFF"
		$"FFFF FFFF FF05 0000 0000 0000 0000 0000",
		/* [6] */
		'ich#',
		$"0000 0000 0000 0000 0001 0000 0000 0002"
		$"8000 0000 0002 4000 0000 000C 4000 0000"
		$"1FFC 6000 0001 FFE0 6000 0007 FF00 E000"
		$"000F F801 F000 003F E003 F800 003F 800F"
		$"FC00 007F 800F FC00 007F 091F FE00 007F"
		$"010F FE00 00FF 0887 FE00 007F 8003 FE00"
		$"007F 8001 FC00 003F C000 FC00 003F E0C0"
		$"F000 001F F020 7000 000F F840 C000 0001"
		$"F801 8000 0003 FC0E 0000 000F F000 0000"
		$"007F 0000 0000 007E 0000 0000 00FF 8000"
		$"0000 01FF F690 0000 01FF FFFF 0000 01FF"
		$"FFFF F000 00FF FFFF FC00 007F FFFF FF00"
		$"003F FFFF FF80 0007 FFFF FFC0 0000 5FFF"
		$"FFC0 0000 0001 FFE0 01FC 0000 1FE0 03F0"
		$"0000 1FC0 03E0 1800 1FC0 03E0 3000 1F80"
		$"07E0 1801 FF00 03F0 0FFF FC40 01F8 02FF"
		$"4100 00FC 0000 0E00 007F C000 F800 000F"
		$"FFFF C000 0001 FFFE 0000 0000 0480 0000"
		$"0000 0006 0000 0000 0007 4000 0000 0007"
		$"8000 0000 0007 C000 0000 100F E000 0000"
		$"7FFF E000 0003 FFFF E000 000F FFFF E000"
		$"001F FFFF F000 003F FFFF F800 007F FFFF"
		$"FC00 007F FFFF FE00 00FF FFFF FE00 00FF"
		$"FFFF FE00 00FF FFFF FE00 00FF FFFF FE00"
		$"00FF FFFF FE00 007F FFFF FC00 007F FFFF"
		$"F800 001F FFFF F000 001F FFFF F000 0007"
		$"FFFF C000 0003 FFFE 0000 007F FFFC 0000"
		$"007F FFFE 0000 00FF FFFF 8000 01FF FFFF"
		$"C000 03FF FFFF F800 01FF FFFF FC00 01FF"
		$"FFFF FF00 01FF FFFF FF80 00FF FFFF FFC0"
		$"007F FFFF FFE0 001F FFFF FFF0 0000 FFFF"
		$"FFF0 0043 FFFF FFF0 03FF FFFF FFF0 07FF"
		$"FFFF FFF0 07FF FFFF FFF0 07FF FFFF FFE0"
		$"07FF FFFF FFE0 03FF FFFF FFC0 07FF FFFF"
		$"FF80 01FF FFFF FF00 01FF FFFF FE00 001F"
		$"FFFF F000 0007 FFFF 8000 0000 3FE4 0000",
		/* [7] */
		'ich4',
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00CE 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00DC"
		$"D000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00F0 DD00 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 DAE0"
		$"CFC0 0000 0000 0000 0000 0000 0000 0000"
		$"0CDE EFFF FFFF FE00 0FA0 0000 0000 0000"
		$"0000 0000 0000 00DE FFFF FFFF FFED C000"
		$"CFF0 0000 0000 0000 0000 0000 0000 CFFF"
		$"FFFF FFFF C000 0000 EFF0 0000 0000 0000"
		$"0000 0000 000C FFFF FFFF ECC0 0000 000D"
		$"FFFD 0000 0000 0000 0000 0000 00DF FFFF"
		$"FFD0 0000 0000 0CFF FFFF E000 0000 0000"
		$"0000 0000 0CFF FFFF FD00 0000 0000 EFFF"
		$"FFFF FE00 0000 0000 0000 0000 0AFF FFFF"
		$"F000 0000 C00D FFFF FFFF FFC0 0000 0000"
		$"0000 0000 CFFF FFFF D000 D00D C00D FFFF"
		$"FFFF FFE0 0000 0000 0000 0000 CFFF FFFF"
		$"0000 9007 C00C FFFF FFFF FFF0 0000 0000"
		$"0000 0000 CFFF FFFF 0000 7C00 C000 CAFF"
		$"FFFF FFF0 0000 0000 0000 0000 CFFF FFFF"
		$"D000 0C00 0000 00FF FFFF FFE0 0000 0000"
		$"0000 0000 0FFF FFFF F000 0000 0000 000F"
		$"FFFF FFC0 0000 0000 0000 0000 0DFF FFFF"
		$"FD00 0000 CC00 000C FFFF FE00 0000 0000"
		$"0000 0000 00AF FFFF FFD0 0000 7DD0 0000"
		$"EFFF E000 0000 0000 0000 0000 000E FFFF"
		$"FFFE 0000 0690 0000 DFFE 0000 0000 0000"
		$"0000 0000 000C EFFF FFFF E000 0CC0 000C"
		$"FFDC 0000 0000 0000 0000 0000 0000 0CDF"
		$"FFFF FD00 0000 00DF E000 0000 0000 0000"
		$"0000 0000 0000 00EF FFFF FD00 0000 DED0"
		$"0000 0000 0000 0000 0000 0000 00CD EFFF"
		$"FFAE C000 000C C000 0000 0000 0000 0000"
		$"0000 0000 0DFF FFFE DC00 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 DFFF FFFD"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 000C FFFF FFFE DC00 0000 0000 0000"
		$"0000 0000 0000 0000 0000 000E FFFF FFFF"
		$"FFFE EDED CCDC C000 0000 0000 0000 0000"
		$"0000 000F FFFF FFFF FFFF FFFF FFFF FFFD"
		$"DC00 0000 0000 0000 0000 000E FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFED C000 0000 0000"
		$"0000 000C FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FED0 0000 0000 0000 0000 CFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFA 0000 0000"
		$"0000 0000 0CAF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF EC00 0000 0000 0000 0000 DEAF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FE00 0000"
		$"0000 0000 0000 0000 CDDD EFFF FFFF FFFF"
		$"FFFF FFFF FFC0 0000 0000 0000 0000 0000"
		$"0000 0000 000C CCDD FFFF FFFF FFE0 0000"
		$"0000 00CD EFFF FDC0 0000 0000 0000 0000"
		$"00DF FFFF FFE0 0000 0000 00EF FFFF C000"
		$"0000 0000 0000 0000 000A FFFF FFC0 0000"
		$"0000 0CFF FFFC 0000 000F ECC0 0000 0000"
		$"000E FFFF FF00 0000 0000 0CFF FFF0 0000"
		$"00DF D000 0000 0000 0CDF FFFF A000 0000"
		$"0000 0DFF FFFC 0000 00CF AC00 0000 00CD"
		$"EAFF FFFE 0CC0 0000 0000 00AF FFFE 0000"
		$"0000 EFFF FFFF FFFF FFFF FED0 CD00 0000"
		$"0000 00CF FFFF E000 0000 0CDE EFFF FFFE"
		$"EDDC 00CE D000 0000 0000 000C FFFF FFC0"
		$"0000 0000 0000 0000 000C DFFC 0000 0000"
		$"0000 0000 0DFF FFFF EEDC C000 0000 00CC"
		$"DEEA FD00 0000 0000 0000 0000 000C EFFF"
		$"FFFF FFFF FFFF FFFF FFDC 0000 0000 0000"
		$"0000 0000 0000 00CD FFFF FFFF FFFF FEFD"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"00CC CCDC CD00 0000 0000 0000 0000 0000",
		/* [8] */
		'ich8',
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 F6AC"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 81F6"
		$"FA00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00F5 FF00"
		$"5681 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 FAAC 8100"
		$"2BFF 2B00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"00F8 F9FB FBFF FFFF FFFF FFFE FFAC F500"
		$"00FF FD00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 F9AC"
		$"FFFF FFFF FFFF FFFF FFFF ACFA F600 0000"
		$"2BFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 F8FF FFFF"
		$"FFFF FFFF FFFF FFFF F800 0000 0000 0000"
		$"FBFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00F8 FFFF FFFF"
		$"FFFF FFFF FBF7 F600 0000 0000 0000 F5FA"
		$"FFFF FFFA 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 F9FF FFFF FFFF"
		$"FFFF FA00 0000 0000 0000 0000 00F8 FEFF"
		$"FFFF FFFF 8100 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00F8 FFFF FFFF FFFF"
		$"FFF9 0000 0000 0000 0000 0000 FCFF FFFF"
		$"FFFF FFFF FFFC 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00AC FFFF FFFF FFFF"
		$"FFF6 0000 0000 00F6 F600 00F9 FFFF FFFF"
		$"FFFF FFFF FFFF 2B00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 F5FF FFFF FFFF FFFF"
		$"F900 0000 7A00 007A 4F00 00FA FFFF FFFF"
		$"FFFF FFFF FFFF FB00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 F8FF FFFF FFFF FFFF"
		$"0000 0000 C800 0079 2B00 00F6 FEFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 F8FF FFFF FFFF FFFF"
		$"0000 0000 A5F6 00F5 5500 0000 F6FE FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 2BFF FFFF FFFF FFFF"
		$"FA00 0000 F52A 0000 0000 0000 00F5 FEFF"
		$"FFFF FFFF FFFF FC00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 F6FF"
		$"FFFF FFFF FFFF F800 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00F9 FFFF FFFF FFFF"
		$"FF81 0000 0000 00F5 4FF5 0000 0000 00F6"
		$"FFFF FFFF FFFC 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FDFF FFFF FFFF"
		$"FFFF 8100 0000 0000 55C9 5500 0000 0000"
		$"FBFF FFFF FB00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00AC FFFF FFFF"
		$"FFFF FFAC 0000 0000 25A4 C900 0000 0000"
		$"FBFF FFFD 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00F5 ACFF FFFF"
		$"FFFF FFFF FB00 0000 0055 2B00 0000 00F6"
		$"FEFF 81F5 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00F6 FAFF"
		$"FFFF FFFF FFF9 0000 0000 0000 0000 F9FF"
		$"ACF5 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 FBFE"
		$"FFFF FFFF FFF9 0000 0000 0000 FAFC F900"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 2B56 ACFF FFFF"
		$"FFFF FEFB 2B00 0000 0000 00F6 F800 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FA FFFF FFFF FFFD"
		$"F92B 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FAFF FFFF FFFF FFF8"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00F6 FFFF FFFF FFFF FFFE"
		$"F92B 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FD FFFF FFFF FFFF FFFF"
		$"FFFF FFFB FBFB FB56 F8F8 F8F8 F600 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFF9"
		$"FAF6 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00AC FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF AC81 2B00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00F6 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFAC 5600 0000 0000 0000 0000"
		$"0000 0000 0000 0000 F8FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFD 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00F8 FDFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FDF5 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 56FB FEFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFAC 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"2BFA F9FA FDFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF F800 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00F5 F8F8 F8FB"
		$"FDFF FFFF FFFF FFFF FFFF FB00 0000 0000"
		$"0000 0000 0000 F5FA FCFF FFFF FFFA F500"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"00F5 FAFF FFFF FFFF FFFF FB00 0000 0000"
		$"0000 0000 0000 ACFF FFFF FFFF F600 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FD FFFF FFFF FFFF F800 0000 0000"
		$"0000 0000 002B FFFF FFFF FF56 0000 0000"
		$"0000 F5FD FCF8 F600 0000 0000 0000 0000"
		$"0000 00FB FFFF FFFF FFFE 0000 0000 0000"
		$"0000 0000 00F8 FFFF FFFF FF00 0000 0000"
		$"0000 F9FF 5600 0000 0000 0000 0000 0000"
		$"00F6 F9FF FFFF FFFF FDF5 0000 0000 0000"
		$"0000 0000 00F8 FFFF FFFF FFF6 0000 0000"
		$"0000 F6FF FFF8 0000 0000 0000 0000 F6F9"
		$"FBFF FFFF FFFF FFFC 00F6 F800 0000 0000"
		$"0000 0000 0000 FEFF FFFF FFFB 0000 0000"
		$"0000 00F6 FCFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFD 5600 F6FA 0000 0000 0000"
		$"0000 0000 0000 F7FF FFFF FFFF FBF6 0000"
		$"0000 0000 002B FAFB ACFF FFFF FFFF FFAC"
		$"FBFB F8F8 0000 F6AC FA00 0000 0000 0000"
		$"0000 0000 0000 002B FFFF FFFF FFFF F800"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00F6 F9FF FFF8 0000 0000 0000 0000"
		$"0000 0000 0000 0000 F581 FFFF FFFF FFFF"
		$"FBFB F9F8 2B00 0000 0000 0000 0000 2BF8"
		$"F9FB FBFF FDF9 F500 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00F9 FBFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFE 812B 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 F8FA"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFD FDF9"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 2BF8 F8F8 F8F8 F8F8 F500 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000",
		/* [9] */
		'ih32',
		$"CBFF 01D5 40AB FF02 71D5 71A9 FF04 E300"
		$"FF8E 71A7 FF06 8035 60FF D500 C09B FF03"
		$"AA8E 5555 8300 070E 0B39 E6FF FF00 2B98"
		$"FF01 8E39 8700 0239 75D5 80FF 02C6 0000"
		$"96FF 00AA 8700 010B AA84 FF02 5500 0095"
		$"FF00 AA85 0002 4EB5 D584 FF01 E380 8000"
		$"0075 93FF 0080 8400 0071 87FF 01AA 1C82"
		$"0000 6091 FF00 AA84 0000 8087 FF00 5085"
		$"0000 4090 FF00 3983 0001 06E3 82FF 04D0"
		$"CDFF FF87 8700 00C6 8EFF 00E3 8400 0080"
		$"80FF 076A FFFF 6DB5 FFFF 7187 0000 558E"
		$"FF00 AA84 0081 FF08 20FF FF6A B5FF FFD5"
		$"1087 008E FF00 AA84 0081 FF04 39CD FFE6"
		$"9C80 FF01 D51C 8600 8EFF 00C6 8400 0080"
		$"80FF 01E6 CE84 FF01 E31C 8400 0040 8FFF"
		$"000B 8400 8AFF 00D5 8400 00AA 8FFF 007F"
		$"8400 006A 82FF 02E6 B5DA 82FF 00D5 8200"
		$"0045 91FF 002B 8400 006A 82FF 0283 2083"
		$"82FF 0055 8000 0055 93FF 002B 8400 0040"
		$"81FF 02DA 2020 82FF 0355 0000 2B94 FF01"
		$"E639 8400 0055 81FF 0190 B581 FF04 D523"
		$"005B E396 FF01 D571 8300 008E 85FF 0391"
		$"0639 E399 FF01 600B 8200 0080 83FF 0280"
		$"4080 98FF 02D5 8E40 8100 0307 1C55 C683"
		$"FF01 E3AA 99FF 0079 8200 021C 80C6 A3FF"
		$"0080 8300 00AA A4FF 00D5 8400 021C 80C6"
		$"A2FF 002B 8800 8055 015B 9C81 AA00 D597"
		$"FF94 0003 0580 80D5 92FF 0030 9600 0307"
		$"3575 C68F FF01 DA04 9900 0135 918E FF00"
		$"AA9B 0000 2B8E FF01 AA2B 9A00 012B E38F"
		$"FF02 8E55 1C97 0000 3C93 FF00 C080 8000"
		$"2B92 0000 AA9D FF00 E380 AA02 551C 0485"
		$"0000 5588 FF02 E380 4380 0002 0B6B EA8F"
		$"FF01 E380 8400 0055 88FF 0035 8200 00D5"
		$"93FF 002B 8300 00AA 87FF 00C6 8200 009C"
		$"83FF 04E3 2B47 AAD5 89FF 0055 8200 001C"
		$"88FF 00AA 8200 84FF 028E 0098 89FF 01E3"
		$"8082 0001 2BE3 88FF 00AA 8200 00DA 83FF"
		$"03D5 000B AA85 FF03 DF88 550B 8200 0340"
		$"FFD5 AA88 FF00 1C81 0000 5584 FF01 D53C"
		$"8D00 042B 9CFF DA78 89FF 00AE 8200 0155"
		$"DA84 FF03 CD80 5539 8300 0935 5555 AAAA"
		$"FFFF CD40 808B FF01 C80B 8200 00AA 91FF"
		$"04DF 8000 05AA 8DFF 01E3 7183 0004 5555"
		$"8EAA C686 FF08 C6AA 8E55 550E 2380 E391"
		$"FF01 8E55 9000 0304 1C60 C697 FF01 AA80"
		$"8A00 0220 2B80 9FFF 00C6 84AA 00E3 92FF"
		$"CAFF 04FE D340 FFFE A9FF 0271 D571 A9FF"
		$"04E3 00FF 8E71 9EFF 00FE 85FF 0680 355F"
		$"FFD5 00C0 9BFF 03AA 8E55 5583 0007 0E0B"
		$"39E5 FFFF 002B 98FF 018E 3987 0002 3975"
		$"D580 FF02 C600 0096 FF00 A887 0002 0BA9"
		$"FD83 FF02 5500 0095 FF00 AA85 0002 4EB3"
		$"D484 FF01 E380 8000 0075 93FF 0080 8400"
		$"0071 87FF 01AA 1C82 0000 6091 FF00 AA84"
		$"0000 8087 FF00 4F85 0000 4090 FF00 3983"
		$"0001 06E3 82FF 04DC DCFF FF87 8700 00C6"
		$"8EFF 00E2 8400 0080 80FF 0795 FFFF 97CA"
		$"FFFF 7187 0000 548E FF00 AA84 0081 FF08"
		$"60FE FF95 CAFF FFD3 1087 008E FF00 AA84"
		$"0081 FF09 72DC FFED B8FF FFFE D41C 8600"
		$"8EFF 00C6 8400 0080 80FF 01ED DB84 FF01"
		$"E31C 8400 0040 8EFF 01FE 0B84 008A FF00"
		$"D584 0000 A98F FF00 7F84 0001 69FE 81FF"
		$"03ED C9E5 FE81 FF00 D582 0000 4591 FF00"
		$"2B84 0000 6982 FF02 A660 A682 FF00 5580"
		$"0000 5593 FF00 2B84 0000 4081 FF02 E560"
		$"6082 FF03 5500 002B 94FF 01E6 3984 0000"
		$"5581 FF01 B0CA 81FF 04D5 2300 5BE3 96FF"
		$"01D5 7183 0000 8E85 FF03 8F06 38E3 99FF"
		$"0160 0B82 0000 8083 FF02 8040 8097 FF03"
		$"FED4 8E40 8100 0307 1C55 C683 FF01 E2AA"
		$"99FF 0077 8200 021C 7FC6 A3FF 0080 8300"
		$"00AA A4FF 00D3 8400 021C 7FC6 A2FF 002A"
		$"8800 8055 015B 9C81 AA02 D5FF FE95 FF94"
		$"0003 0580 80D5 92FF 0030 9600 0307 3575"
		$"C68F FF01 D904 9900 0135 918E FF00 AA9B"
		$"0000 2B8E FF01 AA2B 9A00 012B E38F FF02"
		$"8E55 1C97 0000 3C93 FF00 C080 8000 2B92"
		$"0000 A99D FF00 E180 AA02 551C 0485 0000"
		$"5588 FF02 E280 4380 0003 0B6B E9FE 8EFF"
		$"01E3 8084 0000 5587 FF01 FE35 8200 00D5"
		$"87FF 01FE FE87 FF00 2B83 0000 AA87 FF00"
		$"C682 0000 9C83 FF06 E32B 47AA D5FE FE87"
		$"FF00 5582 0001 1CFE 87FF 00AA 8200 84FF"
		$"028E 0098 89FF 01E3 8082 0002 2BE3 FE87"
		$"FF00 AA82 0000 DA83 FF03 D500 0BAA 81FF"
		$"07FD FDFF FFDF 8855 0B82 0003 40FF D5AA"
		$"88FF 001C 8100 0055 83FF 02FE D53C 8D00"
		$"042B 9CFF D978 89FF 00AD 8200 0155 D984"
		$"FF03 CD7F 5539 8300 0935 5555 AAAA FFFF"
		$"CD40 808B FF01 C70B 8200 00AA 88FF 00FE"
		$"81FD 08FF FFFE FEDF 8000 05AA 8DFF 01E3"
		$"7183 0007 5555 8EAA C6FF FFFE 81FF 0AFE"
		$"FEC6 AA8E 5455 0E23 80E3 91FF 018D 5590"
		$"0003 041C 60C6 96FF 02FD A980 8A00 0320"
		$"2B7F FE9E FF00 C684 AA03 E3FF FFFE 8FFF"
		$"9AFF 01FD FDAB FF04 FAD0 40FF FDA8 FF03"
		$"FD71 D571 A9FF 04E3 00FF 8E71 9EFF 00FC"
		$"85FF 0680 3568 FFD5 00C0 9BFF 03AA 8E55"
		$"5583 0007 150B 39E5 FFFF 002B 98FF 018E"
		$"3987 0002 3978 D580 FF02 C600 0096 FF00"
		$"A387 0002 0BA5 F883 FF02 5500 0095 FF00"
		$"AA85 0003 4EAA D2FD 83FF 01E3 8080 0000"
		$"7893 FF00 8084 0000 7187 FF01 AA1C 8200"
		$"006A 91FF 00AA 8400 0080 87FF 004C 8500"
		$"0040 90FF 0039 8300 010B E382 FF04 E4E3"
		$"FFFF 8787 0000 C68E FF00 DF84 0000 8080"
		$"FF07 AAFF FFAE D5FF FF70 8700 0052 8EFF"
		$"00AA 8400 81FF 0880 FAFF AAD5 FFFF D010"
		$"8700 8EFF 00AA 8400 80FF 0AFD 8EE3 FFEF"
		$"C6FF FFFC D21C 8600 8EFF 00C3 8400 0080"
		$"80FF 01EF E183 FF02 FDE3 1C84 0000 408E"
		$"FF01 FA0B 8400 8AFF 00D5 8400 00A8 8FFF"
		$"007F 8400 0167 FC81 FF03 EFD2 EAFC 81FF"
		$"00D5 8200 0053 90FF 01FD 2B84 0000 6781"
		$"FF03 FDB7 80B5 82FF 0055 8000 0055 93FF"
		$"002B 8400 0040 81FF 02EA 8080 82FF 0355"
		$"0000 2B94 FF01 E839 8400 0055 81FF 01C0"
		$"D581 FF04 D523 0060 E396 FF01 D571 8300"
		$"008E 85FF 038E 0B37 E399 FF01 6B15 8200"
		$"0080 83FF 0280 4080 97FF 03FC D28E 4081"
		$"0004 071C 53C6 FD82 FF02 E1AA FD98 FF00"
		$"7C82 0004 1C7D C6FF FDA1 FF00 8083 0000"
		$"AAA4 FF00 D084 0002 1B7D C5A1 FF01 FD28"
		$"8800 8055 0160 9C81 AA02 D5FF FC95 FF94"
		$"0003 0B80 80D5 92FF 0035 9600 0307 3578"
		$"C68F FF01 DD07 9900 0135 958E FF00 AA9B"
		$"0000 2B8E FF01 A82B 9A00 012B E38E FF03"
		$"FD8E 551C 9700 013E FD92 FF00 C080 8000"
		$"2B92 0000 A88B FF00 FD8E FF00 DC80 AA02"
		$"551C 0785 0000 5588 FF02 E180 4E80 0003"
		$"0E6B E6FC 8EFF 01E3 8084 0000 5587 FF01"
		$"FD33 8200 00D5 87FF 01FD FD87 FF00 2B83"
		$"0000 AA87 FF00 C682 0000 9A83 FF06 E32B"
		$"55AA D5FC FC85 FF02 FDFF 5582 0001 1CFC"
		$"87FF 00AA 8200 84FF 038E 0095 FD88 FF01"
		$"E380 8200 022B E3FA 87FF 00AA 8200 00DF"
		$"83FF 03D5 000B A881 FF07 F8F8 FFFF DF90"
		$"550B 8200 0340 FFD5 AA88 FF00 1C81 0000"
		$"5583 FF02 FCD5 408D 0004 2B9C FFDD 7E88"
		$"FF01 FDAF 8200 0155 DD84 FF03 CD7D 5539"
		$"8300 0940 5555 A8AA FDFD CD47 808B FF01"
		$"CC0B 8200 00AA 88FF 00FA 81F8 08FF FFFA"
		$"FCDF 8000 0BA8 8CFF 02FD E371 8300 0755"
		$"558E AAC6 FFFF FC81 FF0A FAFC C6AA 8E52"
		$"530E 2380 E391 FF01 8C55 9000 0307 1C6B"
		$"C696 FF02 F8A5 808A 0003 352B 7CFD 9EFF"
		$"00C6 84AA 03E3 FFFF FC8F FF",
		/* [10] */
		'h8mk',
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0005 0500"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0005 FFFF"
		$"0005 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0005 FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0005 0000 0000 0000 0000 FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 05FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0005 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00DB FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0005 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF05 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 05FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 00DB FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 0000 0000 0000 0005 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 0000 0005 0000 0000 FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0005 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0005 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 00DB FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0005 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0005 FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"0500 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FF00 0005 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000",
		/* [11] */
		'ics#',
		$"0000 00A0 0F10 1C78 1878 1C18 0E20 0600"
		$"1800 3FD0 1FF8 057C 300C 3358 18A8 0340"
		$"0070 07F0 1FF0 1FF8 3FF8 3FF8 1FF8 1FF0"
		$"3FF0 3FFC 3FFE 1FFE 7FFE 7FFE 7FFC 1FF0",
		/* [12] */
		'ics4',
		$"0000 0000 00C0 0000 0000 00CD CDCD 0000"
		$"0000 EFFD D0CE 0000 000E FA00 0DFF D000"
		$"000F FDCC 0EFF F000 000F FE00 00EF E000"
		$"000C FFD0 D0CE 0000 0000 DFF0 0CC0 0000"
		$"00CF FD00 0000 0000 00DF FFFA EEDD 0000"
		$"00CA FFFF FFFF FC00 0000 CDDE DEEF FFC0"
		$"00EF C0C0 000C FF00 00FE 00DD CDDF AD00"
		$"00DF DCC0 DCDD D000 0000 DDEE EDDC 0000",
		/* [13] */
		'ics8',
		$"0000 0000 0000 0000 0000 2B00 0000 0000"
		$"0000 0000 0000 2B56 F8F9 F856 0000 0000"
		$"0000 0000 FBFF FFFB 56F5 F7FC 0000 0000"
		$"0000 00FC FFFD F500 00F9 FFFF F900 0000"
		$"0000 F5FF FF56 2B2A F6FB FFFF FF00 0000"
		$"0000 00FE FFFB 00F5 0000 FBFF FC00 0000"
		$"0000 00F8 FFFF FA00 7900 F7FD F500 0000"
		$"0000 00F5 F9FF FDF6 00F6 F800 0000 0000"
		$"0000 2BEA FF56 0000 0000 0000 0000 0000"
		$"0000 81FF FFFF FEFD FCFC FAF8 0000 0000"
		$"0000 F6FE FFFF FFFF FFFF FFFF FEF7 0000"
		$"0000 0000 2B56 FA81 81FC FDFF FFFF F600"
		$"0000 ACFE 2B00 2BF5 0000 00F8 FFFF F500"
		$"00F5 FFFC 0000 FA56 56F8 F9FD FE56 F500"
		$"0000 56E0 FBF7 F6F6 F856 56F9 56F6 0000"
		$"0000 0000 F881 FCAC FC81 FA2B 0000 0000",
		/* [14] */
		'is32',
		$"87FF 00C3 87FF 06F3 C79F 9F8C B598 84FF"
		$"08F3 6008 0B53 9FE8 B34C 84FF 0948 002C"
		$"EBF8 F884 0400 8182 FF0A E700 0093 B9D2"
		$"E061 0000 0C82 FF0A F713 0057 FCF5 F1FB"
		$"5000 4383 FF09 B008 0073 FF8C FFB4 2DE7"
		$"83FF 08EB 8202 28E3 FFD9 B0FB 83FF 03CB"
		$"1100 9089 FF00 6880 0006 142B 4050 75B2"
		$"F782 FF01 D01C 8500 011A AF83 FF13 BF90"
		$"7860 6048 2401 0009 DFFF FFF7 3B16 C8FF"
		$"CDEF 80FF 139F 0004 DFFF FFEB 0444 FFFF"
		$"7F97 9F9F 852D 1A97 F780 FF0B 9A10 54B3"
		$"DFD4 A79F 9187 96D0 82FF 08EF A36C 4440"
		$"4863 84C8 81FF 87FF 00C3 87FF 06F3 C79F"
		$"9F8C B598 84FF 08F3 6008 0B52 9FE8 B34C"
		$"84FF 0948 002C EBFA FA84 0400 8182 FF0A"
		$"E700 0093 CDDF E960 0000 0C82 FF0A F713"
		$"0057 FCF8 F5FB 5000 4383 FF09 B008 0072"
		$"FFAD FFB4 2DE7 83FF 08EB 8202 28E3 FFD9"
		$"B0FB 83FF 03CB 1100 8F89 FF00 6880 0006"
		$"142B 4050 74B2 F782 FF01 D01C 8500 011A"
		$"AF83 FF13 BF90 7860 6048 2401 0008 DFFF"
		$"FFF7 3A16 C8FF CDEF 80FF 139F 0004 DFFF"
		$"FFEB 0444 FFFF 7F97 9F9F 852D 1A97 F780"
		$"FF0B 9910 54B3 DFD4 A79F 9086 96D0 82FF"
		$"08EF A36C 4440 4863 84C8 81FF 86FF 01FE"
		$"C287 FF06 F3C7 9F9F 8DB6 9884 FF08 F35F"
		$"080B 519F E8B3 4D84 FF09 4800 2DEB FBFB"
		$"8304 0083 82FF 0AE7 0000 93D7 E5ED 5F00"
		$"000C 82FF 0AF6 1300 56FC F9F6 FB50 0044"
		$"83FF 09B0 0800 72FF BDFF B42D E783 FF08"
		$"EA83 0328 E3FF D9B0 FB83 FF03 CB12 008F"
		$"89FF 0068 8000 0614 2B40 5075 B2F7 82FF"
		$"01D1 1C85 0001 1AAF 83FF 2ABF 9078 6060"
		$"4724 0100 09DF FFFF F73C 16C8 FFCF EEFE"
		$"FFFF 9F00 04DF FFFF EB04 45FF FF7E 979F"
		$"9F86 2D1A 98F6 80FF 0B9A 1055 B3DF D3A7"
		$"9D91 8596 D182 FF08 EFA3 6C44 4048 6584"
		$"C981 FF",
		/* [15] */
		's8mk',
		$"0000 0000 0000 0000 0005 FF05 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0005 FFFF FFFF FFFF FFFF FFFF FF00"
		$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0005 FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF 0000 0000",
		/* [16] */
		'icm#',
		$"0000 0350 1C30 1C78 1C10 0620 1900 3FF8"
		$"0B7C 300C 31B0 0720 0070 0FF0 1FF8 3FF8"
		$"3FF8 1FF0 3FF8 3FFC 1FFE 7FFE 7FFE 3FF8",
		/* [17] */
		'icm4',
		$"0000 0000 00C0 0000 0000 CDEE ECCE 0000"
		$"000D FAC0 0DEF C000 000F FD0C 0DFF F000"
		$"000E FFC0 C0DF C000 0000 DFEC 00CC 0000"
		$"00CF FDC0 C000 0000 00DF FFFF FFFE D000"
		$"000C DDEE EEFF FF00 00AE C0C0 000D FEC0"
		$"00FE C0CD DEDE DC00 000C DDED DDDC C000",
		/* [18] */
		'icm8',
		$"0000 0000 0000 0000 0000 F800 0000 0000"
		$"0000 0000 2BFA FBAC 8156 F681 0000 0000"
		$"0000 00FA FFFD F7F5 0056 FDFF F800 0000"
		$"0000 F5FF FF56 2B2A F556 FFFF FF00 0000"
		$"0000 00FB FFFE F600 4F00 56FF F800 0000"
		$"0000 00F5 81EA FEF5 00F6 F8F6 0000 0000"
		$"0000 F8FF FFFA 2BF6 F600 0000 0000 0000"
		$"0000 56FF FFFF FFFF FFFF E0FC F9F5 0000"
		$"0000 00F6 F981 FBFC FCAC FDFF FFFD F500"
		$"0000 FDFD F600 F700 0000 0056 FFFE F500"
		$"0000 ACFE 2B00 F7F9 8181 FBFB 81F7 0000"
		$"0000 00F7 FAFB FBFA FAF9 56F8 F600 0000",
		/* [19] */
		'it32',
		$"0000 0000 FFFF FFFF FFFF C9FF 0100 00FC"
		$"FF01 0000 F8FF 0000 80FF 0100 00F7 FF01"
		$"0000 80FF 0100 00F6 FF01 0000 81FF 0100"
		$"00F5 FF80 0080 FF80 00F4 FF80 0081 FF80"
		$"00F2 FF81 0081 FF80 00F1 FF00 4080 0082"
		$"FF81 00ED FF82 0001 2020 83FF 8100 D9FF"
		$"8D00 0240 2020 8200 0020 84FF 8100 D3FF"
		$"9B00 85FF 8200 CDFF 9C00 0140 0087 FF82"
		$"00CA FF9F 0089 FF82 00C7 FF9E 0001 2000"
		$"8AFF 8300 C5FF 9E00 8EFF 8300 C3FF 9800"
		$"0040 8000 91FF 8400 C1FF 9C00 93FF 8400"
		$"C0FF 9700 0160 0096 FF85 00BF FF93 0002"
		$"4040 0099 FF88 00BC FF94 0000 4099 FF89"
		$"0001 2000 BAFF 9300 9BFF 8C00 0020 B8FF"
		$"9300 9AFF 9000 B6FF 9200 9BFF 9000 0120"
		$"20B4 FF92 009A FF00 4094 00B3 FF91 009A"
		$"FF97 00B1 FF92 0099 FF00 4097 00B1 FF91"
		$"0090 FF00 2085 FF01 4040 9800 AFFF 9100"
		$"0020 8EFF 023A 2020 85FF 9A00 AFFF 9100"
		$"88FF 0020 83FF 8020 85FF 9B00 AEFF 9100"
		$"87FF 0120 2083 FF80 2085 FF9B 00AD FF92"
		$"0086 FF80 2083 FF02 203A 2086 FF9A 00AD"
		$"FF91 0087 FF80 2083 FF80 2086 FF9B 00AC"
		$"FF91 0087 FF80 2083 FF80 2087 FF00 4099"
		$"00AC FF91 0087 FF80 2084 FF80 2087 FF99"
		$"00AC FF91 0087 FF81 2084 FF01 2020 88FF"
		$"9800 ACFF 9100 88FF 8020 92FF 9700 ACFF"
		$"9200 88FF 8020 92FF 9600 ACFF 9200 A1FF"
		$"9200 0140 00AE FF91 00A2 FF93 00AE FF92"
		$"00A2 FF91 00AF FF00 4091 00A3 FF90 00B0"
		$"FF92 00A3 FF8D 0000 60B1 FF01 4040 9000"
		$"0040 A3FF 8B00 0120 00B2 FF91 0001 4040"
		$"8CFF 8220 8EFF 8B00 0020 B4FF 9300 8DFF"
		$"8220 8DFF 8A00 B5FF 9300 0040 8CFF 8320"
		$"8CFF 8900 B7FF 9200 0140 408C FF82 208C"
		$"FF88 00B9 FF94 008B FF83 208B FF87 00BB"
		$"FF94 008B FF82 208B FF86 00BD FF00 2093"
		$"008A FF81 208C FF85 00BF FF94 008A FF01"
		$"2020 8CFF 0040 8300 0020 C2FF 9300 99FF"
		$"8400 C6FF 9200 97FF 8300 CAFF 9000 96FF"
		$"8300 CDFF 8F00 93FF 0500 2000 2000 00CE"
		$"FF01 2020 8E00 90FF 8040 8000 CFFF 0300"
		$"0020 208D 008F FF01 0000 8040 CFFF 0040"
		$"9100 90FF 8000 CFFF 9300 E4FF 8E00 0040"
		$"8100 E6FF 9100 E7FF 0120 208E 00E9 FF8F"
		$"00EA FF8F 00EA FF90 00E9 FF92 00E8 FF94"
		$"00E5 FF98 00E2 FF9C 00DD FFA8 00D2 FFA5"
		$"0004 2000 0040 4089 00C4 FFBC 0000 20BD"
		$"FFC3 00B7 FFC4 0001 4040 B4FF C800 0020"
		$"B2FF 0020 CA00 AFFF 0020 CB00 0040 AEFF"
		$"CD00 0020 ACFF 0020 CF00 ABFF D100 ABFF"
		$"D000 ABFF D000 ABFF D000 ACFF CF00 AFFF"
		$"CB00 0020 B0FF CA00 B4FF C700 B9FF C200"
		$"C2FF B800 D6FF A500 DEFF 9C00 E1FF 0200"
		$"0020 9600 A2FF 0020 8900 0140 40B1 FF95"
		$"009F FF03 0000 2020 8900 0040 B4FF 9300"
		$"9DFF 8D00 0060 B7FF 9200 9CFF 0040 8C00"
		$"B9FF 9100 9CFF 8D00 BBFF 9000 9CFF 8C00"
		$"92FF 0200 2020 8200 9FFF 8F00 9CFF 8B00"
		$"0020 92FF 0400 0020 2000 A3FF 8F00 9CFF"
		$"8B00 0060 91FF 8100 A5FF 8E00 9DFF 8B00"
		$"92FF 8100 A4FF 8E00 9EFF 8B00 91FF 8100"
		$"0060 A3FF 8E00 9FFF 8B00 92FF 8200 A0FF"
		$"8F00 A0FF 8B00 92FF 8200 0040 9CFF 0100"
		$"408F 0082 FF00 009B FF8B 0000 2092 FF84"
		$"0095 FF01 4020 9100 0140 4082 FF01 0000"
		$"9CFF 8B00 93FF AE00 0240 4000 83FF 0100"
		$"009D FF8C 0093 FF01 0020 AC00 84FF 0120"
		$"009F FF8C 0094 FFAA 0085 FF01 2020 A0FF"
		$"0020 8C00 95FF 0100 40A2 0087 FF80 00A2"
		$"FF8D 0097 FF94 0000 2084 008A FF03 0000"
		$"2000 A4FF 8D00 0020 9BFF 8E00 0020 8FFF"
		$"0400 4000 0020 A6FF 0020 8D00 BBFF 8400"
		$"A8FF 0040 8E00 B5FF 0040 8300 0120 00AC"
		$"FF91 00AF FF02 0040 4083 00B0 FF95 00A3"
		$"FF8A 00B4 FF99 0097 FF8C 0001 4000 B8FF"
		$"BC00 0220 0000 BDFF BA00 0020 C3FF B000"
		$"0020 8000 C9FF A400 0120 2083 00D3 FF9F"
		$"0004 2020 4000 00DC FF92 00FF FFFF FFB3"
		$"FFFF FFCA FF00 FBFD FF00 FBFC FF03 FBFB"
		$"0000 F6FF 01FB FB81 FF01 0000 80FF 00FB"
		$"F4FF 0000 80FF 0100 00F7 FF01 0000 80FF"
		$"0100 00F5 FF02 FB00 0081 FF01 0000 F5FF"
		$"8000 80FF 8000 F4FF 8000 81FF 8000 F2FF"
		$"8100 81FF 8000 F1FF 0040 8000 82FF 8100"
		$"D6FF 00FB 93FF 8200 0220 20FB 82FF 8100"
		$"D9FF 8D00 0240 2020 8200 0220 FFFB 82FF"
		$"8100 D3FF 9B00 01FB FB83 FF82 00CD FF9C"
		$"0001 4000 87FF 8200 CAFF 9F00 89FF 8200"
		$"C7FF 9E00 0120 008A FF83 00C5 FF9E 008E"
		$"FF83 00C0 FF02 FBFB FF98 0000 4080 0001"
		$"FBFB 8FFF 8400 C0FF 00FB 9C00 03FF FFFB"
		$"FB8F FF84 00C0 FF97 0003 6000 FBFB 94FF"
		$"8500 BFFF 9300 0440 4000 FBFB 97FF 8800"
		$"BCFF 9400 0440 FFFF FBFB 95FF 8900 0120"
		$"00BA FF93 009B FF8C 0000 20B8 FF93 009A"
		$"FF90 00B6 FF92 009B FF90 0001 2020 B4FF"
		$"9200 99FF 01FB 4094 00B3 FF91 009A FF97"
		$"00B1 FF92 008D FF00 FB88 FF00 4097 00B1"
		$"FF91 008E FF02 FBFF 6085 FF01 4040 9800"
		$"AFFF 9100 0020 8EFF 026E 6060 85FF 9A00"
		$"ADFF 01FB FF91 0088 FF00 6083 FF80 6085"
		$"FF9B 0000 FBAB FF01 FBFF 9100 87FF 0160"
		$"6083 FF80 6085 FF9B 0000 FBAC FF92 0086"
		$"FF80 6083 FF02 606E 6084 FF01 FBFF 9A00"
		$"ADFF 9100 87FF 8060 83FF 8060 86FF 9B00"
		$"ACFF 9100 87FF 8060 01FB FB81 FF80 6085"
		$"FF02 FBFB 4099 00AC FF91 0087 FF80 6084"
		$"FF80 6084 FF02 FBFB FF99 00AC FF91 0086"
		$"FF00 FB81 6082 FF03 FBFF 6060 88FF 9800"
		$"ACFF 9100 88FF 8060 90FF 01FB FF97 00AC"
		$"FF92 0088 FF80 608F FF02 FBFF FF96 00AC"
		$"FF92 0088 FF03 FBFF FFFB 92FF 9200 0140"
		$"00AC FF01 FBFB 9100 A2FF 9300 ACFF 01FB"
		$"FB92 00A2 FF91 00AF FF00 4091 00A3 FF90"
		$"0000 FBAF FF92 0001 FBFB 8CFF 80FB 8FFF"
		$"8D00 0060 B1FF 0140 4090 0002 40FF FB91"
		$"FF00 FB8C FF8B 0001 2000 B2FF 9100 0240"
		$"40FB 8BFF 8260 01FF FB8C FF8B 0001 20FB"
		$"B1FF 01FB FF93 0001 FBFB 89FF 01FB FF82"
		$"6001 FBFB 8BFF 8A00 B5FF 9300 0040 8CFF"
		$"8360 8CFF 8900 B7FF 9200 0140 408B FF00"
		$"FB82 608C FF88 00B9 FF94 008B FF83 608B"
		$"FF87 00BB FF94 008B FF82 608B FF86 00BD"
		$"FF00 2093 008A FF81 608C FF85 00BE FF00"
		$"FB94 008A FF01 6060 8CFF 0040 8300 0020"
		$"C2FF 9300 99FF 8400 C6FF 9200 94FF 02FB"
		$"FBFF 8300 CAFF 9000 94FF 01FB FB83 00CD"
		$"FF8F 0093 FF06 0020 0020 0000 FBCD FF01"
		$"2020 8E00 90FF 8040 8000 CFFF 0300 0020"
		$"208D 008F FF01 0000 8040 CFFF 0040 9100"
		$"80FF 00FB 8AFF 01FB FF80 0001 FFFB CAFF"
		$"02FB FFFF 9300 E1FF 02FB FBFF 8E00 0040"
		$"8100 01FF FBE2 FF01 FBFB 9100 81FF 00FB"
		$"E2FF 0120 208E 0000 FBE8 FF8F 00EA FF8F"
		$"00EA FF90 00E8 FF00 FB92 0001 FBFB E5FF"
		$"00FB 9400 E5FF 9800 00FB DFFF 01FB FB9C"
		$"00DD FFA8 008F FF01 FBFB BEFF A500 0420"
		$"0000 4040 8900 C4FF BC00 0020 BDFF C300"
		$"B7FF C400 0140 40B4 FFC8 0000 20B2 FF00"
		$"20CA 00AF FF00 20CB 0000 40AE FFCD 0000"
		$"20AB FF01 FB20 CF00 ABFF D100 ABFF D000"
		$"ABFF D000 ABFF D000 A8FF 00FB 80FF CF00"
		$"AFFF CB00 0220 FBFB AEFF CA00 ABFF 00FB"
		$"85FF C700 B9FF C200 00FB C1FF B800 D4FF"
		$"01FB FBA5 00D3 FF01 FBFB 86FF 9C00 A3FF"
		$"00FB BAFF 0200 0020 9600 A2FF 0020 8900"
		$"0440 40FF FBFB AEFF 9500 9FFF 0300 0020"
		$"2089 0004 40FF FFFB FBB0 FF93 009C FF00"
		$"FB8D 0000 60B7 FF92 009A FF02 FBFB 408C"
		$"00B9 FF91 009C FF8D 009C FF01 FBFB 9AFF"
		$"9000 9CFF 8C00 92FF 0200 2020 8200 80FF"
		$"01FB FB9A FF8F 009C FF8B 0002 20FF FB90"
		$"FF04 0000 2020 0084 FF01 FBFB 9AFF 8F00"
		$"00FB 9BFF 8B00 0060 91FF 8100 A1FF 00FB"
		$"80FF 8E00 80FF 00FB 99FF 8B00 92FF 8100"
		$"A4FF 8E00 81FF 00FB 99FF 8B00 91FF 8100"
		$"0060 A3FF 8E00 81FF 01FB FB99 FF8B 0092"
		$"FF82 0080 FF00 FB9C FF8F 00A0 FF8B 0092"
		$"FF82 0003 40FF FFFB 99FF 0100 408F 0082"
		$"FF00 009B FF8B 0000 2092 FF84 0088 FF83"
		$"FB84 FF01 4020 9100 0140 4082 FF01 0000"
		$"9CFF 8B00 90FF 02FB FBFF AE00 0240 4000"
		$"81FF 03FB FB00 009D FF8C 0093 FF01 0020"
		$"AC00 84FF 0120 009F FF8C 0094 FFAA 0085"
		$"FF01 2020 9EFF 02FB FB20 8C00 02FF FFFB"
		$"92FF 0100 40A2 0002 FFFF FB84 FF80 00A2"
		$"FF8D 0096 FF00 FB94 0000 2084 0001 FFFB"
		$"84FF 00FB 80FF 0300 0020 00A4 FF8D 0000"
		$"209B FF8E 0000 208F FF04 0040 0000 20A6"
		$"FF00 208D 009E FF8A FB8D FF84 0000 FBA6"
		$"FF01 FB40 8E00 AFFF 80FB 80FF 0040 8300"
		$"0120 00A9 FF02 FBFF FF91 00AB FF80 FB03"
		$"FF00 4040 8300 B0FF 9500 89FF 01FB FB89"
		$"FF81 FB85 FF8A 00B4 FF99 0097 FF8C 0001"
		$"4000 B8FF BC00 0220 0000 BDFF BA00 0020"
		$"BFFF 00FB 80FF B000 0020 8000 C7FF 01FB"
		$"FBA4 0001 2020 8300 CCFF 01FB FB82 FF9F"
		$"0008 2020 4000 00FF FFFB FBD8 FF92 0084"
		$"FF01 FBFB FFFF FFFF AAFF FFFF CAFF 00F0"
		$"FDFF 00F0 FCFF 03F0 F000 00F6 FF01 F0F0"
		$"81FF 0100 0080 FF00 F0F4 FF00 0080 FF01"
		$"0000 F7FF 0100 0080 FF01 0000 F5FF 02F0"
		$"0000 81FF 0100 00F5 FF80 0080 FF80 00F4"
		$"FF80 0081 FF80 00F2 FF81 0081 FF80 00F1"
		$"FF00 4080 0082 FF81 00D6 FF00 F093 FF82"
		$"0002 4040 F082 FF81 00D9 FF8D 0080 4082"
		$"0002 40FF F082 FF81 00D3 FF9B 0001 F0F0"
		$"83FF 8200 CDFF 9C00 0140 0087 FF82 00CA"
		$"FF9F 0089 FF82 00C7 FF9E 0001 4000 8AFF"
		$"8300 C5FF 9E00 8EFF 8300 C0FF 02F0 F0FF"
		$"9800 0040 8000 01F0 F08F FF84 00C0 FF00"
		$"F09C 0003 FFFF F0F0 8FFF 8400 C0FF 9700"
		$"0340 00F0 F094 FF85 00BF FF93 0004 4040"
		$"00F0 F097 FF88 00BC FF94 0004 40FF FFF0"
		$"F095 FF89 0001 4000 BAFF 9300 9BFF 8C00"
		$"0040 B8FF 9300 9AFF 9000 B6FF 9200 9BFF"
		$"9000 0140 40B4 FF92 0099 FF01 F040 9400"
		$"B3FF 9100 9AFF 9700 B1FF 9200 8DFF 00F0"
		$"88FF 0040 9700 B1FF 9100 8EFF 02F0 FF80"
		$"85FF 0140 4098 00AF FF91 0000 408E FF02"
		$"A580 8085 FF9A 00AD FF01 F0FF 9100 88FF"
		$"0080 83FF 8080 85FF 9B00 00F0 ABFF 01F0"
		$"FF91 0087 FF01 8080 83FF 8080 85FF 9B00"
		$"00F0 ACFF 9200 86FF 8080 83FF 0280 A580"
		$"84FF 01F0 FF9A 00AD FF91 0087 FF80 8083"
		$"FF80 8086 FF9B 00AC FF91 0087 FF80 8001"
		$"F0F0 81FF 8080 85FF 02F0 F040 9900 ACFF"
		$"9100 87FF 8080 84FF 8080 84FF 02F0 F0FF"
		$"9900 ACFF 9100 86FF 00F0 8180 82FF 03F0"
		$"FF80 8088 FF98 00AC FF91 0088 FF80 8090"
		$"FF01 F0FF 9700 ACFF 9200 88FF 8080 8FFF"
		$"02F0 FFFF 9600 ACFF 9200 88FF 03F0 FFFF"
		$"F092 FF92 0001 4000 ACFF 01F0 F091 00A2"
		$"FF93 00AC FF01 F0F0 9200 A2FF 9100 AFFF"
		$"0040 9100 A3FF 9000 00F0 AFFF 9200 01F0"
		$"F08C FF80 F08F FF8D 0000 80B1 FF01 4040"
		$"9000 0240 FFF0 91FF 00F0 8CFF 8B00 0140"
		$"00B2 FF91 0002 4040 F08B FF82 8001 FFF0"
		$"8CFF 8B00 0140 F0B1 FF01 F0FF 9300 01F0"
		$"F089 FF01 F0FF 8280 01F0 F08B FF8A 00B5"
		$"FF93 0000 408C FF83 808C FF89 00B7 FF92"
		$"0001 4040 8BFF 00F0 8280 8CFF 8800 B9FF"
		$"9400 8BFF 8380 8BFF 8700 BBFF 9400 8BFF"
		$"8280 8BFF 8600 BDFF 0040 9300 8AFF 8180"
		$"8CFF 8500 BEFF 00F0 9400 8AFF 0180 808C"
		$"FF00 4083 0000 40C2 FF93 0099 FF84 00C6"
		$"FF92 0094 FF02 F0F0 FF83 00CA FF90 0094"
		$"FF01 F0F0 8300 CDFF 8F00 93FF 0600 4000"
		$"4000 00F0 CDFF 0140 408E 0090 FF80 4080"
		$"00CF FF03 0000 4040 8D00 8FFF 0100 0080"
		$"40CF FF00 4091 0080 FF00 F08A FF01 F0FF"
		$"8000 01FF F0CA FF02 F0FF FF93 00E1 FF02"
		$"F0F0 FF8E 0000 4081 0001 FFF0 E2FF 01F0"
		$"F091 0081 FF00 F0E2 FF01 4040 8E00 00F0"
		$"E8FF 8F00 EAFF 8F00 EAFF 9000 E8FF 00F0"
		$"9200 01F0 F0E5 FF00 F094 00E5 FF98 0000"
		$"F0DF FF01 F0F0 9C00 DDFF A800 8FFF 01F0"
		$"F0BE FFA5 0004 4000 0040 4089 00C4 FFBC"
		$"0000 40BD FFC3 00B7 FFC4 0001 4040 B4FF"
		$"C800 0040 B2FF 0040 CA00 AFFF 0040 CB00"
		$"0040 AEFF CD00 0040 ABFF 01F0 40CF 00AB"
		$"FFD1 00AB FFD0 00AB FFD0 00AB FFD0 00A8"
		$"FF00 F080 FFCF 00AF FFCB 0002 40F0 F0AE"
		$"FFCA 00AB FF00 F085 FFC7 00B9 FFC2 0000"
		$"F0C1 FFB8 00D4 FF01 F0F0 A500 D3FF 01F0"
		$"F086 FF9C 00A3 FF00 F0BA FF02 0000 4096"
		$"00A2 FF00 4089 0004 4040 FFF0 F0AE FF95"
		$"009F FF03 0000 4040 8900 0440 FFFF F0F0"
		$"B0FF 9300 9CFF 00F0 8D00 0080 B7FF 9200"
		$"9AFF 02F0 F040 8C00 B9FF 9100 9CFF 8D00"
		$"9CFF 01F0 F09A FF90 009C FF8C 0092 FF02"
		$"0040 4082 0080 FF01 F0F0 9AFF 8F00 9CFF"
		$"8B00 0240 FFF0 90FF 0400 0040 4000 84FF"
		$"01F0 F09A FF8F 0000 F09B FF8B 0000 4091"
		$"FF81 00A1 FF00 F080 FF8E 0080 FF00 F099"
		$"FF8B 0092 FF81 00A4 FF8E 0081 FF00 F099"
		$"FF8B 0091 FF81 0000 40A3 FF8E 0081 FF01"
		$"F0F0 99FF 8B00 92FF 8200 80FF 00F0 9CFF"
		$"8F00 A0FF 8B00 92FF 8200 0340 FFFF F099"
		$"FF01 0040 8F00 82FF 0000 9BFF 8B00 0040"
		$"92FF 8400 88FF 83F0 84FF 0140 4091 0001"
		$"4040 82FF 0100 009C FF8B 0090 FF02 F0F0"
		$"FFAE 0002 4040 0081 FF03 F0F0 0000 9DFF"
		$"8C00 93FF 0100 40AC 0084 FF01 4000 9FFF"
		$"8C00 94FF AA00 85FF 0140 409E FF02 F0F0"
		$"408C 0002 FFFF F092 FF01 0040 A200 02FF"
		$"FFF0 84FF 8000 A2FF 8D00 96FF 00F0 9400"
		$"0040 8400 01FF F084 FF00 F080 FF03 0000"
		$"4000 A4FF 8D00 0040 9BFF 8E00 0040 8FFF"
		$"0400 4000 0040 A6FF 0040 8D00 9EFF 8AF0"
		$"8DFF 8400 00F0 A6FF 01F0 408E 00AF FF80"
		$"F080 FF00 4083 0001 4000 A9FF 02F0 FFFF"
		$"9100 ABFF 80F0 03FF 0040 4083 00B0 FF95"
		$"0089 FF01 F0F0 89FF 81F0 85FF 8A00 B4FF"
		$"9900 97FF 8C00 0140 00B8 FFBC 0002 4000"
		$"00BD FFBA 0000 40BF FF00 F080 FFB0 0000"
		$"4080 00C7 FF01 F0F0 A400 0140 4083 00CC"
		$"FF01 F0F0 82FF 9F00 8040 0500 00FF FFF0"
		$"F0D8 FF92 0084 FF01 F0F0 FFFF FFFF AAFF",
		/* [20] */
		't8mk',
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0005"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0500 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0505 FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0005 0500"
		$"00FF FFFF FF00 0000 0500 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0005"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 BFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0500 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"DBFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF BFDB DBFF FFFF FFFF"
		$"DBFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF BFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0505 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF BFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"05FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF DBFF"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"DB00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFDB DB00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0500 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF05 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0500 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF05 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFBF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0505 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0505 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 BFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0500 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 9B00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00BF BFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFDB FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFDB 0500 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0005 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFBF BFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00DB"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0005"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFBF FFFF FFFF FFFF DB00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFDB FFDB FFFF 0500 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00DB DBFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF BFBF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00FF FFDB DBFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFBF BFBF"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 BFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0500"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0500 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0005 0500 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0005 05FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00DB DBFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 05FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 05FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FF00 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0505 FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFBF FFFF FFFF"
		$"FFFF FFFF FFFF FF00 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 DBFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 DBFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 05DB FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0500 0000 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0005 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 00FF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0500 0000 0000 0000"
		$"0000 0000 0000 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 00DB FFFF FFFF FFFF FFFF"
		$"FFFF FFFF BFBF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 FFFF DBDB FFFF FFFF FFFF FFFF"
		$"FFFF FFFF BFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0005 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0005"
		$"05BF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FF00 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FF00 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFBF BFFF FFFF FFFF FFFF FFFF"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFDB FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFDB 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0005"
		$"05DB FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF DBFF 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFBF FFFF DB00 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 DBFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF 0500 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 05BF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFBF"
		$"FFFF FFFF FFFF DBFF 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0500 00FF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFBF"
		$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 00FF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"BFFF 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 00FF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF DBFF FF00"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 00FF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF DB00 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0005"
		$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF DBFF FFFF 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0505 FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFDB DBFF"
		$"FFFF FFFF FF00 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0505 0000 0000 00FF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFDB DBBF"
		$"FFFF 0000 0505 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF 0000 0000 0000 0005 0500"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
		$"0000 0000 0000 0000 0000 0000 0000 0000"
	}
};
